/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.camel;

import com.dragn0007.dragnlivestock.entities.camel.CamelBreed;
import com.dragn0007.dragnlivestock.entities.camel.OCamel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OCamelModel
extends DefaultedEntityGeoModel<OCamel> {
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnlivestock", "animations/o_camel.animation.json");
    public static final Map<String, ResourceLocation> TEXTURE_CACHE = new HashMap<String, ResourceLocation>();

    public OCamelModel() {
        super(new ResourceLocation("dragnlivestock", "o_camel"), true);
    }

    public void setCustomAnimations(OCamel animatable, long instanceId, AnimationState<OCamel> animationState) {
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        if (neck != null && animatable.m_20096_()) {
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            float maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(OCamel object) {
        return CamelBreed.Breed.breedFromOrdinal((int)object.getBreed()).resourceLocation;
    }

    public ResourceLocation getTextureResource(OCamel object) {
        return TEXTURE_CACHE.computeIfAbsent(object.getTextureResource(), ResourceLocation::m_135820_);
    }

    public ResourceLocation getAnimationResource(OCamel animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        ASH(new ResourceLocation("dragnlivestock", "textures/entity/camel/ash.png")),
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/camel/black.png")),
        CHESTNUT(new ResourceLocation("dragnlivestock", "textures/entity/camel/chestnut.png")),
        CHOCOLATE(new ResourceLocation("dragnlivestock", "textures/entity/camel/chocolate.png")),
        CREAM(new ResourceLocation("dragnlivestock", "textures/entity/camel/cream.png")),
        DESERT(new ResourceLocation("dragnlivestock", "textures/entity/camel/desert.png")),
        GREY(new ResourceLocation("dragnlivestock", "textures/entity/camel/grey.png")),
        LIGHT_GREY(new ResourceLocation("dragnlivestock", "textures/entity/camel/light_grey.png")),
        LIVER_CHESTNUT(new ResourceLocation("dragnlivestock", "textures/entity/camel/liver_chestnut.png")),
        MAHOGANY(new ResourceLocation("dragnlivestock", "textures/entity/camel/mahogany.png")),
        SANDY(new ResourceLocation("dragnlivestock", "textures/entity/camel/sandy.png")),
        TAN(new ResourceLocation("dragnlivestock", "textures/entity/camel/tan.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/camel/white.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

