/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.cod;

import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.cod.OCodModel;
import com.dragn0007.dragnlivestock.entities.util.AbstractSchoolingOFish;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OCod
extends AbstractSchoolingOFish
implements GeoEntity {
    protected static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/o_cod");
    protected static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/cod");
    protected static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/tfc/tfc_o_cod");
    protected final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OCod.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public OCod(EntityType<? extends OCod> type, Level level) {
        super((EntityType<? extends AbstractSchoolingOFish>)type, level);
    }

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public OCod getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (OCod)((EntityType)EntityTypes.O_COD_ENTITY.get()).m_20615_((Level)serverLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0);
    }

    @Override
    public int getMaxSchoolSize() {
        return 5;
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)Items.f_42458_);
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_11758_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_11759_;
    }

    public SoundEvent m_7975_(DamageSource p_29795_) {
        return SoundEvents.f_11761_;
    }

    @Override
    public SoundEvent getFlopSound() {
        return SoundEvents.f_11760_;
    }

    protected <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double x = this.m_20185_() - this.f_19854_;
        double z = this.m_20189_() - this.f_19856_;
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.01;
        boolean isMoving = x * x + z * z > 1.0E-4;
        AnimationController controller = tAnimationState.getController();
        if (!this.m_20069_()) {
            controller.setAnimation(RawAnimation.begin().then("flop", Animation.LoopType.LOOP));
        }
        if (isMoving) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("swim_sprint", Animation.LoopType.LOOP));
            } else if (currentSpeed < speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("swim", Animation.LoopType.LOOP));
            } else {
                controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public ResourceLocation getTextureResource() {
        return OCodModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }
}

