/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.cow;

import com.dragn0007.dragnlivestock.entities.cow.OCow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OCowModel
extends DefaultedEntityGeoModel<OCow> {
    public static final ResourceLocation FEMALE = new ResourceLocation("dragnlivestock", "geo/cow/o_cow.geo.json");
    public static final ResourceLocation MALE = new ResourceLocation("dragnlivestock", "geo/cow/o_bull.geo.json");
    public static final ResourceLocation OX = new ResourceLocation("dragnlivestock", "geo/cow/ox.geo.json");
    public static final ResourceLocation MEAT_FEMALE = new ResourceLocation("dragnlivestock", "geo/cow/large_cow.geo.json");
    public static final ResourceLocation MEAT_MALE = new ResourceLocation("dragnlivestock", "geo/cow/large_bull.geo.json");
    public static final ResourceLocation MINI_FEMALE = new ResourceLocation("dragnlivestock", "geo/cow/mini_cow.geo.json");
    public static final ResourceLocation MINI_MALE = new ResourceLocation("dragnlivestock", "geo/cow/mini_bull.geo.json");
    public static final ResourceLocation BABY_MODEL = new ResourceLocation("dragnlivestock", "geo/cow/baby_o_cow.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnlivestock", "animations/o_cow.animation.json");

    public OCowModel() {
        super(new ResourceLocation("dragnlivestock", "o_cow"), true);
    }

    public void setCustomAnimations(OCow animatable, long instanceId, AnimationState<OCow> animationState) {
        float maxYaw;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        CoreGeoBone left_ear = this.getAnimationProcessor().getBone("left_ear");
        CoreGeoBone right_ear = this.getAnimationProcessor().getBone("right_ear");
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        if (neck != null && animatable.m_20096_()) {
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null && animatable.m_20096_()) {
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (animatable.getBreed() == 2) {
            left_ear.setRotZ(-10.0f);
            right_ear.setRotZ(10.0f);
        } else {
            left_ear.setRotZ(-5.0f);
            right_ear.setRotZ(5.0f);
        }
    }

    public ResourceLocation getModelResource(OCow object) {
        if (object.m_6162_()) {
            return BABY_MODEL;
        }
        if (object.getBreed() == 10) {
            return OX;
        }
        if (object.isMeatBreed()) {
            if (object.isMale()) {
                return MEAT_MALE;
            }
            return MEAT_FEMALE;
        }
        if (object.isMiniBreed()) {
            if (object.isMale()) {
                return MINI_MALE;
            }
            return MINI_FEMALE;
        }
        if (object.isMale()) {
            return MALE;
        }
        return FEMALE;
    }

    public ResourceLocation getTextureResource(OCow object) {
        return object.getTextureLocation();
    }

    public ResourceLocation getAnimationResource(OCow animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/cow/black.png")),
        BLUE(new ResourceLocation("dragnlivestock", "textures/entity/cow/blue.png")),
        BROWN(new ResourceLocation("dragnlivestock", "textures/entity/cow/brown.png")),
        CHESTNUT(new ResourceLocation("dragnlivestock", "textures/entity/cow/chestnut.png")),
        CREAM(new ResourceLocation("dragnlivestock", "textures/entity/cow/cream.png")),
        DARK_BROWN(new ResourceLocation("dragnlivestock", "textures/entity/cow/dark_brown.png")),
        GREY(new ResourceLocation("dragnlivestock", "textures/entity/cow/grey.png")),
        STRAWBERRY(new ResourceLocation("dragnlivestock", "textures/entity/cow/strawberry.png")),
        TAN(new ResourceLocation("dragnlivestock", "textures/entity/cow/tan.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/cow/white.png")),
        CHOCOLATE(new ResourceLocation("dragnlivestock", "textures/entity/cow/chocolate.png")),
        GOLD(new ResourceLocation("dragnlivestock", "textures/entity/cow/gold.png")),
        MAHOGANY(new ResourceLocation("dragnlivestock", "textures/entity/cow/mahogany.png")),
        SILVER(new ResourceLocation("dragnlivestock", "textures/entity/cow/silver.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

