/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.donkey;

import com.dragn0007.dragnlivestock.client.event.LivestockOverhaulClientEvent;
import com.dragn0007.dragnlivestock.common.gui.ODonkeyMenu;
import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.ai.GroundTieGoal;
import com.dragn0007.dragnlivestock.entities.donkey.ODonkeyModel;
import com.dragn0007.dragnlivestock.entities.horse.OHorse;
import com.dragn0007.dragnlivestock.entities.horse.OHorseModel;
import com.dragn0007.dragnlivestock.entities.mule.OMuleModel;
import com.dragn0007.dragnlivestock.entities.util.AbstractOMount;
import com.dragn0007.dragnlivestock.entities.util.LOAnimations;
import com.dragn0007.dragnlivestock.entities.util.marking_layer.EquineEyeColorOverlay;
import com.dragn0007.dragnlivestock.entities.util.marking_layer.EquineMarkingOverlay;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulClientConfig;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ODonkey
extends AbstractOMount
implements GeoEntity {
    protected static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/o_donkey");
    protected static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/donkey");
    protected static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/donkey");
    protected final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int maxSprint;
    public int sprintTick = this.maxSprint = 20 * (Integer)LivestockOverhaulCommonConfig.BASE_HORSE_SPRINT_TIME.get();
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(ODonkey.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> VARIANT_TEXTURE = SynchedEntityData.m_135353_(ODonkey.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(ODonkey.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> OVERLAY_TEXTURE = SynchedEntityData.m_135353_(ODonkey.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> EYES = SynchedEntityData.m_135353_(ODonkey.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<ItemStack> FLOWER_ITEM = SynchedEntityData.m_135353_(ODonkey.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<Integer> FLOWER_TYPE = SynchedEntityData.m_135353_(ODonkey.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ODonkey(EntityType<? extends ODonkey> type, Level level) {
        super(type, level);
    }

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    @Override
    public void openInventory(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.m_30614_()) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((containerId, inventory, p) -> new ODonkeyMenu(containerId, inventory, (Container)this.f_30520_, this), this.m_5446_()), data -> {
                    data.writeInt(this.m_7506_());
                    data.writeInt(this.m_19879_());
                });
            }
        }
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * (double)0.6f, (double)(this.m_20205_() * 1.0f));
    }

    public static AttributeSupplier.Builder m_30627_() {
        return Mob.m_21552_().m_22266_(Attributes.f_22288_).m_22268_(Attributes.f_22276_, 53.0).m_22268_(Attributes.f_22279_, (double)0.255f).m_22268_(Attributes.f_22281_, 2.0);
    }

    public void randomizeAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.generateRandomMaxHealth());
        this.m_21051_(Attributes.f_22279_).m_22100_(this.generateRandomSpeed());
        this.m_21051_(Attributes.f_22288_).m_22100_(this.generateRandomJumpStrength());
    }

    public int m_7506_() {
        if (this.m_30502_()) {
            return 18;
        }
        return 3;
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new GroundTieGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, true));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.0f));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0, AbstractOMount.class));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, entity -> entity.m_6095_().m_204039_(LOTags.Entity_Types.WOLVES) && entity instanceof TamableAnimal && !((TamableAnimal)entity).m_21824_() && !this.m_6162_()));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, entity -> entity.m_6095_().m_204039_(LOTags.Entity_Types.CATS) && (!(entity instanceof TamableAnimal) || !((TamableAnimal)entity).m_21824_()) && !this.m_6162_()));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, entity -> entity.m_6095_().m_204039_(LOTags.Entity_Types.FOXES) && entity instanceof TamableAnimal && !((TamableAnimal)entity).m_21824_() && !this.m_6162_()));
    }

    public float generateRandomMaxHealth() {
        return 20.0f + (float)this.f_19796_.m_188503_(8) + (float)this.f_19796_.m_188503_(9);
    }

    public double generateRandomJumpStrength() {
        return (double)0.2f + this.f_19796_.m_188500_() * 0.2 + this.f_19796_.m_188500_() * 0.2 + this.f_19796_.m_188500_() * 0.2;
    }

    public double generateRandomSpeed() {
        return ((double)0.35f + this.f_19796_.m_188500_() * 0.3 + this.f_19796_.m_188500_() * 0.3 + this.f_19796_.m_188500_() * 0.3) * 0.25;
    }

    public boolean m_245259_() {
        return false;
    }

    protected <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double x = this.m_20185_() - this.f_19854_;
        double z = this.m_20189_() - this.f_19856_;
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.025;
        double speedRunThreshold = 0.02;
        boolean isMoving = x * x + z * z > 1.0E-4;
        double movementSpeed = this.m_21172_(Attributes.f_22279_);
        double animationSpeed = Math.max(0.1, movementSpeed);
        AnimationController controller = tAnimationState.getController();
        if ((!this.m_30614_() || this.isWearingRodeoHarness()) && this.m_20160_() && !this.m_30616_()) {
            controller.setAnimation(RawAnimation.begin().then("buck", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.3);
        } else if (this.m_30616_()) {
            controller.setAnimation(RawAnimation.begin().then("jump", Animation.LoopType.PLAY_ONCE));
            controller.setAnimationSpeed(1.0);
        } else if (isMoving) {
            if (!LivestockOverhaulClientEvent.HORSE_WALK_BACKWARDS.m_90857_()) {
                if (this.m_5912_() || this.m_20160_() && this.m_21051_(Attributes.f_22279_).m_22109_(SPRINT_SPEED_MOD) || !this.m_20160_() && currentSpeed > speedThreshold) {
                    controller.setAnimation(RawAnimation.begin().then("sprint", Animation.LoopType.LOOP));
                    controller.setAnimationSpeed(Math.max(0.1, 0.82 * controller.getAnimationSpeed() + animationSpeed));
                } else if (this.m_20160_() && !this.m_21051_(Attributes.f_22279_).m_22109_(WALK_SPEED_MOD) && !this.m_21051_(Attributes.f_22279_).m_22109_(SPRINT_SPEED_MOD) || !this.m_20160_() && currentSpeed > speedRunThreshold && currentSpeed < speedThreshold) {
                    if (this.isOnSand()) {
                        controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                        controller.setAnimationSpeed(Math.max(0.1, 0.75 * controller.getAnimationSpeed() + animationSpeed));
                    } else {
                        controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                        controller.setAnimationSpeed(Math.max(0.1, 0.78 * controller.getAnimationSpeed() + animationSpeed));
                    }
                } else if (this.m_20160_() && this.m_21051_(Attributes.f_22279_).m_22109_(WALK_SPEED_MOD)) {
                    if (LivestockOverhaulClientEvent.HORSE_SPANISH_WALK_TOGGLE.m_90857_()) {
                        controller.setAnimation(RawAnimation.begin().then("spanish_walk", Animation.LoopType.LOOP));
                        controller.setAnimationSpeed(Math.max(0.1, 0.78 * controller.getAnimationSpeed() + animationSpeed));
                    } else {
                        controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                        controller.setAnimationSpeed(Math.max(0.1, 0.83 * controller.getAnimationSpeed() + animationSpeed));
                    }
                } else {
                    controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                    controller.setAnimationSpeed(Math.max(0.1, 0.8 * controller.getAnimationSpeed() + animationSpeed));
                }
            } else if (this.m_20160_() && LivestockOverhaulClientEvent.HORSE_WALK_BACKWARDS.m_90857_()) {
                if (this.m_21051_(Attributes.f_22279_).m_22109_(WALK_SPEED_MOD)) {
                    controller.setAnimation(RawAnimation.begin().then("walk_back", Animation.LoopType.LOOP));
                    controller.setAnimationSpeed(Math.max(0.1, 0.76 * controller.getAnimationSpeed() + animationSpeed));
                } else {
                    controller.setAnimation(RawAnimation.begin().then("walk_back", Animation.LoopType.LOOP));
                    controller.setAnimationSpeed(Math.max(0.1, 0.83 * controller.getAnimationSpeed() + animationSpeed));
                }
            }
        } else {
            if (this.m_20160_() || !((Boolean)LivestockOverhaulCommonConfig.GROUND_TIE.get()).booleanValue()) {
                controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            } else {
                controller.setAnimation(RawAnimation.begin().then("ground_tie", Animation.LoopType.LOOP));
            }
            controller.setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    protected <T extends GeoAnimatable> PlayState emotePredicate(AnimationState<T> tAnimationState) {
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving() || !this.shouldEmote) {
            controller.forceAnimationReset();
            controller.stop();
            this.shouldEmote = false;
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
        controllers.add(new AnimationController[]{LOAnimations.genericAttackAnimation(this, LOAnimations.ATTACK)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "emoteController", 5, this::emotePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void m_8119_() {
        double z;
        boolean isMoving;
        LivingEntity controllingPassenger;
        super.m_8119_();
        if (this.isOnSand()) {
            if (!this.hasSlownessEffect()) {
                this.applySlownessEffect();
            }
        } else if (this.hasSlownessEffect()) {
            this.removeSlownessEffect();
        }
        LivingEntity entity = controllingPassenger = this.m_6688_();
        int sprintLeftInSeconds = this.sprintTick / 20;
        double x = this.m_20185_() - this.f_19854_;
        boolean bl = isMoving = x * x + (z = this.m_20189_() - this.f_19856_) * z > 1.0E-4;
        if (this.m_21051_(Attributes.f_22279_).m_22109_(SPRINT_SPEED_MOD) && this.sprintTick > 0 && this.m_217005_() && isMoving) {
            --this.sprintTick;
            if (controllingPassenger != null && this.sprintTick > 0 && controllingPassenger instanceof Player) {
                Player player = (Player)controllingPassenger;
                if (((Boolean)LivestockOverhaulClientConfig.HORSE_SPRINT_TIMER.get()).booleanValue()) {
                    player.m_5661_((Component)Component.m_237115_((String)("Sprint Left: " + sprintLeftInSeconds + "s")).m_130940_(ChatFormatting.GOLD), true);
                }
            }
        }
        if (!this.m_21051_(Attributes.f_22279_).m_22109_(SPRINT_SPEED_MOD) || !isMoving) {
            if (this.sprintTick < this.maxSprint && isMoving) {
                ++this.sprintTick;
            } else if (this.sprintTick < this.maxSprint && !isMoving) {
                ++this.sprintTick;
                ++this.sprintTick;
            }
        }
        if (this.sprintTick <= 0 && controllingPassenger != null) {
            AttributeInstance movementSpeed = this.m_21051_(Attributes.f_22279_);
            this.handleSpeedRequest(-1);
            movementSpeed.m_22130_(SPRINT_SPEED_MOD);
            if (controllingPassenger != null && controllingPassenger instanceof Player) {
                Player player = (Player)controllingPassenger;
                if (((Boolean)LivestockOverhaulClientConfig.HORSE_SPRINT_TIMER.get()).booleanValue()) {
                    player.m_5661_((Component)Component.m_237115_((String)"Sprint Depleted").m_130940_(ChatFormatting.DARK_RED), true);
                }
            }
        } else if (entity == null || !this.m_217005_()) {
            return;
        }
    }

    public void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(entity)) {
            double offsetX = 0.0;
            double offsetY = 0.65;
            double offsetZ = -0.1;
            if (this.m_30616_()) {
                offsetZ = -0.4;
            }
            double radYaw = Math.toRadians(this.m_146908_());
            double offsetXRotated = offsetX * Math.cos(radYaw) - offsetZ * Math.sin(radYaw);
            double offsetYRotated = offsetY;
            double offsetZRotated = offsetX * Math.sin(radYaw) + offsetZ * Math.cos(radYaw);
            double x = this.m_20185_() + offsetXRotated;
            double y = this.m_20186_() + offsetYRotated;
            double z = this.m_20189_() + offsetZRotated;
            entity.m_6034_(x, y, z);
        }
    }

    public SoundEvent m_7515_() {
        super.m_7515_();
        return SoundEvents.f_11809_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_11812_;
    }

    @Nullable
    public SoundEvent m_7872_() {
        return SoundEvents.f_11813_;
    }

    public SoundEvent m_7975_(DamageSource damageSource) {
        super.m_7975_(damageSource);
        return SoundEvents.f_11814_;
    }

    public SoundEvent m_7871_() {
        super.m_7871_();
        return SoundEvents.f_11810_;
    }

    @Override
    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)ODonkeyModel.Variant.variantFromOrdinal((int)variant).resourceLocation.toString());
    }

    @Override
    public String getTextureResource() {
        return (String)this.f_19804_.m_135370_(VARIANT_TEXTURE);
    }

    @Override
    public void setVariantTexture(String variant) {
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)variant);
    }

    @Override
    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    @Override
    public void setOverlayVariant(int variant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)variant);
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)EquineMarkingOverlay.overlayFromOrdinal((int)variant).resourceLocation.toString());
    }

    @Override
    public String getOverlayLocation() {
        return (String)this.f_19804_.m_135370_(OVERLAY_TEXTURE);
    }

    @Override
    public void setOverlayVariantTexture(String variant) {
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)variant);
    }

    public ResourceLocation getEyeTextureResource() {
        return EquineEyeColorOverlay.eyesFromOrdinal((int)this.getEyeVariant()).resourceLocation;
    }

    public int getEyeVariant() {
        return (Integer)this.f_19804_.m_135370_(EYES);
    }

    public void setEyeVariant(int eyeVariant) {
        this.f_19804_.m_135381_(EYES, (Object)eyeVariant);
    }

    @Override
    public ItemStack getFlowerItem() {
        return (ItemStack)this.f_19804_.m_135370_(FLOWER_ITEM);
    }

    @Override
    public void setFlowerItem(ItemStack decorItem) {
        this.f_19804_.m_135381_(FLOWER_ITEM, (Object)decorItem);
    }

    @Override
    public int getFlowerType() {
        return (Integer)this.f_19804_.m_135370_(FLOWER_TYPE);
    }

    @Override
    public void setFlowerType(int decompVariant) {
        this.f_19804_.m_135381_(FLOWER_TYPE, (Object)decompVariant);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Eyes")) {
            this.setEyeVariant(tag.m_128451_("Eyes"));
        }
        if (tag.m_128441_("SprintTime")) {
            this.sprintTick = tag.m_128451_("SprintTime");
        }
        if (tag.m_128441_("Flower_Type")) {
            this.setFlowerType(tag.m_128451_("Flower_Type"));
        }
        if (tag.m_128441_("FlowerItem")) {
            ItemStack decorItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("FlowerItem"));
            this.setFlowerItem(decorItem);
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128405_("Eyes", this.getEyeVariant());
        tag.m_128405_("SprintTime", this.sprintTick);
        tag.m_128405_("Flower_Type", this.getFlowerType());
        if (!this.getFlowerItem().m_41619_()) {
            tag.m_128365_("FlowerItem", (Tag)this.getFlowerItem().m_41739_(new CompoundTag()));
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setGender(random.nextInt(AbstractOMount.Gender.values().length));
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            this.setColor();
            this.setMarking();
        } else {
            this.setVariant(random.nextInt(ODonkeyModel.Variant.values().length));
            this.setOverlayVariant(random.nextInt(EquineMarkingOverlay.values().length));
        }
        if (((Boolean)LivestockOverhaulCommonConfig.EYES_BY_COLOR.get()).booleanValue()) {
            this.setEyeColorByChance();
        } else {
            this.setEyeVariant(random.nextInt(EquineEyeColorOverlay.values().length));
        }
        this.randomizeAttributes();
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    @Override
    public void playEmote(String emoteName, String loopType) {
        AnimationController controller = (AnimationController)this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).getAnimationControllers().get("emoteController");
        controller.forceAnimationReset();
        controller.stop();
        controller.setAnimation(RawAnimation.begin().then(emoteName, Animation.LoopType.fromString((String)loopType)));
        this.shouldEmote = true;
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(VARIANT_TEXTURE, (Object)ODonkeyModel.Variant.BROWN.resourceLocation.toString());
        this.f_19804_.m_135372_(OVERLAY_TEXTURE, (Object)EquineMarkingOverlay.NONE.resourceLocation.toString());
        this.f_19804_.m_135372_(EYES, (Object)0);
        this.f_19804_.m_135372_(FLOWER_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(FLOWER_TYPE, (Object)0);
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof ODonkey) && !(animal instanceof OHorse)) {
            return false;
        }
        if (!this.isSnipped() && !((AbstractOMount)animal).isSnipped()) {
            if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
                return this.m_30628_() && ((AbstractOMount)animal).m_30628_();
            }
            AbstractOMount partner = (AbstractOMount)animal;
            if (this.m_30628_() && partner.m_30628_() && this.getGender() != partner.getGender()) {
                return this.isFemale();
            }
        }
        return false;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        AbstractOMount foal;
        if (ageableMob instanceof OHorse) {
            OHorse partnerHorse = (OHorse)ageableMob;
            foal = (AbstractOMount)((EntityType)EntityTypes.O_MULE_ENTITY.get()).m_20615_((Level)serverLevel);
            int overlayChance = this.f_19796_.m_188503_(10);
            int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partnerHorse.getOverlayVariant() : this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            foal.setVariant(overlay);
            foal.setOverlayVariant(overlay);
            foal.setVariant(this.f_19796_.m_188503_(OMuleModel.Variant.values().length));
            if (partnerHorse.isStockBreed() || partnerHorse.isWarmbloodedBreed() || partnerHorse.isRacingBreed()) {
                foal.setBreed(0);
            }
            if (partnerHorse.isPonyBreed()) {
                foal.setBreed(1);
            }
            if (partnerHorse.isDraftBreed()) {
                foal.setBreed(2);
            }
            foal.setGender(this.f_19796_.m_188503_(AbstractOMount.Gender.values().length));
        } else {
            ODonkey partner = (ODonkey)ageableMob;
            foal = (AbstractOMount)((EntityType)EntityTypes.O_DONKEY_ENTITY.get()).m_20615_((Level)serverLevel);
            int variantChance = this.f_19796_.m_188503_(14);
            int variant = variantChance < 6 ? this.getVariant() : (variantChance < 12 ? partner.getVariant() : this.f_19796_.m_188503_(OHorseModel.Variant.values().length));
            ((ODonkey)foal).setVariant(variant);
            int overlayChance = this.f_19796_.m_188503_(10);
            int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
            ((ODonkey)foal).setOverlayVariant(overlay);
            int eyeColorChance = this.f_19796_.m_188503_(11);
            int eyes = eyeColorChance < 5 ? this.getEyeVariant() : (eyeColorChance < 10 ? partner.getEyeVariant() : this.f_19796_.m_188503_(EquineEyeColorOverlay.values().length));
            ((ODonkey)foal).setEyeVariant(eyes);
            foal.setGender(this.f_19796_.m_188503_(AbstractOMount.Gender.values().length));
            if (this.f_19796_.m_188503_(3) >= 1) {
                ((ODonkey)foal).generateRandomJumpStrength();
                int betterSpeed = (int)Math.max(partner.m_6113_(), (float)(this.f_19796_.m_188503_(10) + 20));
                foal.m_7910_(betterSpeed);
                int betterHealth = (int)Math.max(partner.m_21223_(), (float)(this.f_19796_.m_188503_(20) + 40));
                foal.m_21153_(betterHealth);
            }
        }
        this.m_149508_(ageableMob, (AbstractHorse)foal);
        return foal;
    }

    public void setEyeColorByChance() {
        if (this.getVariant() == 2 || this.getVariant() == 5 || this.getOverlayVariant() == 2 || this.getOverlayVariant() == 8 || this.getOverlayVariant() == 9 || this.getOverlayVariant() == 10 || this.getOverlayVariant() == 15 || this.getOverlayVariant() == 17 || this.getOverlayVariant() == 20 || this.getOverlayVariant() == 24 || this.getOverlayVariant() == 26 || this.getOverlayVariant() == 32 || this.getOverlayVariant() == 34 || this.getOverlayVariant() == 36 || this.getOverlayVariant() == 37 || this.getOverlayVariant() == 38 || this.getOverlayVariant() == 39) {
            if (this.f_19796_.m_188500_() < 0.005) {
                this.setEyeVariant(7 + this.m_217043_().m_188503_(9));
            } else if (this.f_19796_.m_188500_() < 0.1 && this.f_19796_.m_188500_() > 0.005) {
                this.setEyeVariant(6);
            } else if (this.f_19796_.m_188500_() < 0.3 && this.f_19796_.m_188500_() > 0.1) {
                this.setEyeVariant(5);
            } else if (this.f_19796_.m_188500_() > 0.3) {
                this.setEyeVariant(this.m_217043_().m_188503_(4));
            } else {
                this.setEyeVariant(0);
            }
        } else if (this.f_19796_.m_188500_() < 0.005) {
            this.setEyeVariant(7 + this.m_217043_().m_188503_(9));
        } else if (this.f_19796_.m_188500_() < 0.03 && this.f_19796_.m_188500_() > 0.005) {
            this.setEyeVariant(6);
        } else if (this.f_19796_.m_188500_() < 0.1 && this.f_19796_.m_188500_() > 0.03) {
            this.setEyeVariant(5);
        } else if (this.f_19796_.m_188500_() > 0.1) {
            this.setEyeVariant(this.m_217043_().m_188503_(4));
        } else {
            this.setEyeVariant(0);
        }
    }

    public void setColor() {
        if (this.f_19796_.m_188500_() < 0.2) {
            this.setOverlayVariant(this.f_19796_.m_188503_(ODonkeyModel.Variant.values().length));
        } else if (this.f_19796_.m_188500_() > 0.2) {
            int[] variants = new int[]{0, 1, 3, 4};
            int randomIndex = new Random().nextInt(variants.length);
            this.setVariant(variants[randomIndex]);
        }
    }

    public void setMarking() {
        if (this.f_19796_.m_188500_() < 0.2) {
            this.setOverlayVariant(this.f_19796_.m_188503_(EquineMarkingOverlay.values().length));
        } else if (this.f_19796_.m_188500_() > 0.2) {
            int[] variants = new int[]{0, 4, 6, 7, 11, 12, 13, 14, 18, 19, 21, 22, 23, 29, 30, 32, 33, 35, 39, 41, 42, 43};
            int randomIndex = new Random().nextInt(variants.length);
            this.setVariant(variants[randomIndex]);
        }
    }
}

