/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.donkey;

import com.dragn0007.dragnlivestock.entities.donkey.ODonkey;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class ODonkeyModel
extends DefaultedEntityGeoModel<ODonkey> {
    public static final ResourceLocation MODEL = new ResourceLocation("dragnlivestock", "geo/o_donkey.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnlivestock", "animations/o_horse.animation.json");
    public static final ResourceLocation BABY_MODEL = new ResourceLocation("dragnlivestock", "geo/baby_o_donkey.geo.json");
    public static final Map<String, ResourceLocation> TEXTURE_CACHE = new HashMap<String, ResourceLocation>();

    public ODonkeyModel() {
        super(new ResourceLocation("dragnlivestock", "o_donkey"), true);
    }

    public void setCustomAnimations(ODonkey animatable, long instanceId, AnimationState<ODonkey> animationState) {
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        if (neck != null && animatable.m_20096_()) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            float maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(ODonkey object) {
        if (object.m_6162_()) {
            return BABY_MODEL;
        }
        return MODEL;
    }

    public ResourceLocation getTextureResource(ODonkey object) {
        return TEXTURE_CACHE.computeIfAbsent(object.getTextureResource(), ResourceLocation::m_135820_);
    }

    public ResourceLocation getAnimationResource(ODonkey animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BROWN(new ResourceLocation("dragnlivestock", "textures/entity/donkey/brown.png")),
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/donkey/black.png")),
        CREAM(new ResourceLocation("dragnlivestock", "textures/entity/donkey/cream.png")),
        GREY(new ResourceLocation("dragnlivestock", "textures/entity/donkey/grey.png")),
        STRAWBERRY(new ResourceLocation("dragnlivestock", "textures/entity/donkey/strawberry.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/donkey/white.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

