/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.frog;

import com.dragn0007.dragnlivestock.entities.ai.FrogSitOnBlockGoal;
import com.dragn0007.dragnlivestock.entities.ai.OAvoidEntityGoal;
import com.dragn0007.dragnlivestock.entities.frog.OFrogEyeLayer;
import com.dragn0007.dragnlivestock.entities.frog.OFrogMarkingLayer;
import com.dragn0007.dragnlivestock.entities.frog.OFrogModel;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OFrog
extends Animal
implements GeoEntity {
    protected static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/o_frog");
    protected static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/frog");
    protected static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/frog");
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(LOTags.Items.O_FROG_EATS);
    protected final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OFrog.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(OFrog.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> EYES = SynchedEntityData.m_135353_(OFrog.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int eggsLaid = 0;
    public int eggLayCooldown = 0;

    public OFrog(EntityType<? extends OFrog> type, Level level) {
        super(type, level);
    }

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * (double)0.8f, (double)(this.m_20205_() * 0.9f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.18);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(7, (Goal)new FrogSitOnBlockGoal(this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.WOLVES)));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.CATS)));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.HUNTING_DOGS)));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.FOXES)));
    }

    public boolean m_6469_(DamageSource damageSource, float v) {
        if (damageSource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        return super.m_6469_(damageSource, v);
    }

    public float getStepHeight() {
        return 2.0f;
    }

    protected <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double x = this.m_20185_() - this.f_19854_;
        double z = this.m_20189_() - this.f_19856_;
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.01;
        boolean isMoving = x * x + z * z > 1.0E-4;
        AnimationController controller = tAnimationState.getController();
        if (isMoving) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("hop", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(2.0);
            } else {
                controller.setAnimation(RawAnimation.begin().then("hop", Animation.LoopType.LOOP));
            }
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_()) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemStack.m_150930_((Item)LOItems.MARKING_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_()) {
                this.setOverlayVariant(this.getOverlayVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setOverlayVariant(this.getOverlayVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public SoundEvent m_7515_() {
        super.m_7515_();
        return SoundEvents.f_215690_;
    }

    public SoundEvent m_5592_() {
        super.m_5592_();
        return SoundEvents.f_215691_;
    }

    public SoundEvent m_7975_(DamageSource p_30720_) {
        super.m_7975_(p_30720_);
        return SoundEvents.f_215693_;
    }

    public void m_7355_(BlockPos p_28254_, BlockState p_28255_) {
        this.m_5496_(SoundEvents.f_215696_, 0.15f, 1.0f);
    }

    public boolean m_6898_(ItemStack p_28271_) {
        return FOOD_ITEMS.test(p_28271_);
    }

    public boolean m_6162_() {
        return false;
    }

    public void m_6863_(boolean p_218500_) {
    }

    public ResourceLocation getTextureLocation() {
        return OFrogModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    public ResourceLocation getOverlayLocation() {
        return OFrogMarkingLayer.Overlay.overlayFromOrdinal((int)this.getOverlayVariant()).resourceLocation;
    }

    public ResourceLocation getEyesLocation() {
        return OFrogEyeLayer.Overlay.overlayFromOrdinal((int)this.getEyesVariant()).resourceLocation;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    public int getEyesVariant() {
        return (Integer)this.f_19804_.m_135370_(EYES);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void setOverlayVariant(int overlayVariant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)overlayVariant);
    }

    public void setEyesVariant(int eyesVariant) {
        this.f_19804_.m_135381_(EYES, (Object)eyesVariant);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Eyes")) {
            this.setEyesVariant(tag.m_128451_("Eyes"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("Eyes", this.getEyesVariant());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setVariant(random.nextInt(OFrogModel.Variant.values().length));
        this.setOverlayVariant(random.nextInt(OFrogMarkingLayer.Overlay.values().length));
        this.setEyesVariant(random.nextInt(OFrogEyeLayer.Overlay.values().length));
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(EYES, (Object)0);
    }

    public boolean canParent() {
        return !this.m_6162_() && this.m_27593_();
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        return animal instanceof OFrog;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        if (!this.m_27593_() || !this.m_6084_() || this.eggsLaid >= (Integer)LivestockOverhaulCommonConfig.CHICKEN_EGG_LAY_AMOUNT.get()) {
            return null;
        }
        ++this.eggsLaid;
        this.dropFertilizedEgg(serverLevel);
        return null;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.eggsLaid >= (Integer)LivestockOverhaulCommonConfig.CHICKEN_EGG_LAY_AMOUNT.get() && this.eggLayCooldown >= 100) {
            this.eggsLaid = 0;
            this.eggLayCooldown = 0;
        }
    }

    protected void dropFertilizedEgg(ServerLevel serverLevel) {
        ItemStack fertilizedEgg = new ItemStack((ItemLike)Items.f_220223_);
        ItemEntity eggEntity = new ItemEntity((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), fertilizedEgg);
        serverLevel.m_7967_((Entity)eggEntity);
        serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215694_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }
}

