/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.goat;

import com.dragn0007.dragnlivestock.entities.goat.OGoat;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OGoatModel
extends DefaultedEntityGeoModel<OGoat> {
    public static final ResourceLocation MODEL = new ResourceLocation("dragnlivestock", "geo/o_goat.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnlivestock", "animations/o_goat.animation.json");

    public OGoatModel() {
        super(new ResourceLocation("dragnlivestock", "o_goat"), true);
    }

    public void setCustomAnimations(OGoat animatable, long instanceId, AnimationState<OGoat> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(OGoat object) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(OGoat object) {
        return object.getTextureLocation();
    }

    public ResourceLocation getAnimationResource(OGoat animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/goat/black.png")),
        BLUE(new ResourceLocation("dragnlivestock", "textures/entity/goat/blue.png")),
        BROWN(new ResourceLocation("dragnlivestock", "textures/entity/goat/brown.png")),
        CHOCOLATE(new ResourceLocation("dragnlivestock", "textures/entity/goat/chocolate.png")),
        CREAM(new ResourceLocation("dragnlivestock", "textures/entity/goat/cream.png")),
        GREY(new ResourceLocation("dragnlivestock", "textures/entity/goat/grey.png")),
        LIGHT_GREY(new ResourceLocation("dragnlivestock", "textures/entity/goat/light_grey.png")),
        MAHOGANY(new ResourceLocation("dragnlivestock", "textures/entity/goat/mahogany.png")),
        RED(new ResourceLocation("dragnlivestock", "textures/entity/goat/red.png")),
        TAN(new ResourceLocation("dragnlivestock", "textures/entity/goat/tan.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/goat/white.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

