/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.llama;

import com.dragn0007.dragnlivestock.entities.llama.OLlama;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OLlamaModel
extends DefaultedEntityGeoModel<OLlama> {
    public static final ResourceLocation MODEL = new ResourceLocation("dragnlivestock", "geo/o_llama.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnlivestock", "animations/o_llama.animation.json");

    public OLlamaModel() {
        super(new ResourceLocation("dragnlivestock", "o_llama"), true);
    }

    public void setCustomAnimations(OLlama animatable, long instanceId, AnimationState<OLlama> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(OLlama object) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(OLlama object) {
        return object.getTextureLocation();
    }

    public ResourceLocation getAnimationResource(OLlama animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/llama/black.png")),
        BLUE(new ResourceLocation("dragnlivestock", "textures/entity/llama/blue.png")),
        BROWN(new ResourceLocation("dragnlivestock", "textures/entity/llama/brown.png")),
        GREY(new ResourceLocation("dragnlivestock", "textures/entity/llama/grey.png")),
        LIGHT_GREY(new ResourceLocation("dragnlivestock", "textures/entity/llama/light_grey.png")),
        RED(new ResourceLocation("dragnlivestock", "textures/entity/llama/red.png")),
        SANDY(new ResourceLocation("dragnlivestock", "textures/entity/llama/sandy.png")),
        TAN(new ResourceLocation("dragnlivestock", "textures/entity/llama/tan.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/llama/white.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

