/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.axolotl;

import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import com.dragn0007.dragnpets.entities.POEntityTypes;
import com.dragn0007.dragnpets.entities.axolotl.OAxolotlMarkingLayer;
import com.dragn0007.dragnpets.entities.axolotl.OAxolotlModel;
import com.dragn0007.dragnpets.items.POItems;
import com.dragn0007.dragnpets.util.POTags;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OAxolotl
extends Animal
implements GeoEntity,
Bucketable {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/o_axolotl");
    public static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/axolotl");
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(POTags.Items.AXOLOTL_FOOD);
    public final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OAxolotl.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(OAxolotl.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(OAxolotl.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> GILL_LENGTH = SynchedEntityData.m_135353_(OAxolotl.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public OAxolotl(EntityType<? extends OAxolotl> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new AxolotlMoveControl(this);
        this.m_274367_(0.0f);
    }

    public float getStepHeight() {
        return 0.0f;
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(vec3);
        }
    }

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * (double)0.8f, (double)(this.m_20205_() * 0.9f));
    }

    public int m_6062_() {
        return 3000;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    protected void m_142075_(Player player, InteractionHand hand, ItemStack stack) {
        if (stack.m_150930_(Items.f_42459_)) {
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42447_));
        } else {
            super.m_142075_(player, hand, stack);
        }
        if (stack.m_150930_((Item)POItems.O_TROPICAL_FISH_BUCKET.get())) {
            player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42447_));
        } else {
            super.m_142075_(player, hand, stack);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 2.0);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, livingEntity -> {
            boolean isOWolf = livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.WOLVES);
            boolean isOCat = livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.CATS);
            boolean isWolf = livingEntity instanceof Wolf;
            return isOWolf || isWolf || isOCat;
        }));
    }

    public boolean m_6469_(DamageSource damageSource, float v) {
        if (damageSource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        return super.m_6469_(damageSource, v);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)LOItems.BREED_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            return InteractionResult.PASS;
        }
        if (itemStack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_()) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemStack.m_150930_((Item)LOItems.MARKING_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_()) {
                this.setOverlayVariant(this.getOverlayVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setOverlayVariant(this.getOverlayVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    public boolean m_6785_(double p_149183_) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.01;
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving()) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("swim", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(2.0);
            } else {
                controller.setAnimation(RawAnimation.begin().then("swim", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.0);
            }
        } else {
            controller.setAnimation(RawAnimation.begin().then("swim", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(0.6);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public SoundEvent m_7975_(DamageSource p_149161_) {
        return SoundEvents.f_144063_;
    }

    @Nullable
    public SoundEvent m_5592_() {
        return SoundEvents.f_144062_;
    }

    @Nullable
    public SoundEvent m_7515_() {
        return this.m_20069_() ? SoundEvents.f_144065_ : SoundEvents.f_144064_;
    }

    public SoundEvent m_5509_() {
        return SoundEvents.f_144066_;
    }

    public SoundEvent m_5501_() {
        return SoundEvents.f_144067_;
    }

    public boolean m_6898_(ItemStack p_28271_) {
        return FOOD_ITEMS.test(p_28271_);
    }

    public boolean m_6162_() {
        return false;
    }

    public void m_6863_(boolean p_218500_) {
    }

    public ResourceLocation getTextureLocation() {
        return OAxolotlModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    public ResourceLocation getOverlayLocation() {
        return OAxolotlMarkingLayer.Overlay.overlayFromOrdinal((int)this.getOverlayVariant()).resourceLocation;
    }

    public boolean hasShortGills() {
        return this.getGills() == 0;
    }

    public boolean hasLongGills() {
        return this.getGills() == 1;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    public int getGills() {
        return (Integer)this.f_19804_.m_135370_(GILL_LENGTH);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void setOverlayVariant(int overlayVariant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)overlayVariant);
    }

    public void setGills(int gills) {
        this.f_19804_.m_135381_(GILL_LENGTH, (Object)gills);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Gills")) {
            this.setGills(tag.m_128451_("Gills"));
        }
        this.m_27497_(tag.m_128471_("FromBucket"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128379_("FromBucket", this.m_27487_());
        tag.m_128405_("Gills", this.getGills());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setVariant(random.nextInt(OAxolotlModel.Variant.values().length));
        this.setOverlayVariant(random.nextInt(OAxolotlMarkingLayer.Overlay.values().length));
        this.setGills(random.nextInt(Gills.values().length));
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(GILL_LENGTH, (Object)0);
    }

    public void m_6872_(ItemStack itemStack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)itemStack);
        CompoundTag compoundtag = itemStack.m_41784_();
        compoundtag.m_128405_("Variant", this.getVariant());
        compoundtag.m_128405_("Overlay", this.getOverlayVariant());
        compoundtag.m_128405_("Age", this.m_146764_());
    }

    public void m_142278_(CompoundTag compoundTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compoundTag);
        this.setVariant(compoundTag.m_128451_("Variant"));
        this.setOverlayVariant(compoundTag.m_128451_("Overlay"));
        if (compoundTag.m_128441_("Age")) {
            this.m_146762_(compoundTag.m_128451_("Age"));
        }
    }

    public boolean canParent() {
        return !this.m_6162_() && this.m_27593_();
    }

    public boolean m_7848_(Animal animal) {
        return animal instanceof OAxolotl && this.canParent();
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        OAxolotl oAxolotl = (OAxolotl)ageableMob;
        if (ageableMob instanceof OAxolotl) {
            OAxolotl oAxolotl1 = (OAxolotl)ageableMob;
            oAxolotl = (OAxolotl)((EntityType)POEntityTypes.O_AXOLOTL_ENTITY.get()).m_20615_((Level)serverLevel);
            int i = this.f_19796_.m_188503_(9);
            int variant = i < 4 ? this.getVariant() : (i < 8 ? oAxolotl1.getVariant() : this.f_19796_.m_188503_(OAxolotlModel.Variant.values().length));
            int j = this.f_19796_.m_188503_(9);
            int overlay = j < 4 ? this.getOverlayVariant() : (j < 8 ? oAxolotl1.getOverlayVariant() : this.f_19796_.m_188503_(OAxolotlMarkingLayer.Overlay.values().length));
            int k = this.f_19796_.m_188503_(9);
            int gills = k < 4 ? this.getGills() : (k < 8 ? oAxolotl1.getGills() : this.f_19796_.m_188503_(Gills.values().length));
            oAxolotl.setVariant(variant);
            oAxolotl.setOverlayVariant(overlay);
            oAxolotl.setGills(gills);
        }
        return oAxolotl;
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean p_149196_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_149196_);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)POItems.O_AXOLOTL_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_144077_;
    }

    static class AxolotlMoveControl
    extends SmoothSwimmingMoveControl {
        public final OAxolotl oAxolotl;

        public AxolotlMoveControl(OAxolotl oAxolotl) {
            super((Mob)oAxolotl, 85, 10, 0.1f, 0.5f, false);
            this.oAxolotl = oAxolotl;
        }
    }

    public static enum Gills {
        SHORT,
        LONG;

    }
}

