/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.axolotl;

import com.dragn0007.dragnpets.entities.axolotl.OAxolotl;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OAxolotlModel
extends DefaultedEntityGeoModel<OAxolotl> {
    public static final ResourceLocation MODEL = new ResourceLocation("dragnpets", "geo/axolotl_overhaul.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnpets", "animations/axolotl_overhaul.animation.json");

    public OAxolotlModel() {
        super(new ResourceLocation("dragnlivestock", "o-axolotl"), true);
    }

    public void setCustomAnimations(OAxolotl animatable, long instanceId, AnimationState<OAxolotl> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(OAxolotl object) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(OAxolotl object) {
        return object.getTextureLocation();
    }

    public ResourceLocation getAnimationResource(OAxolotl animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        ALBINO(new ResourceLocation("dragnpets", "textures/entity/axolotl/axolotl_albino.png")),
        BLACK(new ResourceLocation("dragnpets", "textures/entity/axolotl/axolotl_black.png")),
        BLUE(new ResourceLocation("dragnpets", "textures/entity/axolotl/axolotl_blue.png")),
        BROWN(new ResourceLocation("dragnpets", "textures/entity/axolotl/axolotl_brown.png")),
        COPPER(new ResourceLocation("dragnpets", "textures/entity/axolotl/axolotl_copper.png")),
        GOLD(new ResourceLocation("dragnpets", "textures/entity/axolotl/axolotl_gold.png")),
        GREEN(new ResourceLocation("dragnpets", "textures/entity/axolotl/axolotl_green.png")),
        GREY(new ResourceLocation("dragnpets", "textures/entity/axolotl/axolotl_grey.png")),
        PINK(new ResourceLocation("dragnpets", "textures/entity/axolotl/axolotl_pink.png")),
        PURPLE(new ResourceLocation("dragnpets", "textures/entity/axolotl/axolotl_purple.png")),
        STONE(new ResourceLocation("dragnpets", "textures/entity/axolotl/axolotl_stone.png")),
        MELANOID_ALBINO(new ResourceLocation("dragnpets", "textures/entity/axolotl/axolotl_melanoid_albino.png")),
        BLUE_CREAM(new ResourceLocation("dragnpets", "textures/entity/axolotl/axolotl_blue_cream.png")),
        BURGUNDY_CREAM(new ResourceLocation("dragnpets", "textures/entity/axolotl/axolotl_burgundy_cream.png")),
        GALAXY_PURPLE(new ResourceLocation("dragnpets", "textures/entity/axolotl/axolotl_galaxy_purple.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

