/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.cat.maine_coon;

import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import com.dragn0007.dragnpets.entities.POEntityTypes;
import com.dragn0007.dragnpets.entities.ai.CatFollowOwnerGoal;
import com.dragn0007.dragnpets.entities.cat.CatMarkingOverlay;
import com.dragn0007.dragnpets.entities.cat.OCat;
import com.dragn0007.dragnpets.entities.cat.OCatEyeLayer;
import com.dragn0007.dragnpets.entities.cat.OCatModel;
import com.dragn0007.dragnpets.util.POTags;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MaineCoon
extends OCat
implements GeoEntity {
    @Nullable
    public OcelotAvoidEntityGoal<Player> ocelotAvoidPlayersGoal;
    @Nullable
    public OcelotTemptGoal temptGoal;
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnpets", "entities/o_ocelot");
    public static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/cat");
    public static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(MaineCoon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(MaineCoon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> PREY_SELECTOR = entity -> {
        EntityType entitytype = entity.m_6095_();
        return entitytype == EntityTypes.O_RABBIT_ENTITY.get() || entitytype == EntityTypes.O_CHICKEN_ENTITY.get() || entitytype == EntityTypes.O_FROG_ENTITY.get() || entitytype == POEntityTypes.MACAW_ENTITY.get() || entitytype == POEntityTypes.COCKATIEL_ENTITY.get() || entitytype == POEntityTypes.RINGNECK_ENTITY.get();
    };
    public final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public boolean toldToWander = false;
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(POTags.Items.CAT_FOOD);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(MaineCoon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(MaineCoon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> EYES = SynchedEntityData.m_135353_(MaineCoon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> COLLARED = SynchedEntityData.m_135353_(MaineCoon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(MaineCoon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public MaineCoon(EntityType<? extends MaineCoon> entityType, Level level) {
        super(entityType, level);
        this.m_7105_(false);
        this.reassessTrustingGoals();
    }

    @Override
    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    @Override
    public void reassessTrustingGoals() {
        if (this.ocelotAvoidPlayersGoal == null) {
            this.ocelotAvoidPlayersGoal = new OcelotAvoidEntityGoal<Player>(this, Player.class, 16.0f, 0.8, 1.33);
        }
        this.f_21345_.m_25363_(this.ocelotAvoidPlayersGoal);
        this.f_21345_.m_25352_(4, this.ocelotAvoidPlayersGoal);
    }

    @Override
    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.temptGoal = new OcelotTemptGoal(this, 0.6, FOOD_ITEMS, true);
        this.f_21345_.m_25352_(3, (Goal)this.temptGoal);
        this.f_21345_.m_25352_(8, (Goal)new OcelotAttackGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.f_21345_.m_25352_(6, (Goal)new CatFollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, PREY_SELECTOR));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 2, true, false, entity -> entity.m_6095_().m_204039_(POTags.Entity_Types.CATS_HUNT) && (entity instanceof TamableAnimal && !((TamableAnimal)entity).m_21824_() || !this.m_21824_() || this.m_21824_() && this.wasToldToWander() && entity instanceof TamableAnimal && !((TamableAnimal)entity).m_21824_())){});
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 3.0);
    }

    @Override
    public <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.02;
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving()) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.5);
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.5);
            }
        } else if (this.m_21825_()) {
            controller.setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        } else if (this.isWagging()) {
            controller.setAnimation(RawAnimation.begin().then("flick_tail", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d0 = this.m_21566_().m_24999_();
            if (d0 == 0.6) {
                this.m_20124_(Pose.CROUCHING);
                this.m_6858_(false);
            } else if (d0 == 1.33) {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(true);
            } else {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(false);
            }
        } else {
            this.m_20124_(Pose.STANDING);
            this.m_6858_(false);
        }
    }

    @Override
    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    @Nullable
    public SoundEvent m_7515_() {
        if (this.m_21824_()) {
            if (this.m_27593_()) {
                return SoundEvents.f_11792_;
            }
            return this.f_19796_.m_188503_(4) == 0 ? SoundEvents.f_11793_ : SoundEvents.f_11785_;
        }
        return SoundEvents.f_11786_;
    }

    @Override
    public int m_8100_() {
        return 120;
    }

    @Override
    public SoundEvent m_7975_(DamageSource p_28160_) {
        return SoundEvents.f_11791_;
    }

    @Override
    public SoundEvent m_5592_() {
        return SoundEvents.f_11787_;
    }

    @Override
    public float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    @Override
    public boolean m_7327_(Entity p_28990_) {
        return p_28990_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.getAttackDamage());
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float v) {
        if (damageSource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(damageSource, v);
    }

    @Override
    public void m_7105_(boolean p_30443_) {
        super.m_7105_(p_30443_);
        if (p_30443_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(10.0);
            this.m_21153_(10.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(2.0);
    }

    @Override
    public boolean wasToldToWander() {
        return this.toldToWander;
    }

    @Override
    public boolean getToldToWander() {
        return this.toldToWander;
    }

    @Override
    public void setToldToWander(boolean toldToWander) {
        this.toldToWander = toldToWander;
    }

    @Override
    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    @Override
    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    @Override
    public void setCollarColor(DyeColor p_30398_) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)p_30398_.m_41060_());
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(EYES, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(COLLARED, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Eyes")) {
            this.setEyes(tag.m_128451_("Eyes"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Wandering")) {
            this.setToldToWander(tag.m_128471_("Wandering"));
        }
        if (tag.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)tag.m_128451_("CollarColor")));
        }
        if (tag.m_128441_("Collared")) {
            this.setCollared(tag.m_128471_("Collared"));
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("Eyes", this.getEyes());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128379_("Wandering", this.getToldToWander());
        tag.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        tag.m_128379_("Collared", this.isCollared());
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            this.setEyeColor();
        } else {
            this.setEyes(random.nextInt(OCatEyeLayer.Eyes.values().length));
        }
        this.setVariant(random.nextInt(OCatModel.Variant.values().length));
        this.setOverlayVariant(random.nextInt(CatMarkingOverlay.values().length));
        this.setGender(random.nextInt(OCat.Gender.values().length));
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    @Override
    public void setEyeColor() {
        if (this.getVariant() == 4 || this.getVariant() == 14 || this.getOverlayVariant() == 85) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setEyes(5);
            } else if (this.f_19796_.m_188500_() < 0.3 && this.f_19796_.m_188500_() > 0.1) {
                this.setEyes(4);
            } else if (this.f_19796_.m_188500_() > 0.3) {
                this.setEyes(this.m_217043_().m_188503_(3));
            } else {
                this.setEyes(0);
            }
        } else if (this.f_19796_.m_188500_() < 0.03) {
            this.setEyes(5);
        } else if (this.f_19796_.m_188500_() < 0.1 && this.f_19796_.m_188500_() > 0.03) {
            this.setEyes(4);
        } else if (this.f_19796_.m_188500_() > 0.1) {
            this.setEyes(this.m_217043_().m_188503_(3));
        } else {
            this.setEyes(0);
        }
    }

    @Override
    public boolean isFemale() {
        return this.getGender() == 0;
    }

    @Override
    public boolean isMale() {
        return this.getGender() == 1;
    }

    @Override
    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    @Override
    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    @Override
    public boolean canParent() {
        return !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    @Override
    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof OCat)) {
            return false;
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return this.canParent() && ((OCat)animal).canParent();
        }
        OCat partner = (OCat)animal;
        if (this.canParent() && partner.canParent() && this.getGender() != partner.getGender()) {
            return this.isFemale();
        }
        return false;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        MaineCoon partner = (MaineCoon)ageableMob;
        MaineCoon kitten = (MaineCoon)((EntityType)POEntityTypes.MAINE_COON_ENTITY.get()).m_20615_((Level)serverLevel);
        int variantChance = this.f_19796_.m_188503_(14);
        int variant = variantChance < 6 ? this.getVariant() : (variantChance < 12 ? partner.getVariant() : this.f_19796_.m_188503_(OCatModel.Variant.values().length));
        kitten.setVariant(variant);
        int overlayChance = this.f_19796_.m_188503_(10);
        int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(CatMarkingOverlay.values().length));
        kitten.setOverlayVariant(overlay);
        int eyeChance = this.f_19796_.m_188503_(10);
        int eyes = eyeChance < 4 ? this.getEyes() : (eyeChance < 8 ? partner.getEyes() : this.f_19796_.m_188503_(OCatEyeLayer.Eyes.values().length));
        kitten.setEyes(eyes);
        int gender = this.f_19796_.m_188503_(OCat.Gender.values().length);
        kitten.setGender(gender);
        return kitten;
    }

    @Override
    public boolean m_6573_(Player p_30396_) {
        return super.m_6573_(p_30396_);
    }

    @Override
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    @Override
    public void m_7822_(byte p_28995_) {
        if (p_28995_ == 41) {
            this.spawnTrustingParticles(true);
        } else if (p_28995_ == 40) {
            this.spawnTrustingParticles(false);
        } else {
            super.m_7822_(p_28995_);
        }
    }

    @Override
    public void spawnTrustingParticles(boolean p_29048_) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!p_29048_) {
            particleoptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    @Override
    public boolean m_20161_() {
        return this.m_6047_() || super.m_20161_();
    }

    static class OcelotAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        public final MaineCoon ocelot;

        public OcelotAvoidEntityGoal(MaineCoon p_29051_, Class<T> p_29052_, float p_29053_, double p_29054_, double p_29055_) {
            super((PathfinderMob)p_29051_, p_29052_, p_29053_, p_29054_, p_29055_, EntitySelector.f_20406_::test);
            this.ocelot = p_29051_;
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }
    }

    static class OcelotTemptGoal
    extends TemptGoal {
        public final MaineCoon ocelot;

        public OcelotTemptGoal(MaineCoon p_29060_, double p_29061_, Ingredient p_29062_, boolean p_29063_) {
            super((PathfinderMob)p_29060_, p_29061_, p_29062_, p_29063_);
            this.ocelot = p_29060_;
        }

        public boolean m_7497_() {
            return super.m_7497_();
        }
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }
}

