/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.dog.doberman;

import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import com.dragn0007.dragnpets.entities.POEntityTypes;
import com.dragn0007.dragnpets.entities.ai.DogFollowOwnerGoal;
import com.dragn0007.dragnpets.entities.ai.DogFollowPackLeaderGoal;
import com.dragn0007.dragnpets.entities.dog.CommonDogModel;
import com.dragn0007.dragnpets.entities.dog.DogMarkingOverlay;
import com.dragn0007.dragnpets.entities.dog.ODog;
import com.dragn0007.dragnpets.util.PetsOverhaulCommonConfig;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Doberman
extends ODog
implements NeutralMob,
GeoEntity {
    public static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(Doberman.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Doberman.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @Nullable
    public UUID persistentAngerTarget;
    public final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Doberman.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(Doberman.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> COLLARED = SynchedEntityData.m_135353_(Doberman.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> CROPPED = SynchedEntityData.m_135353_(Doberman.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> FLUFFY = SynchedEntityData.m_135353_(Doberman.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_VEST_COLOR = SynchedEntityData.m_135353_(Doberman.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> VEST = SynchedEntityData.m_135353_(Doberman.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(Doberman.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Doberman(EntityType<? extends Doberman> entityType, Level level) {
        super(entityType, level);
        this.m_7105_(false);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    @Override
    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ODog.WolfPanicGoal(1.4));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.8, true));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Doberman)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        this.f_21345_.m_25352_(7, (Goal)new DogFollowPackLeaderGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new DogFollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, 2, true, false, entity -> entity instanceof Monster && this.m_21824_() && this.wasToldToGuard()));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Slime.class, 2, true, false, entity -> entity instanceof Slime && this.m_21824_() && this.wasToldToGuard()));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    @Override
    public boolean canWearArmor() {
        return true;
    }

    @Override
    public <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.015;
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving()) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.3);
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.3);
            }
        } else if (this.m_21825_()) {
            controller.setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        } else if (this.isWagging()) {
            controller.setAnimation(RawAnimation.begin().then("wag", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    public void m_8119_() {
        List list;
        super.m_8119_();
        if (this.hasFollowers() && this.m_9236_().f_46441_.m_188503_(200) == 1 && (list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(20.0, 20.0, 20.0))).size() <= 1) {
            this.packSize = 1;
        }
        ++this.regenHealthCounter;
        if (this.m_21223_() < this.m_21233_() && this.regenHealthCounter >= 75 && this.m_21824_() && this.m_6084_() && this.wasToldToGuard()) {
            this.m_21153_(this.m_21223_() + 2.0f);
            this.regenHealthCounter = 0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.7, 0.7, 0.7);
        }
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!(this.m_9236_().f_46443_ || !this.m_21824_() || this.m_21827_() || this.m_21825_() || this.wasToldToGuard())) {
                if (this.m_21830_((LivingEntity)player) && player.m_6144_()) {
                    this.setToldToGuard(true);
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.dragnpets.guarding.tooltip").m_130940_(ChatFormatting.GOLD), true);
                }
                return false;
            }
            if (!this.m_9236_().f_46443_ && this.m_21824_() && !this.m_21827_() && !this.m_21825_() && this.wasToldToGuard()) {
                if (this.m_21830_((LivingEntity)player) && player.m_6144_()) {
                    this.setToldToGuard(false);
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.dragnpets.not_guarding.tooltip").m_130940_(ChatFormatting.GOLD), true);
                }
                return false;
            }
            if (this.m_6673_(damageSource)) {
                return false;
            }
            Entity entity2 = damageSource.m_7639_();
            if (!this.m_9236_().f_46443_) {
                this.m_21839_(false);
            }
            if (entity2 != null && !(entity2 instanceof Player) && !(entity2 instanceof AbstractArrow)) {
                amount = (amount + 1.0f) / 2.0f;
            }
            return super.m_6469_(damageSource, amount);
        }
        if (this.m_6673_(damageSource)) {
            return false;
        }
        Entity entity3 = damageSource.m_7639_();
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        if (entity3 != null && !(entity3 instanceof Player) && !(entity3 instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.m_6469_(damageSource, amount);
    }

    @Override
    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    public void m_7355_(BlockPos p_30415_, BlockState p_30416_) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    @Override
    public SoundEvent m_7515_() {
        if (this.m_21660_()) {
            return SoundEvents.f_12619_;
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    @Override
    public SoundEvent m_7975_(DamageSource p_30424_) {
        return SoundEvents.f_12621_;
    }

    @Override
    public SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    @Override
    public float m_6121_() {
        return 0.4f;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    @Override
    public boolean m_7327_(Entity p_30372_) {
        boolean flag = p_30372_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, p_30372_);
        }
        return flag;
    }

    @Override
    public void m_7105_(boolean p_30443_) {
        super.m_7105_(p_30443_);
        if (p_30443_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(18.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(7.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(3.0);
    }

    @Override
    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    @Override
    public void m_7870_(int p_30404_) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    @Override
    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Override
    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    @Override
    public void m_6925_(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    @Override
    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    @Override
    public void setCollarColor(DyeColor p_30398_) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)p_30398_.m_41060_());
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(CROPPED, (Object)0);
        this.f_19804_.m_135372_(FLUFFY, (Object)0);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(COLLARED, (Object)false);
        this.f_19804_.m_135372_(DATA_VEST_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(VEST, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Fluff")) {
            this.setFluff(tag.m_128451_("Fluff"));
        }
        if (tag.m_128441_("Cropped")) {
            this.setCropped(tag.m_128451_("Cropped"));
        }
        if (tag.m_128441_("Wandering")) {
            this.setToldToWander(tag.m_128471_("Wandering"));
        }
        if (tag.m_128441_("Panicking")) {
            this.setPanicking(tag.m_128471_("Panicking"));
        }
        if (tag.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)tag.m_128451_("CollarColor")));
        }
        if (tag.m_128441_("Collared")) {
            this.setCollared(tag.m_128471_("Collared"));
        }
        if (tag.m_128425_("VestColor", 99)) {
            this.setVestColor(DyeColor.m_41053_((int)tag.m_128451_("VestColor")));
        }
        if (tag.m_128441_("Vest")) {
            this.setVest(tag.m_128471_("Vest"));
        }
        this.m_147285_(this.m_9236_(), tag);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128405_("Cropped", this.getCropped());
        tag.m_128405_("Fluff", this.getFluff());
        tag.m_128379_("Wandering", this.getToldToWander());
        tag.m_128379_("Panicking", this.getPanicking());
        tag.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        tag.m_128379_("Collared", this.isCollared());
        tag.m_128344_("VestColor", (byte)this.getVestColor().m_41060_());
        tag.m_128379_("Vest", this.hasVest());
        this.m_21678_(tag);
    }

    @Override
    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @javax.annotation.Nullable SpawnGroupData data, @javax.annotation.Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            this.setColor();
            this.setMarking();
        } else {
            this.setVariant(random.nextInt(CommonDogModel.Variant.values().length));
            this.setOverlayVariant(random.nextInt(DogMarkingOverlay.values().length));
        }
        this.setGender(random.nextInt(ODog.Gender.values().length));
        this.setFluffChance();
        if (((Boolean)PetsOverhaulCommonConfig.ALLOW_CROPPED_DOG_SPAWNS.get()).booleanValue()) {
            this.setCropChance();
        } else {
            this.setCropped(0);
        }
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    @Override
    public void setCropChance() {
        if (this.f_19796_.m_188500_() <= 0.5) {
            this.setCropped(3);
        } else if (this.f_19796_.m_188500_() > 0.5 && this.f_19796_.m_188500_() < 0.7) {
            this.setCropped(2);
        } else if (this.f_19796_.m_188500_() > 0.7 && this.f_19796_.m_188500_() < 0.9) {
            this.setCropped(1);
        } else {
            this.setCropped(0);
        }
    }

    @Override
    public void setFluffChance() {
        if (this.f_19796_.m_188500_() <= 0.02) {
            this.setFluff(1);
        } else {
            this.setFluff(0);
        }
    }

    @Override
    public void setColor() {
        if (this.f_19796_.m_188500_() < 0.07) {
            this.setVariant(this.f_19796_.m_188503_(CommonDogModel.Variant.values().length));
        } else if (this.f_19796_.m_188500_() > 0.07) {
            int[] variants = new int[]{0, 10};
            int randomIndex = new Random().nextInt(variants.length);
            this.setVariant(variants[randomIndex]);
        }
    }

    @Override
    public void setMarking() {
        if (this.f_19796_.m_188500_() < 0.05) {
            this.setOverlayVariant(this.f_19796_.m_188503_(DogMarkingOverlay.values().length));
        } else if (this.f_19796_.m_188500_() > 0.05 && this.f_19796_.m_188500_() < 0.2) {
            this.setOverlayVariant(0);
        } else if (this.f_19796_.m_188500_() > 0.2) {
            this.setOverlayVariant(4);
        }
    }

    @Override
    public boolean isFemale() {
        return this.getGender() == 0;
    }

    @Override
    public boolean isMale() {
        return this.getGender() == 1;
    }

    @Override
    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    @Override
    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    @Override
    public boolean canParent() {
        return !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    @Override
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        ODog pup = null;
        Doberman partner = (Doberman)ageableMob;
        if (ageableMob instanceof Doberman) {
            pup = (ODog)((EntityType)POEntityTypes.DOBERMAN_ENTITY.get()).m_20615_((Level)serverLevel);
            int variantChance = this.f_19796_.m_188503_(14);
            int variant = variantChance < 6 ? this.getVariant() : (variantChance < 12 ? partner.getVariant() : this.f_19796_.m_188503_(CommonDogModel.Variant.values().length));
            pup.setVariant(variant);
            int overlayChance = this.f_19796_.m_188503_(10);
            int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(DogMarkingOverlay.values().length));
            pup.setOverlayVariant(overlay);
            int fluffyChance = this.f_19796_.m_188503_(10);
            int fluff = fluffyChance < 5 ? this.getFluff() : partner.getFluff();
            pup.setFluff(fluff);
            int gender = this.f_19796_.m_188503_(ODog.Gender.values().length);
            pup.setGender(gender);
            if (((Boolean)PetsOverhaulCommonConfig.ALLOW_CROPPED_DOG_SPAWNS.get()).booleanValue()) {
                pup.setCropChance();
            } else {
                pup.setCropped(0);
            }
        }
        return pup;
    }

    @Override
    public boolean m_7757_(LivingEntity entity, LivingEntity p_30390_) {
        if (!(entity instanceof Creeper) && !(entity instanceof Ghast)) {
            if (entity instanceof Doberman) {
                Doberman wolf = (Doberman)entity;
                return !wolf.m_21824_() || wolf.m_269323_() != p_30390_;
            }
            if (entity instanceof Player && p_30390_ instanceof Player && !((Player)p_30390_).m_7099_((Player)entity)) {
                return false;
            }
            if (entity instanceof AbstractHorse && ((AbstractHorse)entity).m_30614_()) {
                return false;
            }
            return !(entity instanceof TamableAnimal) || !((TamableAnimal)entity).m_21824_();
        }
        return false;
    }

    @Override
    public boolean m_6573_(Player player) {
        return !this.m_21660_() && super.m_6573_(player);
    }

    @Override
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }
}

