/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.dog.husky;

import com.dragn0007.dragnlivestock.entities.Chestable;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import com.dragn0007.dragnpets.entities.POEntityTypes;
import com.dragn0007.dragnpets.entities.ai.DogFollowOwnerGoal;
import com.dragn0007.dragnpets.entities.ai.DogFollowPackLeaderGoal;
import com.dragn0007.dragnpets.entities.dog.CommonDogModel;
import com.dragn0007.dragnpets.entities.dog.DogMarkingOverlay;
import com.dragn0007.dragnpets.entities.dog.ODog;
import com.dragn0007.dragnpets.gui.HuskyMenu;
import com.dragn0007.dragnpets.util.PetsOverhaulCommonConfig;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Husky
extends ODog
implements NeutralMob,
GeoEntity,
Chestable,
ContainerListener {
    public static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(Husky.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Husky.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @org.jetbrains.annotations.Nullable
    public UUID persistentAngerTarget;
    public boolean hitchedToSled = false;
    public final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Boolean> CHESTED = SynchedEntityData.m_135353_(Husky.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Husky.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(Husky.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> COLLARED = SynchedEntityData.m_135353_(Husky.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> CROPPED = SynchedEntityData.m_135353_(Husky.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> FLUFFY = SynchedEntityData.m_135353_(Husky.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_VEST_COLOR = SynchedEntityData.m_135353_(Husky.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> VEST = SynchedEntityData.m_135353_(Husky.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(Husky.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public SimpleContainer inventory;
    public LazyOptional<?> itemHandler = null;

    public Husky(EntityType<? extends Husky> entityType, Level level) {
        super(entityType, level);
        this.m_7105_(false);
        this.updateInventory();
    }

    public boolean isHitchedToSled() {
        return this.hitchedToSled;
    }

    @Override
    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ODog.WolfPanicGoal(1.4));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Husky)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        this.f_21345_.m_25352_(7, (Goal)new DogFollowPackLeaderGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new DogFollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.26f).m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    @Override
    public boolean canWearArmor() {
        return true;
    }

    @Override
    public <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.015;
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving()) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.3);
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.3);
            }
        } else if (this.m_21825_()) {
            controller.setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        } else if (this.isWagging()) {
            controller.setAnimation(RawAnimation.begin().then("wag", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.isChested() && itemstack.m_150930_(Blocks.f_50087_.m_5456_()) && this.m_21830_((LivingEntity)player) && !this.m_6162_()) {
            this.playChestEquipsSound();
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.setChested(true);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_21830_((LivingEntity)player) && !itemstack.m_150930_(Items.f_42574_) && this.isChested() && !this.m_6162_() && this.m_21824_() && player.m_36341_() && this.m_21827_()) {
            this.openInventory(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_(Items.f_42574_) && player.m_6144_() && this.m_21830_((LivingEntity)player) && !this.m_6162_() && this.isChested()) {
            this.m_5907_();
            this.inventory.m_19195_();
            this.setChested(false);
            this.playChestEquipsSound();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_7355_(BlockPos p_30415_, BlockState p_30416_) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    @Override
    public SoundEvent m_7515_() {
        if (this.m_21660_()) {
            return SoundEvents.f_12619_;
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    @Override
    public SoundEvent m_7975_(DamageSource p_30424_) {
        return SoundEvents.f_12621_;
    }

    @Override
    public SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    @Override
    public float m_6121_() {
        return 0.4f;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        Entity entity = damageSource.m_7639_();
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.m_6469_(damageSource, amount);
    }

    @Override
    public boolean m_7327_(Entity p_30372_) {
        boolean flag = p_30372_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, p_30372_);
        }
        return flag;
    }

    @Override
    public void m_7105_(boolean p_30443_) {
        super.m_7105_(p_30443_);
        if (p_30443_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(18.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(7.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(2.5);
    }

    @Override
    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    @Override
    public void m_7870_(int p_30404_) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    @Override
    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    @Override
    public void m_6925_(@org.jetbrains.annotations.Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    @Override
    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    @Override
    public void setCollarColor(DyeColor p_30398_) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)p_30398_.m_41060_());
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(CROPPED, (Object)0);
        this.f_19804_.m_135372_(FLUFFY, (Object)0);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(COLLARED, (Object)false);
        this.f_19804_.m_135372_(DATA_VEST_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(VEST, (Object)false);
        this.f_19804_.m_135372_(CHESTED, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Fluff")) {
            this.setFluff(tag.m_128451_("Fluff"));
        }
        if (tag.m_128441_("Cropped")) {
            this.setCropped(tag.m_128451_("Cropped"));
        }
        if (tag.m_128441_("Wandering")) {
            this.setToldToWander(tag.m_128471_("Wandering"));
        }
        if (tag.m_128441_("Panicking")) {
            this.setPanicking(tag.m_128471_("Panicking"));
        }
        if (tag.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)tag.m_128451_("CollarColor")));
        }
        if (tag.m_128441_("Collared")) {
            this.setCollared(tag.m_128471_("Collared"));
        }
        if (tag.m_128425_("VestColor", 99)) {
            this.setVestColor(DyeColor.m_41053_((int)tag.m_128451_("VestColor")));
        }
        if (tag.m_128441_("Vest")) {
            this.setVest(tag.m_128471_("Vest"));
        }
        if (tag.m_128441_("Chested")) {
            this.setChested(tag.m_128471_("Chested"));
        }
        this.m_147285_(this.m_9236_(), tag);
        this.updateInventory();
        if (this.m_21824_()) {
            ListTag listTag = tag.m_128437_("Items", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag = listTag.m_128728_(i);
                int j = compoundTag.m_128445_("Slot") & 0xFF;
                if (j >= this.inventory.m_6643_()) continue;
                this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundTag));
            }
        }
        this.m_21553_(true);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128405_("Cropped", this.getCropped());
        tag.m_128405_("Fluff", this.getFluff());
        tag.m_128379_("Wandering", this.getToldToWander());
        tag.m_128379_("Panicking", this.getPanicking());
        tag.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        tag.m_128379_("Collared", this.isCollared());
        tag.m_128344_("VestColor", (byte)this.getVestColor().m_41060_());
        tag.m_128379_("Vest", this.hasVest());
        this.m_21678_(tag);
        tag.m_128379_("Chested", this.isChested());
        if (this.m_21824_()) {
            ListTag listTag = new ListTag();
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemStack = this.inventory.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.m_128344_("Slot", (byte)i);
                itemStack.m_41739_(compoundTag);
                listTag.add((Object)compoundTag);
            }
            tag.m_128365_("Items", (Tag)listTag);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            this.setColor();
            this.setMarking();
        } else {
            this.setVariant(random.nextInt(CommonDogModel.Variant.values().length));
            this.setOverlayVariant(random.nextInt(DogMarkingOverlay.values().length));
        }
        this.setGender(random.nextInt(ODog.Gender.values().length));
        this.setFluffChance();
        if (((Boolean)PetsOverhaulCommonConfig.ALLOW_CROPPED_DOG_SPAWNS.get()).booleanValue()) {
            this.setCropChance();
        } else {
            this.setCropped(0);
        }
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    @Override
    public void setCropChance() {
        if (this.f_19796_.m_188500_() <= 0.02) {
            this.setCropped(3);
        } else if (this.f_19796_.m_188500_() > 0.02 && this.f_19796_.m_188500_() < 0.07) {
            this.setCropped(2);
        } else if (this.f_19796_.m_188500_() > 0.07 && this.f_19796_.m_188500_() < 0.95) {
            this.setCropped(1);
        } else {
            this.setCropped(0);
        }
    }

    @Override
    public void setFluffChance() {
        if (this.f_19796_.m_188500_() <= 0.9) {
            this.setFluff(1);
        } else {
            this.setFluff(0);
        }
    }

    @Override
    public void setColor() {
        if (this.f_19796_.m_188500_() < 0.07) {
            this.setVariant(this.f_19796_.m_188503_(CommonDogModel.Variant.values().length));
        } else if (this.f_19796_.m_188500_() > 0.07) {
            int[] variants = new int[]{0, 1, 2};
            int randomIndex = new Random().nextInt(variants.length);
            this.setVariant(variants[randomIndex]);
        }
    }

    @Override
    public void setMarking() {
        if (this.f_19796_.m_188500_() < 0.05) {
            this.setOverlayVariant(this.f_19796_.m_188503_(DogMarkingOverlay.values().length));
        } else {
            this.setOverlayVariant(12);
        }
    }

    @Override
    public boolean isFemale() {
        return this.getGender() == 0;
    }

    @Override
    public boolean isMale() {
        return this.getGender() == 1;
    }

    @Override
    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    @Override
    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    @Override
    public boolean canParent() {
        return !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    @Override
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        ODog pup = null;
        Husky partner = (Husky)ageableMob;
        if (ageableMob instanceof Husky) {
            pup = (ODog)((EntityType)POEntityTypes.HUSKY_ENTITY.get()).m_20615_((Level)serverLevel);
            int variantChance = this.f_19796_.m_188503_(14);
            int variant = variantChance < 6 ? this.getVariant() : (variantChance < 12 ? partner.getVariant() : this.f_19796_.m_188503_(CommonDogModel.Variant.values().length));
            pup.setVariant(variant);
            int overlayChance = this.f_19796_.m_188503_(10);
            int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(DogMarkingOverlay.values().length));
            pup.setOverlayVariant(overlay);
            int fluffyChance = this.f_19796_.m_188503_(10);
            int fluff = fluffyChance < 5 ? this.getFluff() : partner.getFluff();
            pup.setFluff(fluff);
            int gender = this.f_19796_.m_188503_(ODog.Gender.values().length);
            pup.setGender(gender);
            if (((Boolean)PetsOverhaulCommonConfig.ALLOW_CROPPED_DOG_SPAWNS.get()).booleanValue()) {
                pup.setCropChance();
            } else {
                pup.setCropped(0);
            }
        }
        return pup;
    }

    public boolean isChestable() {
        return this.m_6084_() && !this.m_6162_();
    }

    public void equipChest(@Nullable SoundSource soundSource) {
        if (soundSource != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12078_, soundSource, 0.5f, 1.0f);
        }
    }

    public void updateInventory() {
        SimpleContainer tempInventory = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (tempInventory != null) {
            tempInventory.m_19181_((ContainerListener)this);
            int maxSize = Math.min(tempInventory.m_6643_(), this.inventory.m_6643_());
            for (int i = 0; i < maxSize; ++i) {
                ItemStack itemStack = tempInventory.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                this.inventory.m_6836_(i, itemStack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    public boolean isChested() {
        return (Boolean)this.f_19804_.m_135370_(CHESTED);
    }

    public void setChested(boolean chested) {
        this.f_19804_.m_135381_(CHESTED, (Object)chested);
    }

    public void m_5907_() {
        if (!this.m_9236_().f_46443_) {
            super.m_5907_();
            if (this.isChested()) {
                this.m_19998_((ItemLike)Items.f_42009_);
            }
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this.inventory);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public int getInventorySize() {
        return 12;
    }

    public void playChestEquipsSound() {
        this.m_5496_(SoundEvents.f_12094_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    public void openInventory(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.m_21824_()) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((containerId, inventory, p) -> new HuskyMenu(containerId, inventory, (Container)this.inventory, this), this.m_5446_()), data -> {
                    data.writeInt(this.getInventorySize());
                    data.writeInt(this.m_19879_());
                });
            }
        }
    }

    public void m_5757_(Container p_18983_) {
    }

    @Override
    public boolean m_7757_(LivingEntity entity, LivingEntity p_30390_) {
        if (!(entity instanceof Creeper) && !(entity instanceof Ghast)) {
            if (entity instanceof Husky) {
                Husky wolf = (Husky)entity;
                return !wolf.m_21824_() || wolf.m_269323_() != p_30390_;
            }
            if (entity instanceof Player && p_30390_ instanceof Player && !((Player)p_30390_).m_7099_((Player)entity)) {
                return false;
            }
            if (entity instanceof AbstractHorse && ((AbstractHorse)entity).m_30614_()) {
                return false;
            }
            return !(entity instanceof TamableAnimal) || !((TamableAnimal)entity).m_21824_();
        }
        return false;
    }

    @Override
    public boolean m_6573_(Player player) {
        return !this.m_21660_() && super.m_6573_(player);
    }

    @Override
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }
}

