/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.dog.rottweiler;

import com.dragn0007.dragnpets.entities.dog.rottweiler.Rottweiler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class RottweilerModel
extends DefaultedEntityGeoModel<Rottweiler> {
    public static final ResourceLocation MODEL = new ResourceLocation("dragnpets", "geo/dog/rottweiler.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnpets", "animations/dog.animation.json");

    public RottweilerModel() {
        super(new ResourceLocation("dragnlivestock", "rottweiler"), true);
    }

    public void setCustomAnimations(Rottweiler animatable, long instanceId, AnimationState<Rottweiler> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(Rottweiler object) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(Rottweiler object) {
        return object.getTextureLocation();
    }

    public ResourceLocation getAnimationResource(Rottweiler animatable) {
        return ANIMATION;
    }
}

