/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.dog.whippet;

import com.dragn0007.dragnpets.entities.dog.whippet.Whippet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class WhippetModel
extends DefaultedEntityGeoModel<Whippet> {
    public static final ResourceLocation MODEL = new ResourceLocation("dragnpets", "geo/dog/whippet.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnpets", "animations/dog.animation.json");

    public WhippetModel() {
        super(new ResourceLocation("dragnlivestock", "whippet"), true);
    }

    public void setCustomAnimations(Whippet animatable, long instanceId, AnimationState<Whippet> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(Whippet object) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(Whippet object) {
        return object.getTextureLocation();
    }

    public ResourceLocation getAnimationResource(Whippet animatable) {
        return ANIMATION;
    }
}

