/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.fox;

import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import com.dragn0007.dragnpets.entities.POEntityTypes;
import com.dragn0007.dragnpets.entities.ai.FoxFollowOwnerGoal;
import com.dragn0007.dragnpets.entities.fox.OFoxMarkingLayer;
import com.dragn0007.dragnpets.entities.fox.OFoxModel;
import com.dragn0007.dragnpets.util.POTags;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OFox
extends TamableAnimal
implements GeoEntity {
    public Goal turtleEggTargetGoal;
    public Goal fishTargetGoal;
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnpets", "entities/o_fox");
    public static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/fox");
    private static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/fox");
    public static final Predicate<LivingEntity> PREY_SELECTOR = entity -> {
        EntityType entitytype = entity.m_6095_();
        return entitytype == EntityTypes.O_RABBIT_ENTITY.get() || entitytype == EntityTypes.O_CHICKEN_ENTITY.get() || entitytype == EntityTypes.O_FROG_ENTITY.get() || entitytype == POEntityTypes.O_CAT_ENTITY.get();
    };
    public final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int regenHealthCounter = 0;
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(POTags.Items.FOX_FOOD);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OFox.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(OFox.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public boolean toldToWander = false;
    public static final EntityDataAccessor<Boolean> COLLARED = SynchedEntityData.m_135353_(OFox.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(OFox.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(OFox.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public OFox(EntityType<? extends OFox> entityType, Level level) {
        super(entityType, level);
        this.m_7105_(false);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 24.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.f_21345_.m_25352_(6, (Goal)new FoxFollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, PREY_SELECTOR));
        this.fishTargetGoal = new NearestAttackableTargetGoal((Mob)this, AbstractFish.class, 20, false, false, p_28600_ -> p_28600_ instanceof AbstractSchoolingFish);
        this.f_21345_.m_25352_(0, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.m_9236_()));
        this.f_21345_.m_25352_(10, (Goal)new FoxEatBerriesGoal(1.2f, 12, 1));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, entity -> entity.m_6095_().m_204039_(LOTags.Entity_Types.WOLVES) && !this.m_21824_() || entity.m_6095_().m_204039_(LOTags.Entity_Types.WOLVES) && entity instanceof TamableAnimal && !((TamableAnimal)entity).m_21824_() && this.m_21824_()));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, entity -> entity.m_6095_().m_204039_(LOTags.Entity_Types.HUNTING_DOGS) && !this.m_21824_() || entity.m_6095_().m_204039_(LOTags.Entity_Types.HUNTING_DOGS) && entity instanceof TamableAnimal && !((TamableAnimal)entity).m_21824_() && this.m_21824_()));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 2, true, false, entity -> entity.m_6095_().m_204039_(POTags.Entity_Types.FOXES_HUNT) && (entity instanceof TamableAnimal && !((TamableAnimal)entity).m_21824_() || !this.m_21824_() || this.m_21824_() && this.wasToldToWander() && entity instanceof TamableAnimal && !((TamableAnimal)entity).m_21824_())){});
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.02;
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving()) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.3);
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.3);
            }
        } else if (this.m_21825_()) {
            controller.setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_;
    }

    public SoundEvent m_7866_(ItemStack p_28540_) {
        return SoundEvents.f_11947_;
    }

    public boolean m_6107_() {
        return this.m_21224_();
    }

    public float getStepHeight() {
        return 1.6f;
    }

    public float m_6121_() {
        return 0.4f;
    }

    @Nullable
    public SoundEvent m_7515_() {
        return SoundEvents.f_11944_;
    }

    public SoundEvent m_7975_(DamageSource p_29035_) {
        return SoundEvents.f_11948_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_11946_;
    }

    public float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public boolean m_7327_(Entity p_28990_) {
        return p_28990_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.getAttackDamage());
    }

    public void m_7105_(boolean p_30443_) {
        super.m_7105_(p_30443_);
        if (p_30443_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(10.0);
            this.m_21153_(10.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(2.0);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.regenHealthCounter;
        if (this.m_21223_() < this.m_21233_() && this.regenHealthCounter >= 150 && this.m_21824_() && this.m_6084_()) {
            this.m_21153_(this.m_21223_() + 2.0f);
            this.regenHealthCounter = 0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.7, 0.7, 0.7);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (itemstack.m_150930_((Item)LOItems.BREED_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            return InteractionResult.PASS;
        }
        if (itemstack.m_150930_(Items.f_42574_) && this.isCollared()) {
            this.setCollared(false);
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isFemale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.FEMALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isMale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.MALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_()) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.MARKING_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_()) {
                this.setOverlayVariant(this.getOverlayVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setOverlayVariant(this.getOverlayVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (player.m_6144_() && !this.m_6898_(itemstack) && !this.m_21827_() && !this.wasToldToWander() && this.m_21830_((LivingEntity)player)) {
            this.setToldToWander(true);
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.dragnpets.wandering.tooltip").m_130940_(ChatFormatting.GOLD), true);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && !this.m_6898_(itemstack) && !this.m_21827_() && this.wasToldToWander() && this.m_21830_((LivingEntity)player)) {
            this.setToldToWander(false);
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.dragnpets.following.tooltip").m_130940_(ChatFormatting.GOLD), true);
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || itemstack.m_204117_(POTags.Items.FOX_FOOD) && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (item instanceof DyeItem) {
                return super.m_6071_(player, hand);
            }
            InteractionResult interactionresult = super.m_6071_(player, hand);
            if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (itemstack.m_204117_(POTags.Items.FOX_FOOD)) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public ResourceLocation getTextureLocation() {
        return OFoxModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public ResourceLocation getOverlayLocation() {
        return OFoxMarkingLayer.Overlay.overlayFromOrdinal((int)this.getOverlayVariant()).resourceLocation;
    }

    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    public void setOverlayVariant(int overlayVariant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)overlayVariant);
    }

    public boolean wasToldToWander() {
        return this.toldToWander;
    }

    public boolean getToldToWander() {
        return this.toldToWander;
    }

    public void setToldToWander(boolean toldToWander) {
        this.toldToWander = toldToWander;
    }

    public boolean isCollared() {
        return (Boolean)this.f_19804_.m_135370_(COLLARED);
    }

    public void setCollared(boolean collared) {
        this.f_19804_.m_135381_(COLLARED, (Object)collared);
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor p_30398_) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)p_30398_.m_41060_());
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(COLLARED, (Object)false);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Wandering")) {
            this.setToldToWander(tag.m_128471_("Wandering"));
        }
        if (tag.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)tag.m_128451_("CollarColor")));
        }
        if (tag.m_128441_("Collared")) {
            this.setCollared(tag.m_128471_("Collared"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128379_("Wandering", this.getToldToWander());
        tag.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        tag.m_128379_("Collared", this.isCollared());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setGender(random.nextInt(Gender.values().length));
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            this.setColor();
            this.setMarking();
        } else {
            this.setVariant(random.nextInt(OFoxModel.Variant.values().length));
            this.setOverlayVariant(random.nextInt(OFoxMarkingLayer.Overlay.values().length));
        }
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public void setColor() {
        if (this.f_19796_.m_188500_() < 0.05) {
            int[] variants = new int[]{0, 1, 2, 3, 4, 6, 9, 10, 11};
            int randomIndex = new Random().nextInt(variants.length);
            this.setVariant(variants[randomIndex]);
        } else if (this.f_19796_.m_188500_() > 0.1) {
            int[] variants = new int[]{5, 7, 8, 12};
            int randomIndex = new Random().nextInt(variants.length);
            this.setVariant(variants[randomIndex]);
        }
    }

    public void setMarking() {
        int randomIndex;
        int[] variants;
        if (this.getVariant() != 5 || this.getVariant() != 7 || this.getVariant() != 8 || this.getVariant() != 12) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OFoxMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1) {
                variants = new int[]{1, 2, 3};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getVariant() == 5 || this.getVariant() == 7 || this.getVariant() == 8) {
            if (this.f_19796_.m_188500_() < 0.02) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OFoxMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.02) {
                variants = new int[]{1, 2, 3};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getVariant() == 12) {
            if (this.f_19796_.m_188500_() < 0.02) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OFoxMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.02) {
                variants = new int[]{10, 11, 12};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
    }

    public boolean isFemale() {
        return this.getGender() == 0;
    }

    public boolean isMale() {
        return this.getGender() == 1;
    }

    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    public boolean canParent() {
        return !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof OFox)) {
            return false;
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return this.canParent() && ((OFox)animal).canParent();
        }
        OFox partner = (OFox)animal;
        if (this.canParent() && partner.canParent() && this.getGender() != partner.getGender()) {
            return true;
        }
        boolean partnerIsFemale = partner.isFemale();
        boolean partnerIsMale = partner.isMale();
        if (((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue() && this.canParent() && partner.canParent() && (this.isFemale() && partnerIsMale || this.isMale() && partnerIsFemale)) {
            return this.isFemale();
        }
        return false;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        OFox partner = (OFox)ageableMob;
        OFox pup = (OFox)((EntityType)POEntityTypes.O_FOX_ENTITY.get()).m_20615_((Level)serverLevel);
        int variantChance = this.f_19796_.m_188503_(14);
        int variant = variantChance < 6 ? this.getVariant() : (variantChance < 12 ? partner.getVariant() : this.f_19796_.m_188503_(OFoxModel.Variant.values().length));
        pup.setVariant(variant);
        int overlayChance = this.f_19796_.m_188503_(10);
        int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(OFoxMarkingLayer.Overlay.values().length));
        pup.setOverlayVariant(overlay);
        int gender = this.f_19796_.m_188503_(Gender.values().length);
        pup.setGender(gender);
        return pup;
    }

    public boolean m_6573_(Player p_30396_) {
        return super.m_6573_(p_30396_);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public class FoxEatBerriesGoal
    extends MoveToBlockGoal {
        public static final int WAIT_TICKS = 40;
        public int ticksWaited;

        public FoxEatBerriesGoal(double p_28675_, int p_28676_, int p_28677_) {
            super((PathfinderMob)OFox.this, p_28675_, p_28676_, p_28677_);
        }

        public double m_8052_() {
            return 2.0;
        }

        public boolean m_8064_() {
            return this.f_25601_ % 100 == 0;
        }

        public boolean m_6465_(LevelReader p_28680_, BlockPos p_28681_) {
            BlockState blockstate = p_28680_.m_8055_(p_28681_);
            return blockstate.m_60713_(Blocks.f_50685_) && (Integer)blockstate.m_61143_((Property)SweetBerryBushBlock.f_57244_) >= 2 || CaveVines.m_152951_((BlockState)blockstate);
        }

        public void m_8037_() {
            if (this.m_25625_()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            } else if (!this.m_25625_() && OFox.this.f_19796_.m_188501_() < 0.05f) {
                OFox.this.m_5496_(SoundEvents.f_11951_, 1.0f, 1.0f);
            }
            super.m_8037_();
        }

        public void onReachedTarget() {
            if (ForgeEventFactory.getMobGriefingEvent((Level)OFox.this.m_9236_(), (Entity)OFox.this)) {
                BlockState blockstate = OFox.this.m_9236_().m_8055_(this.f_25602_);
                if (blockstate.m_60713_(Blocks.f_50685_)) {
                    this.pickSweetBerries(blockstate);
                } else if (CaveVines.m_152951_((BlockState)blockstate)) {
                    this.pickGlowBerry(blockstate);
                }
            }
        }

        public void pickGlowBerry(BlockState p_148927_) {
            CaveVines.m_269473_((Entity)OFox.this, (BlockState)p_148927_, (Level)OFox.this.m_9236_(), (BlockPos)this.f_25602_);
        }

        public void pickSweetBerries(BlockState p_148929_) {
            int i = (Integer)p_148929_.m_61143_((Property)SweetBerryBushBlock.f_57244_);
            p_148929_.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1));
            int j = 1 + OFox.this.m_9236_().f_46441_.m_188503_(2) + (i == 3 ? 1 : 0);
            ItemStack itemstack = OFox.this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_()) {
                OFox.this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42780_));
                --j;
            }
            if (j > 0) {
                Block.m_49840_((Level)OFox.this.m_9236_(), (BlockPos)this.f_25602_, (ItemStack)new ItemStack((ItemLike)Items.f_42780_, j));
            }
            OFox.this.m_5496_(SoundEvents.f_12457_, 1.0f, 1.0f);
            OFox.this.m_9236_().m_7731_(this.f_25602_, (BlockState)p_148929_.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1)), 2);
        }

        public boolean m_8036_() {
            return !OFox.this.m_5803_() && super.m_8036_();
        }

        public void m_8056_() {
            this.ticksWaited = 0;
            super.m_8056_();
        }
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }
}

