/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.parrot;

import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import com.dragn0007.dragnpets.entities.POEntityTypes;
import com.dragn0007.dragnpets.entities.parrot.CockatielModel;
import com.dragn0007.dragnpets.entities.parrot.OParrot;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import software.bernie.geckolib.animatable.GeoEntity;

public class Cockatiel
extends OParrot
implements GeoEntity,
FlyingAnimal {
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Cockatiel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(Cockatiel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Cockatiel(EntityType<? extends Cockatiel> entityType, Level level) {
        super(entityType, level);
        this.m_7105_(false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22280_, (double)1.2f).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    public ResourceLocation getTextureResource() {
        return CockatielModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    @Override
    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Gender", this.getGender());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setVariant(random.nextInt(CockatielModel.Variant.values().length));
        this.setGender(random.nextInt(Gender.values().length));
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    @Override
    public boolean isFemale() {
        return this.getGender() == 0;
    }

    @Override
    public boolean isMale() {
        return this.getGender() == 1;
    }

    @Override
    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    @Override
    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    @Override
    public boolean canParent() {
        return !this.m_6162_() && this.m_27593_();
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof Cockatiel)) {
            return false;
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return this.canParent() && ((Cockatiel)animal).canParent();
        }
        Cockatiel partner = (Cockatiel)animal;
        if (this.canParent() && partner.canParent() && this.getGender() != partner.getGender()) {
            return true;
        }
        boolean partnerIsFemale = partner.isFemale();
        boolean partnerIsMale = partner.isMale();
        if (((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue() && this.canParent() && partner.canParent() && (this.isFemale() && partnerIsMale || this.isMale() && partnerIsFemale)) {
            return this.isFemale();
        }
        return false;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        Cockatiel parrot1 = (Cockatiel)ageableMob;
        if (ageableMob instanceof Cockatiel) {
            Cockatiel parrot = (Cockatiel)ageableMob;
            parrot1 = (Cockatiel)((EntityType)POEntityTypes.COCKATIEL_ENTITY.get()).m_20615_((Level)serverLevel);
            int i = this.f_19796_.m_188503_(9);
            int variant = i < 4 ? this.getVariant() : (i < 8 ? parrot.getVariant() : this.f_19796_.m_188503_(CockatielModel.Variant.values().length));
            int gender = this.f_19796_.m_188503_(Gender.values().length);
            parrot1.setVariant(variant);
            parrot1.setGender(gender);
        }
        return parrot1;
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }
}

