/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.parrot;

import com.dragn0007.dragnpets.entities.parrot.Ringneck;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class RingneckModel
extends DefaultedEntityGeoModel<Ringneck> {
    public static final ResourceLocation MODEL = new ResourceLocation("dragnpets", "geo/ringneck.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnpets", "animations/ringneck.animation.json");
    public static final ResourceLocation BABY_TEXTURE = new ResourceLocation("dragnpets", "textures/entity/parrot/parrot_baby.png");

    public RingneckModel() {
        super(new ResourceLocation("dragnlivestock", "ringneck"), true);
    }

    public void setCustomAnimations(Ringneck animatable, long instanceId, AnimationState<Ringneck> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(Ringneck object) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(Ringneck object) {
        if (object.m_6162_()) {
            return BABY_TEXTURE;
        }
        return object.getTextureResource();
    }

    public ResourceLocation getAnimationResource(Ringneck animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BLUE(new ResourceLocation("dragnpets", "textures/entity/parrot/ringneck/ringneck_blue.png")),
        CINNAMON(new ResourceLocation("dragnpets", "textures/entity/parrot/ringneck/ringneck_cinnamon.png")),
        CYAN(new ResourceLocation("dragnpets", "textures/entity/parrot/ringneck/ringneck_cyan.png")),
        GREEN(new ResourceLocation("dragnpets", "textures/entity/parrot/ringneck/ringneck_green.png")),
        LIGHT_BLUE(new ResourceLocation("dragnpets", "textures/entity/parrot/ringneck/ringneck_light_blue.png")),
        POWDER(new ResourceLocation("dragnpets", "textures/entity/parrot/ringneck/ringneck_powder.png")),
        SLATE(new ResourceLocation("dragnpets", "textures/entity/parrot/ringneck/ringneck_slate.png")),
        YELLOW(new ResourceLocation("dragnpets", "textures/entity/parrot/ringneck/ringneck_yellow.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

