/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnpets.entities.wolf;

import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.donkey.ODonkey;
import com.dragn0007.dragnlivestock.entities.llama.OLlama;
import com.dragn0007.dragnlivestock.entities.mule.OMule;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import com.dragn0007.dragnpets.entities.POEntityTypes;
import com.dragn0007.dragnpets.entities.ai.CanineFollowPackLeaderGoal;
import com.dragn0007.dragnpets.entities.ai.WolfFollowOwnerGoal;
import com.dragn0007.dragnpets.entities.wolf.OWolfMarkingLayer;
import com.dragn0007.dragnpets.entities.wolf.OWolfModel;
import com.dragn0007.dragnpets.items.custom.DogArmorItem;
import com.dragn0007.dragnpets.util.POTags;
import com.dragn0007.dragnpets.util.PetsOverhaulCommonConfig;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OWolf
extends TamableAnimal
implements NeutralMob,
GeoEntity {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnpets", "entities/o_wolf");
    public static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/wolf");
    private static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/wolf");
    public static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(OWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(OWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> PREY_SELECTOR = entity -> {
        EntityType entitytype = entity.m_6095_();
        return entitytype == EntityTypes.O_SHEEP_ENTITY.get() || entitytype == EntityTypes.O_RABBIT_ENTITY.get() || entitytype == EntityTypes.O_GOAT_ENTITY.get() || entitytype == EntityTypes.O_HORSE_ENTITY.get() || entitytype == EntityTypes.O_COW_ENTITY.get() || entitytype == EntityTypes.O_CHICKEN_ENTITY.get() || entitytype == EntityTypes.O_PIG_ENTITY.get() || entitytype == POEntityTypes.O_FOX_ENTITY.get() || entitytype == POEntityTypes.O_OCELOT_ENTITY.get() || entitytype == POEntityTypes.DOBERMAN_ENTITY.get() || entitytype == POEntityTypes.O_CAT_ENTITY.get();
    };
    public static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @org.jetbrains.annotations.Nullable
    public UUID persistentAngerTarget;
    public final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int regenHealthCounter = 0;
    public int wagCounter = this.f_19796_.m_188503_(1200) + 1200;
    public int stayWaggingCounter = 0;
    private boolean wag = false;
    public OWolf leader;
    public int packSize = 1;
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(POTags.Items.DOG_FOOD);
    public static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("3c50e848-b2e3-404a-9879-7550b12dd09b");
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(OWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public boolean toldToWander = false;
    public static final EntityDataAccessor<Boolean> COLLARED = SynchedEntityData.m_135353_(OWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(OWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public boolean isPanicking = false;

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public OWolf(EntityType<? extends OWolf> entityType, Level level) {
        super(entityType, level);
        this.m_7105_(false);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WolfPanicGoal(1.4));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, OLlama.class, 24.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Camel.class, 24.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, ODonkey.class, 24.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, OMule.class, 24.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.8, true));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((OWolf)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, PREY_SELECTOR));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.f_30122_));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        this.f_21345_.m_25352_(7, (Goal)new CanineFollowPackLeaderGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new WolfFollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 2, true, false, entity -> entity instanceof Player && (this.isFollower() || this.hasFollowers()) && (Boolean)PetsOverhaulCommonConfig.WOLF_PACKS_ATTACK_PLAYERS.get() != false && !this.m_21824_()));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    public <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.015;
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving()) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.3);
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.3);
            }
        } else if (this.m_21825_()) {
            controller.setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        } else if (this.isWagging()) {
            controller.setAnimation(RawAnimation.begin().then("wag", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public boolean isWagging() {
        return this.wag;
    }

    public void setWagging(boolean wagging) {
        this.wag = wagging;
    }

    public void m_8119_() {
        List list;
        super.m_8119_();
        --this.wagCounter;
        if (--this.wagCounter <= 0) {
            ++this.stayWaggingCounter;
            this.setWagging(true);
            if (this.stayWaggingCounter >= 300) {
                this.wagCounter = this.f_19796_.m_188503_(1200) + 1200;
                this.stayWaggingCounter = 0;
                this.setWagging(false);
            }
        }
        if (this.hasFollowers() && this.m_9236_().f_46441_.m_188503_(200) == 1 && (list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(20.0, 20.0, 20.0))).size() <= 1) {
            this.packSize = 1;
        }
        ++this.regenHealthCounter;
        if (this.m_21223_() < this.m_21233_() && this.regenHealthCounter >= 150 && this.m_21824_() && this.m_6084_()) {
            this.m_21153_(this.m_21223_() + 2.0f);
            this.regenHealthCounter = 0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.7, 0.7, 0.7);
        }
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.m_6084_();
    }

    public OWolf startFollowing(OWolf wolf) {
        this.leader = wolf;
        wolf.addFollower();
        return wolf;
    }

    public void stopFollowing() {
        this.leader.removeFollower();
        this.leader = null;
    }

    public void addFollower() {
        ++this.packSize;
    }

    public void removeFollower() {
        --this.packSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.packSize < this.getMaxHerdSize();
    }

    public int getMaxHerdSize() {
        return (Integer)PetsOverhaulCommonConfig.WOLF_PACK_MAX.get();
    }

    public boolean hasFollowers() {
        return this.packSize > 1;
    }

    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.leader) <= 121.0;
    }

    public void pathToLeader() {
        if (this.isFollower()) {
            this.m_21573_().m_5624_((Entity)this.leader, 1.0);
        }
    }

    public void addFollowers(Stream<? extends OWolf> p_27534_) {
        p_27534_.limit(this.getMaxHerdSize() - this.packSize).filter(wolf -> wolf != this).forEach(wolf -> wolf.startFollowing(this));
    }

    public float getStepHeight() {
        return 1.6f;
    }

    public void m_7355_(BlockPos p_30415_, BlockState p_30416_) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    public SoundEvent m_7515_() {
        if (this.m_21660_()) {
            return SoundEvents.f_12619_;
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    public SoundEvent m_7975_(DamageSource p_30424_) {
        return SoundEvents.f_12621_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    public float m_6121_() {
        return 0.4f;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public boolean m_6469_(DamageSource damageSource, float p_30387_) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        Entity entity = damageSource.m_7639_();
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            p_30387_ = (p_30387_ + 1.0f) / 2.0f;
        }
        return super.m_6469_(damageSource, p_30387_);
    }

    public boolean m_7327_(Entity p_30372_) {
        boolean flag = p_30372_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, p_30372_);
        }
        return flag;
    }

    public void m_7105_(boolean p_30443_) {
        super.m_7105_(p_30443_);
        if (p_30443_) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
        this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 1.2f;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_21830_((LivingEntity)player)) {
            if (itemstack.m_41720_() instanceof DogArmorItem && this.getArmor().m_41619_()) {
                this.setArmor(itemstack);
                this.m_5496_(SoundEvents.f_11973_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (itemstack.m_150930_(Items.f_42574_) && (this.isCollared() || !this.getArmor().m_41619_())) {
                Item item2;
                this.setCollared(false);
                if (!this.getArmor().m_41619_() && (item2 = this.getArmor().m_41720_()) instanceof DogArmorItem) {
                    DogArmorItem armorItem = (DogArmorItem)item2;
                    this.m_19998_((ItemLike)armorItem);
                    this.setArmor(Items.f_41852_.m_7968_());
                }
                this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isFemale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.FEMALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isMale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.MALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_()) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.MARKING_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_()) {
                this.setOverlayVariant(this.getOverlayVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setOverlayVariant(this.getOverlayVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_204117_(POTags.Items.TRAINING_TREAT) && this.m_21830_((LivingEntity)player) && ModList.get().isLoaded("doggytalents")) {
            if (!player.m_9236_().f_46443_) {
                OWolf entity = this;
                ResourceLocation dtnDogId = new ResourceLocation("doggytalents", "dog");
                EntityType dtnDogType = EntityType.m_20632_((String)dtnDogId.toString()).orElse(null);
                if (dtnDogType != null) {
                    Entity newEntity = dtnDogType.m_20615_(entity.m_9236_());
                    if (newEntity != null) {
                        newEntity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_146908_(), entity.m_146909_());
                        if (newEntity instanceof TamableAnimal) {
                            TamableAnimal tamable = (TamableAnimal)newEntity;
                            tamable.m_21816_(player.m_20148_());
                        }
                        entity.m_9236_().m_7967_(newEntity);
                        entity.m_146870_();
                    }
                } else {
                    return InteractionResult.PASS;
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && !this.m_6898_(itemstack) && !this.m_21827_() && !this.wasToldToWander() && this.m_21830_((LivingEntity)player)) {
            this.setToldToWander(true);
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.dragnpets.wandering.tooltip").m_130940_(ChatFormatting.GOLD), true);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && !this.m_6898_(itemstack) && !this.m_21827_() && this.wasToldToWander() && this.m_21830_((LivingEntity)player)) {
            this.setToldToWander(false);
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.dragnpets.following.tooltip").m_130940_(ChatFormatting.GOLD), true);
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || itemstack.m_150930_(Items.f_42500_) && !this.m_21824_() && !this.m_21660_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            InteractionResult interactionresult;
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (item instanceof DyeItem) {
                DyeItem dyeitem = (DyeItem)item;
                if (this.m_21830_((LivingEntity)player)) {
                    this.setCollared(true);
                    DyeColor dyecolor = dyeitem.m_41089_();
                    if (dyecolor != this.getCollarColor()) {
                        this.setCollarColor(dyecolor);
                        if (!player.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(player, hand);
                }
            }
            if ((!(interactionresult = super.m_6071_(player, hand)).m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player) && !player.m_6144_()) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (itemstack.m_150930_(Items.f_42500_) && !this.m_21660_()) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int p_30404_) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @org.jetbrains.annotations.Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@org.jetbrains.annotations.Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor p_30398_) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)p_30398_.m_41060_());
    }

    public boolean canWearArmor() {
        return false;
    }

    public boolean isArmor(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof DogArmorItem;
    }

    public void setArmorEquipment(ItemStack itemStack) {
        this.setArmor(itemStack);
        if (!this.m_9236_().f_46443_) {
            DogArmorItem dogArmorItem;
            int protection;
            this.m_21051_(Attributes.f_22284_).m_22120_(ARMOR_MODIFIER_UUID);
            Item item = itemStack.m_41720_();
            if (item instanceof DogArmorItem && (protection = (dogArmorItem = (DogArmorItem)item).getProtection()) > 0) {
                this.m_21051_(Attributes.f_22284_).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Dog armor bonus", (double)protection, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    public void setArmor(ItemStack itemStack) {
        this.m_8061_(EquipmentSlot.CHEST, itemStack);
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public ResourceLocation getTextureLocation() {
        return OWolfModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public ResourceLocation getOverlayLocation() {
        return OWolfMarkingLayer.Overlay.overlayFromOrdinal((int)this.getOverlayVariant()).resourceLocation;
    }

    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    public void setOverlayVariant(int overlayVariant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)overlayVariant);
    }

    public boolean wasToldToWander() {
        return this.toldToWander;
    }

    public boolean getToldToWander() {
        return this.toldToWander;
    }

    public void setToldToWander(boolean toldToWander) {
        this.toldToWander = toldToWander;
    }

    public boolean isCollared() {
        return (Boolean)this.f_19804_.m_135370_(COLLARED);
    }

    public void setCollared(boolean collared) {
        this.f_19804_.m_135381_(COLLARED, (Object)collared);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(COLLARED, (Object)false);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Wandering")) {
            this.setToldToWander(tag.m_128471_("Wandering"));
        }
        if (tag.m_128441_("Panicking")) {
            this.setPanicking(tag.m_128471_("Panicking"));
        }
        if (tag.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)tag.m_128451_("CollarColor")));
        }
        if (tag.m_128441_("Collared")) {
            this.setCollared(tag.m_128471_("Collared"));
        }
        if (tag.m_128441_("ArmorItem")) {
            ItemStack armorItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("ArmorItem"));
            this.setArmorEquipment(armorItem);
            this.setArmor(armorItem);
        }
        this.m_147285_(this.m_9236_(), tag);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128379_("Wandering", this.getToldToWander());
        tag.m_128379_("Panicking", this.getPanicking());
        tag.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        tag.m_128379_("Collared", this.isCollared());
        if (!this.getArmor().m_41619_()) {
            tag.m_128365_("ArmorItem", (Tag)this.getArmor().m_41739_(new CompoundTag()));
        }
        this.m_21678_(tag);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setVariant(random.nextInt(OWolfModel.Variant.values().length));
        this.setOverlayVariant(random.nextInt(OWolfMarkingLayer.Overlay.values().length));
        this.setGender(random.nextInt(Gender.values().length));
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public boolean isFemale() {
        return this.getGender() == 0;
    }

    public boolean isMale() {
        return this.getGender() == 1;
    }

    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    public boolean canParent() {
        return !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof OWolf)) {
            return false;
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return this.canParent() && ((OWolf)animal).canParent();
        }
        OWolf partner = (OWolf)animal;
        if (this.canParent() && partner.canParent() && this.getGender() != partner.getGender()) {
            return this.isFemale();
        }
        return false;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        OWolf partner = (OWolf)ageableMob;
        OWolf pup = (OWolf)((EntityType)POEntityTypes.O_WOLF_ENTITY.get()).m_20615_((Level)serverLevel);
        int variantChance = this.f_19796_.m_188503_(14);
        int variant = variantChance < 6 ? this.getVariant() : (variantChance < 12 ? partner.getVariant() : this.f_19796_.m_188503_(OWolfModel.Variant.values().length));
        pup.setVariant(variant);
        int overlayChance = this.f_19796_.m_188503_(10);
        int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(OWolfMarkingLayer.Overlay.values().length));
        pup.setOverlayVariant(overlay);
        int gender = this.f_19796_.m_188503_(Gender.values().length);
        pup.setGender(gender);
        return pup;
    }

    public boolean m_7757_(LivingEntity entity, LivingEntity p_30390_) {
        if (!(entity instanceof Creeper) && !(entity instanceof Ghast)) {
            if (entity instanceof OWolf) {
                OWolf wolf = (OWolf)entity;
                return !wolf.m_21824_() || wolf.m_269323_() != p_30390_;
            }
            if (entity instanceof Player && p_30390_ instanceof Player && !((Player)p_30390_).m_7099_((Player)entity)) {
                return false;
            }
            if (entity instanceof AbstractHorse && ((AbstractHorse)entity).m_30614_()) {
                return false;
            }
            return !(entity instanceof TamableAnimal) || !((TamableAnimal)entity).m_21824_();
        }
        return false;
    }

    public boolean m_6573_(Player p_30396_) {
        return !this.m_21660_() && super.m_6573_(p_30396_);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public boolean isPanicking() {
        return this.m_21223_() < this.m_21233_() / 3.0f && this.m_6084_();
    }

    public boolean getPanicking() {
        return this.isPanicking;
    }

    public void setPanicking(boolean panicking) {
        this.isPanicking = panicking;
    }

    class WolfPanicGoal
    extends PanicGoal {
        public WolfPanicGoal(double v) {
            super((PathfinderMob)OWolf.this, v);
        }

        public boolean m_202729_() {
            return this.f_25684_.m_203117_() || this.f_25684_.m_6060_() || this.f_25684_.m_21223_() < this.f_25684_.m_21233_() / 3.0f && this.f_25684_.m_6084_();
        }
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }
}

