/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class EFNConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ANIMATION_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ANIMATION_WHITELIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> YAMATO_GLOBALSTUN_WHITELIST;
    public static final ForgeConfigSpec.IntValue YAMATO_PARRY_STUN_DURATION;
    public static final ForgeConfigSpec.IntValue YAMATO_PARRY_STUN_COOLDOWN;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> YAMATO_CATCHER_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> YAMATO_CATCHER_WHITELIST;
    public static final ForgeConfigSpec.BooleanValue ENABLE_JUDGEMENTCUT_END_CAMERA_ANIMATIONS;
    public static final ForgeConfigSpec.BooleanValue ENABLE_JUDGEMENTCUT_END_PARTICLES;
    public static final ForgeConfigSpec.BooleanValue ENABLE_JUDGEMENTCUT_END_SCREENDISTORTIONEFFECT;
    public static final ForgeConfigSpec.BooleanValue ENABLE_YAMATO_PARRY_TIMESLOWDOWN;
    public static final ForgeConfigSpec.IntValue YAMATO_PARRY_TIMESLOW_DELAY_BEGIN;
    public static final ForgeConfigSpec.IntValue YAMATO_PARRY_TIMESLOW_DELAY_END;
    public static final ForgeConfigSpec.IntValue YAMATO_PARRY_TIMESLOW_AMPLIFIER;
    public static final ForgeConfigSpec.BooleanValue ENABLE_DUALSOWRD_DODGE_TIMESLOWDOWN;
    public static final ForgeConfigSpec.IntValue DUALSOWRD_DODGE_TIMESLOW_DELAY_BEGIN;
    public static final ForgeConfigSpec.IntValue DUALSOWRD_DODGE_TIMESLOW_DELAY_END;
    public static final ForgeConfigSpec.IntValue DUALSOWRD_DODGE_TIMESLOW_AMPLIFIER;
    public static final ForgeConfigSpec.DoubleValue JUDGEMENT_CUT_END_DAMAGE_RATE;
    public static final ForgeConfigSpec.DoubleValue JUDGEMENT_CUT_END_CUT_RATE;
    public static final ForgeConfigSpec.DoubleValue JUDGEMENT_CUT_END_BOSS_DAMAGE_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue JUDGEMENT_CUT_END_HEALTH_PERCENTAGE;
    public static final ForgeConfigSpec.BooleanValue ENABLE_BLOODLUST_POSTEFFECT;
    public static final ForgeConfigSpec.BooleanValue ENABLE_BEASTCLAW_POSTEFFECT;
    public static final ForgeConfigSpec.IntValue YAMATO_REWARD_KILL_THRESHOLD;
    public static final ForgeConfigSpec.BooleanValue YAMATO_REWARD_ENABLED;

    static {
        BUILDER.push("yamato_catcher");
        YAMATO_CATCHER_BLACKLIST = BUILDER.comment(new String[]{"Entities that CANNOT be caught by Yamato Catcher (format: modid:entity_id)", "These entities will be ignored regardless of knockback resistance", "Example: [\"minecraft:wither\", \"minecraft:ender_dragon\"]"}).translation("efn.config.yamato_catcher_blacklist").defineList("yamatoCatcherBlacklist", (List)Lists.newArrayList((Object[])new String[]{"minecraft:wither", "minecraft:ender_dragon"}), obj -> obj instanceof String);
        YAMATO_CATCHER_WHITELIST = BUILDER.comment(new String[]{"Entities that CAN be caught by Yamato Catcher (format: modid:entity_id)", "These entities can be caught regardless of knockback resistance", "Example: [\"minecraft:player\", \"minecraft:zombie\"]"}).translation("efn.config.yamato_catcher_whitelist").defineList("yamatoCatcherWhitelist", (List)Lists.newArrayList((Object[])new String[]{"minecraft:zombie", "minecraft:drowned", "minecraft:husk", "minecraft:skeleton", "minecraft:wither_skeleton", "minecraft:stray", "minecraft:bogged", "minecraft:Pillager", "minecraft:evoker", "minecraft:vindicator", "minecraft:blaze", "minecraft:piglin", "minecraft:zombified_piglin", "minecraft:enderman"}), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.push("yamato_global_stun");
        YAMATO_GLOBALSTUN_WHITELIST = BUILDER.comment(new String[]{"Entities that can be Global Focus stunned by Yamato successful parry + attack combo (format: modid:entity_id)", "These entities will receive YamatoStunEffect when hit", "Use 'modid:all' to include all entities from a mod", "Example: [\"minecraft:zombie\", \"cataclysm:all\", \"iceandfire:all\"]"}).translation("efn.config.yamato_globalstun_whitelist").defineList("yamatoStunWhitelist", (List)Lists.newArrayList((Object[])new String[]{"cataclysm:all", "wom:all"}), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.push("yamato_parry_stun");
        YAMATO_PARRY_STUN_DURATION = BUILDER.comment("Duration of stun effect applied after successful parry + attack combo (in ticks, 20 ticks = 1 second)").translation("efn.config.yamato_parry_stun_duration").defineInRange("yamatoParryStunDuration", 20, 1, 200);
        YAMATO_PARRY_STUN_COOLDOWN = BUILDER.comment("Cooldown between parry stuns (in ticks, 20 ticks = 1 second)").translation("efn.config.yamato_parry_stun_cooldown").defineInRange("yamatoParryStunCooldown", 60, 1, 1200);
        BUILDER.pop();
        BUILDER.push("animation");
        ANIMATION_BLACKLIST = BUILDER.comment(new String[]{"Entities that won't play Yamato's stun animations (format: modid:entity_id)", "Example: [\"minecraft:wither\", \"minecraft:ender_dragon\"]"}).translation("efn.config.animation_blacklist").defineList("animationBlacklist", (List)Lists.newArrayList((Object[])new String[]{"minecraft:wither", "minecraft:ender_dragon"}), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.push("animation");
        ANIMATION_WHITELIST = BUILDER.comment(new String[]{"Entities that can play Yamato's stun animations (format: modid:entity_id)", "Example: [\"minecraft:player\", \"minecraft:zombie\", \"minecraft:skeleton\"]"}).translation("efn.config.animation_whitelist").defineList("animationWhitelist", (List)Lists.newArrayList((Object[])new String[]{"wom:evil_skeleton", "wom:hollow", "wom:saulomonk", "wom:lycanth"}), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.push("yamato_reward");
        YAMATO_REWARD_ENABLED = BUILDER.comment(new String[]{"Enable/disable the skill book reward for Yamato JudgementCut-End", "When enabled, players will receive JudgementCut-End skill book after reaching the kill threshold", "Default: true (enabled)"}).translation("efn.config.yamato_reward_enabled").define("yamatoRewardEnabled", true);
        YAMATO_REWARD_KILL_THRESHOLD = BUILDER.comment(new String[]{"Number of kills required to receive the Yamato JudgementCut-End reward", "Set to 0 to disable the reward system", "Default: 100 kills"}).translation("efn.config.yamato_reward_kill_threshold").defineInRange("yamatoRewardKillThreshold", 100, 0, 10000);
        BUILDER.pop();
        BUILDER.push("judgementcut_end_camera");
        ENABLE_JUDGEMENTCUT_END_CAMERA_ANIMATIONS = BUILDER.comment(new String[]{"Enable/disable camera animations for JudgementCut-End", "When enabled, JudgementCut-End will play cinematic camera animations", "Default: true (enabled)"}).translation("efn.config.enable_judgementcut_end_camera_animations").define("enableCameraAnimations", true);
        BUILDER.pop();
        BUILDER.push("judgementcut_end_particles");
        ENABLE_JUDGEMENTCUT_END_PARTICLES = BUILDER.comment(new String[]{"Enable/disable particle effects for JudgementCut-End", "Disable Judgement Cut End's particle effects that may cause rendering incompatibility", "Default: true (enabled)"}).translation("efn.config.enable_judgementcut_end_particles").define("enableJudgementCutEndParticles", true);
        BUILDER.pop();
        BUILDER.push("judgementcut_end_screendistortion effect");
        ENABLE_JUDGEMENTCUT_END_SCREENDISTORTIONEFFECT = BUILDER.comment(new String[]{"Enable/disable screendistortion effects for JudgementCut-End", "Disable Judgement Cut End's screendistortion effects", "Default: true (enabled)"}).define("enableJudgementCutEndScreendistortion", true);
        BUILDER.pop();
        BUILDER.push("yamato_parry_timeslow");
        ENABLE_YAMATO_PARRY_TIMESLOWDOWN = BUILDER.comment(new String[]{"Yamato parry timeslowdown", "Disable time slowdown effect that Yamato parry", "Default: true (enabled)"}).translation("efn.config.enable_yamato_parry_timeslowdown").define("enableYamatoParryTimeSlowdown", true);
        YAMATO_PARRY_TIMESLOW_DELAY_BEGIN = BUILDER.comment(new String[]{"Delay before time slowdown effect starts (in ticks)", "20 ticks = 1 second. This creates a brief pause before the slowdown", "Default: 5 ticks (0.25 seconds)"}).translation("efn.config.yamato_parry_timeslow_delay").defineInRange("yamatoParryTimeSlowDelay", 5, 0, 40);
        YAMATO_PARRY_TIMESLOW_DELAY_END = BUILDER.comment(new String[]{"End tick of time slowdown effect (in ticks)", "20 ticks = 1 second. When the time slowdown end", "Default: 8 ticks-lasts 3 ticks"}).translation("efn.config.yamato_parry_timeslow_duration").defineInRange("yamatoParryTimeSlowDuration", 8, 1, 100);
        YAMATO_PARRY_TIMESLOW_AMPLIFIER = BUILDER.comment(new String[]{"Strength level of time slowdown effect", "1 = 1% speed, 2 = 2% speed, 3 = 3% speed, 4 = 4% speed, 5 = 5% speed", "Default: 3"}).translation("efn.config.yamato_parry_timeslow_amplifier").defineInRange("yamatoParryTimeSlowAmplifier", 3, 1, 20);
        BUILDER.pop();
        BUILDER.push("dualsword_dodge_timeslow");
        ENABLE_DUALSOWRD_DODGE_TIMESLOWDOWN = BUILDER.comment(new String[]{"Dualsword dodge timeslowdown", "Disable time slowdown effect that Dualsword dodge", "Default: true (enabled)"}).translation("efn.config.enable_dualsword_dodge_timeslowdown").define("enableDualswordDodgeTimeSlowdown", true);
        DUALSOWRD_DODGE_TIMESLOW_DELAY_BEGIN = BUILDER.comment(new String[]{"Delay before time slowdown effect starts (in ticks)", "20 ticks = 1 second. This creates a brief pause before the slowdown", "Default: 4 ticks"}).translation("efn.config.dualsword_dodge_timeslow_delay").defineInRange("DualswordDodgeTimeSlowDelay", 4, 0, 100);
        DUALSOWRD_DODGE_TIMESLOW_DELAY_END = BUILDER.comment(new String[]{"End time of slowdown effect (in ticks)", "20 ticks = 1 second. When the time slowdown end", "Default: 7 ticks"}).translation("efn.config.dualsword_dodge_timeslow_duration").defineInRange("DualswordDodgeTimeSlowDuration", 7, 1, 100);
        DUALSOWRD_DODGE_TIMESLOW_AMPLIFIER = BUILDER.comment(new String[]{"Strength level of time slowdown effect", "1 = 1% speed, 2 = 2% speed, 3 = 3% speed, 4 = 4% speed, 5 = 5% speed", "Default: 5"}).translation("efn.config.dualsword_dodge_timeslow_amplifier").defineInRange("DualswordDodgeTimeSlowAmplifier", 5, 1, 20);
        BUILDER.pop();
        BUILDER.push("judgementcut_end_damage");
        JUDGEMENT_CUT_END_DAMAGE_RATE = BUILDER.comment(new String[]{"Base damage rate for Judgement Cut End", "This multiplies the base damage calculation", "Default: 2.0"}).translation("efn.config.judgement_cut_end_damage_rate").defineInRange("judgementCutEndDamageRate", 2.0, 0.1, 100.0);
        JUDGEMENT_CUT_END_CUT_RATE = BUILDER.comment(new String[]{"Cut rate for Judgement Cut End (percentage of max health)", "This determines how much percentage damage is dealt based on target's max health", "Default: 0.4 (40%)"}).translation("efn.config.judgement_cut_end_cut_rate").defineInRange("judgementCutEndCutRate", 0.4, 0.01, 1.0);
        JUDGEMENT_CUT_END_BOSS_DAMAGE_MULTIPLIER = BUILDER.comment(new String[]{"Damage multiplier against Cataclysm bosses", "This multiplies the damage when attacking Cataclysm bosses", "Default: 1.0 (no multiplier)"}).translation("efn.config.judgement_cut_end_boss_damage_multiplier").defineInRange("judgementCutEndBossDamageMultiplier", 1.0, 0.1, 10.0);
        JUDGEMENT_CUT_END_HEALTH_PERCENTAGE = BUILDER.comment(new String[]{"Health percentage used in damage calculation", "This is the percentage of max health used in the formula: cutRate * (maxHealth * healthPercentage)", "Default: 0.4 (40%)"}).translation("efn.config.judgement_cut_end_health_percentage").defineInRange("judgementCutEndHealthPercentage", 0.4, 0.01, 1.0);
        BUILDER.pop();
        BUILDER.push("bloodlust_posteffect");
        ENABLE_BLOODLUST_POSTEFFECT = BUILDER.comment(new String[]{"Enable/disable post-effect when bloodlust's skill active", "When enabled, bloodlust's skill will play post-effect", "Default: true (enabled)"}).translation("efn.config.enable_bloodlust_posteffect").define("enablePost-Effects", true);
        BUILDER.pop();
        BUILDER.push("beastclaw_posteffect");
        ENABLE_BEASTCLAW_POSTEFFECT = BUILDER.comment(new String[]{"Enable/disable post-effect when beastclaw's skill active", "When enabled, beastclaw's skill will play post-effect", "Default: true (enabled)"}).define("enablePost-Effects", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    @Mod.EventBusSubscriber
    public static class EFNModLoadingContext {
        @SubscribeEvent
        public static void onLoad(ModConfigEvent.Loading event) {
            event.getConfig().getSpec();
        }
    }
}

