/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.api;

import com.merlin204.avalon.entity.IAvalonMeshEntity;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public abstract class ProjectileVFXEntity
extends Projectile
implements IAvalonMeshEntity {
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID = SynchedEntityData.m_135353_(ProjectileVFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> DATA_OWNER_ID = SynchedEntityData.m_135353_(ProjectileVFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(ProjectileVFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> Y_ROT_OFFSET = SynchedEntityData.m_135353_(ProjectileVFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> X_ROT_OFFSET = SynchedEntityData.m_135353_(ProjectileVFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> Z_ROT_OFFSET = SynchedEntityData.m_135353_(ProjectileVFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> START_Y_ROT = SynchedEntityData.m_135353_(ProjectileVFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Boolean> PLAY_ANIMATION = SynchedEntityData.m_135353_(ProjectileVFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> SHOULD_RENDER = SynchedEntityData.m_135353_(ProjectileVFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<String> MESH_PATH = SynchedEntityData.m_135353_(ProjectileVFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<String> ARMATURE_PATH = SynchedEntityData.m_135353_(ProjectileVFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<String> TEXTURE_PATH = SynchedEntityData.m_135353_(ProjectileVFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<String> LIGHT_TEXTURE_PATH = SynchedEntityData.m_135353_(ProjectileVFXEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected Armatures.ArmatureAccessor<? extends Armature> ARMATURE_ACCESSOR;
    protected AssetAccessor<? extends SkinnedMesh> MESH;
    protected ResourceLocation TEXTURE;
    protected ResourceLocation LIGHT_TEXTURE;
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> DEFAULT_ANIMATION;

    protected ProjectileVFXEntity(EntityType<? extends Projectile> pEntityType, Level pLevel, float scale) {
        super(pEntityType, pLevel);
        this.m_20088_().m_135381_(SCALE, (Object)Float.valueOf(scale));
        this.f_19794_ = true;
        this.m_20242_(true);
    }

    public ProjectileVFXEntity(EntityType<? extends ProjectileVFXEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
        this.m_20242_(true);
        this.ARMATURE_ACCESSOR = null;
        this.MESH = null;
        this.TEXTURE = null;
        this.DEFAULT_ANIMATION = null;
        this.LIGHT_TEXTURE = null;
    }

    public ProjectileVFXEntity(EntityType<? extends ProjectileVFXEntity> entityType, LivingEntity owner, float scale, Vec3f rotOffset, Armatures.ArmatureAccessor<? extends Armature> armatureAccessor, AssetAccessor<? extends SkinnedMesh> mesh, ResourceLocation texture, ResourceLocation lightTexture, AnimationManager.AnimationAccessor<? extends StaticAnimation> defaultAnimation) {
        super(entityType, owner.m_9236_());
        this.f_19811_ = true;
        this.LIGHT_TEXTURE = lightTexture;
        this.m_20088_().m_135381_(SCALE, (Object)Float.valueOf(scale));
        this.m_20088_().m_135381_(X_ROT_OFFSET, (Object)Float.valueOf(rotOffset.x));
        this.m_20088_().m_135381_(Y_ROT_OFFSET, (Object)Float.valueOf(rotOffset.y));
        this.m_20088_().m_135381_(Z_ROT_OFFSET, (Object)Float.valueOf(rotOffset.z));
        this.f_19794_ = true;
        this.m_20242_(true);
        this.ARMATURE_ACCESSOR = armatureAccessor;
        float ownerYRot = this.m_19749_().m_146908_();
        this.MESH = mesh;
        this.TEXTURE = texture;
        this.DEFAULT_ANIMATION = defaultAnimation;
        this.f_19804_.m_135381_(ARMATURE_PATH, (Object)this.ARMATURE_ACCESSOR.registryName().toString());
        this.f_19804_.m_135381_(MESH_PATH, (Object)this.MESH.registryName().toString());
        this.f_19804_.m_135381_(TEXTURE_PATH, (Object)this.TEXTURE.toString());
        this.f_19804_.m_135381_(LIGHT_TEXTURE_PATH, (Object)this.LIGHT_TEXTURE.toString());
    }

    @Nullable
    public Armature getArmature() {
        return super.getArmature();
    }

    @Nullable
    public AssetAccessor<? extends SkinnedMesh> getMesh() {
        return super.getMesh();
    }

    @Nullable
    public ResourceLocation getTexture() {
        return super.getTexture();
    }

    public float getScale() {
        return ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
    }

    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getDefaultAnimation() {
        return null;
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19789_ = 0.0f;
        this.f_19794_ = true;
        this.m_20242_(true);
        boolean playAnimation = this.getPlayAnimation();
        if (!playAnimation) {
            float ownerYRot = this.getStartYRot();
            this.m_146922_(ownerYRot);
            this.m_5618_(ownerYRot);
            this.m_5616_(ownerYRot);
        }
        if (this.m_9236_().f_46443_) {
            if (this.MESH == null) {
                this.MESH = Meshes.MeshAccessor.create((String)ResourceLocation.parse((String)((String)this.f_19804_.m_135370_(MESH_PATH))).m_135827_(), (String)ResourceLocation.parse((String)((String)this.f_19804_.m_135370_(MESH_PATH))).m_135815_(), jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
            }
            if (this.ARMATURE_ACCESSOR == null) {
                this.ARMATURE_ACCESSOR = Armatures.ArmatureAccessor.create((String)ResourceLocation.parse((String)((String)this.f_19804_.m_135370_(ARMATURE_PATH))).m_135827_(), (String)ResourceLocation.parse((String)((String)this.f_19804_.m_135370_(ARMATURE_PATH))).m_135815_(), Armature::new);
            }
            if (this.TEXTURE == null) {
                this.TEXTURE = ResourceLocation.parse((String)((String)this.f_19804_.m_135370_(TEXTURE_PATH)));
            }
            if (this.LIGHT_TEXTURE == null) {
                this.LIGHT_TEXTURE = ResourceLocation.parse((String)((String)this.f_19804_.m_135370_(LIGHT_TEXTURE_PATH)));
            }
        }
    }

    @Nullable
    public ResourceLocation getLitTexture() {
        return this.LIGHT_TEXTURE;
    }

    public float getXRotOffset() {
        return ((Float)this.f_19804_.m_135370_(X_ROT_OFFSET)).floatValue();
    }

    public float getZRotOffset() {
        return ((Float)this.f_19804_.m_135370_(Z_ROT_OFFSET)).floatValue();
    }

    public float getYRotOffset() {
        return ((Float)this.f_19804_.m_135370_(Y_ROT_OFFSET)).floatValue();
    }

    @Nullable
    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable @Nullable AnimationManager.AnimationAccessor<? extends StaticAnimation> getIdleAnimation() {
        return Animations.EMPTY_ANIMATION;
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(DATA_OWNER_UUID, Optional.ofNullable(pUuid));
    }

    public int getOwnerID() {
        return (Integer)this.f_19804_.m_135370_(DATA_OWNER_ID);
    }

    public void setOwnerID(int id) {
        this.f_19804_.m_135381_(DATA_OWNER_ID, (Object)id);
    }

    public float getStartYRot() {
        return ((Float)this.f_19804_.m_135370_(START_Y_ROT)).floatValue();
    }

    public void setStartYRot(float f) {
        this.f_19804_.m_135381_(START_Y_ROT, (Object)Float.valueOf(f));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_OWNER_ID, (Object)0);
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(Y_ROT_OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(X_ROT_OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(Z_ROT_OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(START_Y_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PLAY_ANIMATION, (Object)false);
        this.f_19804_.m_135372_(SHOULD_RENDER, (Object)false);
        this.f_19804_.m_135372_(ARMATURE_PATH, (Object)"");
        this.f_19804_.m_135372_(MESH_PATH, (Object)"");
        this.f_19804_.m_135372_(TEXTURE_PATH, (Object)"");
        this.f_19804_.m_135372_(LIGHT_TEXTURE_PATH, (Object)"");
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_6469_(@NotNull DamageSource source, float p_21017_) {
        return false;
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public boolean m_5843_() {
        return false;
    }

    protected void moveToOwner(LivingEntity owner) {
        this.m_146922_(owner.f_20883_);
        this.m_5618_(owner.f_20883_);
        this.m_5616_(owner.f_20883_);
        this.m_146884_(owner.m_20182_());
    }

    public LivingEntityPatch<?> getOwnerPatch() {
        return (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this.m_19749_(), LivingEntityPatch.class);
    }

    public LivingEntityPatch<?> getPatch() {
        return (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this, LivingEntityPatch.class);
    }

    public <T extends EntityPatch<?>> T getPatch(Class<T> type) {
        return (T)EpicFightCapabilities.getEntityPatch((Entity)this, type);
    }

    public boolean getPlayAnimation() {
        return (Boolean)this.f_19804_.m_135370_(PLAY_ANIMATION);
    }

    public void setPlayAnimation(boolean b) {
        this.f_19804_.m_135381_(PLAY_ANIMATION, (Object)b);
    }

    public boolean getShouldRender() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_RENDER);
    }

    public void setShouldRender(boolean b) {
        this.f_19804_.m_135381_(SHOULD_RENDER, (Object)b);
    }
}

