/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.camera;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hm.efn.EFN;
import com.hm.efn.util.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.phys.Vec3;

public class CameraAnimation {
    public final FloatSheet x;
    public final FloatSheet y;
    public final FloatSheet z;
    public final FloatSheet rx;
    public final FloatSheet ry;
    public final FloatSheet rz;
    public final FloatSheet fov;
    public final float totalTime;

    public CameraAnimation(FloatSheet x, FloatSheet y, FloatSheet z, FloatSheet rx, FloatSheet ry, FloatSheet rz, FloatSheet fov) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
        this.fov = fov;
        float tt = Math.max(x.getMaxTime(), y.getMaxTime());
        tt = Math.max(z.getMaxTime(), tt);
        tt = Math.max(rx.getMaxTime(), tt);
        tt = Math.max(ry.getMaxTime(), tt);
        this.totalTime = tt = Math.max(fov.getMaxTime(), tt);
    }

    public static CameraAnimation load(ResourceLocation resourceLocation) {
        Minecraft mc = Minecraft.m_91087_();
        try {
            FloatSheet z;
            FloatSheet y;
            FloatSheet x;
            JsonObject sheets;
            int len;
            InputStream is = ((Resource)mc.m_91098_().m_213713_(resourceLocation).get()).m_215507_();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            while ((len = is.read(bytes)) != -1) {
                ((OutputStream)os).write(bytes, 0, len);
            }
            is.close();
            String json = ((Object)os).toString();
            JsonObject animJson = JsonParser.parseString((String)json).getAsJsonObject();
            float timeScale = 1.0f;
            if (animJson.has("time_scale")) {
                timeScale = animJson.get("time_scale").getAsFloat();
            }
            if ((sheets = animJson.getAsJsonObject("pos")).isJsonArray()) {
                x = new FloatSheet();
                x.getFromJson(sheets.getAsJsonObject("x"), "value");
                y = new FloatSheet();
                y.getFromJson(sheets.getAsJsonObject("y"), "value");
                z = new FloatSheet();
                z.getFromJson(sheets.getAsJsonObject("z"), "value");
            } else {
                x = new FloatSheet();
                y = new FloatSheet();
                z = new FloatSheet();
                x.getFromJson(sheets, "x");
                y.getFromJson(sheets, "y");
                z.getFromJson(sheets, "z");
            }
            sheets = animJson.getAsJsonObject("rot");
            FloatSheet rx = new FloatSheet();
            FloatSheet ry = new FloatSheet();
            FloatSheet rz = new FloatSheet();
            rx.getFromJson(sheets, "rx");
            ry.getFromJson(sheets, "ry");
            rz.getFromJson(sheets, "rz");
            sheets = animJson.getAsJsonObject("fov");
            FloatSheet fov = new FloatSheet();
            fov.getFromJson(sheets, "value");
            x.scaleTimes(timeScale);
            y.scaleTimes(timeScale);
            z.scaleTimes(timeScale);
            rx.scaleTimes(timeScale);
            ry.scaleTimes(timeScale);
            rz.scaleTimes(timeScale);
            fov.scaleTimes(timeScale);
            EFN.LOGGER.info("Load Camera Animation: " + resourceLocation);
            return new CameraAnimation(x, y, z, rx, ry, rz, fov);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Pose getPose(float time) {
        return new Pose(this.x.getValueByTime(time), this.y.getValueByTime(time), this.z.getValueByTime(time), this.rx.getValueByTime(time), this.ry.getValueByTime(time), this.rz.getValueByTime(time), this.fov.getValueByTime(time));
    }

    public static class FloatSheet
    extends TimeSheet {
        public float[] floatSheet;

        public float getValueByTime(float time) {
            int idx = this.getIndexByTime(time);
            if (idx == this.timeSheet.length - 1) {
                return this.floatSheet[idx];
            }
            float t = this.timeSheet[idx + 1] - this.timeSheet[idx];
            if (t > 1.0E-5f) {
                t = (time - this.timeSheet[idx]) / t;
                return this.floatSheet[idx] * (1.0f - t) + this.floatSheet[idx + 1] * t;
            }
            return this.floatSheet[idx];
        }

        public void getFromJson(JsonObject json, String valueKey) {
            this.getFromJson(json);
            this.floatSheet = JsonUtils.getAsFloatArray(json.getAsJsonArray(valueKey));
        }
    }

    public static class Pose {
        public final Vec3 pos;
        public final float rotY;
        public final float rotX;
        public final float rotZ;
        public final float fov;

        public Pose(Vec3 pos, float rotX, float rotY, float rotZ, float fov) {
            this.pos = pos;
            this.rotY = rotY;
            this.rotX = rotX;
            this.rotZ = rotZ;
            this.fov = fov;
        }

        public Pose(float x, float y, float z, float rotX, float rotY, float rotZ, float fov) {
            this(new Vec3((double)x, (double)y, (double)z), rotX, rotY, rotZ, fov);
        }

        public String toString() {
            return "Pose{pos=" + this.pos + ", rotY=" + this.rotY + ", rotX=" + this.rotX + ", rotZ=" + this.rotZ + ", fov=" + this.fov + "}";
        }
    }

    public static abstract class TimeSheet {
        public float[] timeSheet;

        public int getIndexByTime(float time) {
            if (time <= 0.0f) {
                return 0;
            }
            for (int i = 0; i < this.timeSheet.length; ++i) {
                if (!(this.timeSheet[i] >= time)) continue;
                return Math.max(i - 1, 0);
            }
            return this.timeSheet.length - 1;
        }

        public void getFromJson(JsonObject json) {
            this.timeSheet = JsonUtils.getAsFloatArray(json.getAsJsonArray("time"));
        }

        public float getMaxTime() {
            return this.timeSheet[this.timeSheet.length - 1];
        }

        public void scaleTimes(float scale) {
            int i = 0;
            while (i < this.timeSheet.length) {
                int n = i++;
                this.timeSheet[n] = this.timeSheet[n] / scale;
            }
        }
    }
}

