/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.camera;

import com.hm.efn.camera.CameraAnimation;
import com.hm.efn.util.MathUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="efn", value={Dist.CLIENT})
public class CameraEvents {
    private static final Vec3 Vec3UP = new Vec3(0.0, 1.0, 0.0);
    public static CameraAnimation currentAnim;
    private static float yawLock;
    private static Vec3 posLock;
    private static int tick;
    private static int linkTick;
    private static int maxLinkTick;
    private static boolean isEnd;
    private static boolean linking;
    private static LivingEntity orginal;
    private static LivingEntityPatch<?> patched;
    private static float fovO;
    private static boolean isLockPos;
    private static CameraAnimation.Pose pose_;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void TransformCam(ViewportEvent.ComputeCameraAngles event) {
        CameraType cameraType = Minecraft.m_91087_().f_91066_.m_92176_();
        if (cameraType.m_90612_() || cameraType.m_90613_()) {
            return;
        }
        if (isEnd && !linking || currentAnim == null) {
            return;
        }
        if (orginal == null) {
            isEnd = true;
            linking = false;
            return;
        }
        if (orginal.m_213877_()) {
            isEnd = true;
            linking = false;
            return;
        }
        Camera camera = event.getCamera();
        double partialTicks = event.getPartialTick();
        if (linking) {
            CameraAnimation.Pose pose = pose_;
            float t = ((float)linkTick + (float)partialTicks) / (float)maxLinkTick;
            Vec3 Coord = orginal.m_20318_((float)partialTicks);
            Vec3 targetPos = camera.m_90583_();
            Vec3 lastFramePos = pose.pos.m_82524_((float)Math.toRadians(-yawLock - 90.0f)).m_82549_(isLockPos ? posLock : Coord);
            Vec3 targetRelate = targetPos.m_82546_(Coord);
            Vec3 lastRelate = lastFramePos.m_82546_(Coord);
            targetRelate = MathUtils.ToCylindricalCoordinate(targetRelate);
            lastRelate = MathUtils.ToCylindricalCoordinate(lastRelate);
            Vec3 camPos = MathUtils.LerpMinCylindrical(lastRelate, targetRelate, t);
            camPos = MathUtils.ToCartesianCoordinates(camPos).m_82549_(Coord);
            float tmp = event.getYaw() - (yawLock - pose.rotY);
            if ((tmp %= 360.0f) > 0.0f) {
                tmp = Math.abs(tmp -= 360.0f) > tmp + 360.0f ? tmp + 360.0f : tmp;
            }
            float _rot_y = yawLock - pose.rotY + tmp * t;
            float _rot_x = MathUtils.lerpBetween(pose.rotX, event.getPitch(), t);
            float _rot_z = MathUtils.lerpBetween(pose.rotZ, event.getRoll(), t);
            camera.m_90584_(camPos.f_82479_, camPos.f_82480_, camPos.f_82481_);
            event.setYaw(_rot_y);
            event.setPitch(_rot_x);
            event.setRoll(_rot_z);
        } else {
            CameraAnimation.Pose pose;
            float time;
            if (patched == null) {
                time = ((float)tick + (float)partialTicks) / 20.0f;
            } else {
                AnimationPlayer animPlayer = CameraEvents.patched.getClientAnimator().baseLayer.animationPlayer;
                time = (float)((double)animPlayer.getPrevElapsedTime() + (double)(animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()) * partialTicks);
            }
            pose_ = pose = currentAnim.getPose(time);
            Vec3 camPos = pose.pos.m_82524_((float)Math.toRadians(-yawLock - 90.0f)).m_82549_(isLockPos ? posLock : orginal.m_20318_((float)partialTicks));
            camera.m_90584_(camPos.f_82479_, camPos.f_82480_, camPos.f_82481_);
            event.setYaw(yawLock - pose.rotY);
            event.setPitch(pose.rotX);
            event.setRoll(pose.rotZ);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void AnimateCamFov(ViewportEvent.ComputeFov event) {
        CameraType cameraType = Minecraft.m_91087_().f_91066_.m_92176_();
        if (cameraType.m_90612_() || cameraType.m_90613_()) {
            return;
        }
        if (isEnd && !linking || currentAnim == null) {
            return;
        }
        if (orginal == null) {
            isEnd = true;
            linking = false;
            return;
        }
        if (orginal.m_213877_()) {
            isEnd = true;
            linking = false;
            return;
        }
        double partialTicks = event.getPartialTick();
        if (linking) {
            CameraAnimation.Pose pose = pose_;
            float t = ((float)linkTick + (float)partialTicks) / (float)maxLinkTick;
            event.setFOV((double)((int)MathUtils.lerpBetween(pose.fov, fovO, t)));
        } else {
            CameraAnimation.Pose pose;
            pose_ = pose = currentAnim.getPose(((float)tick + (float)partialTicks) / 20.0f);
            event.setFOV((double)((int)pose.fov));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void Tick(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            if (!isEnd) {
                ++tick;
            }
            if (linking) {
                ++linkTick;
            }
        } else {
            return;
        }
        if (!isEnd && currentAnim != null && (float)tick / 20.0f >= CameraEvents.currentAnim.totalTime) {
            isEnd = true;
            linking = true;
            tick = 0;
            linkTick = 0;
        }
        if (linking && currentAnim != null && linkTick >= maxLinkTick) {
            isEnd = true;
            linking = false;
            linkTick = 0;
            tick = 0;
        }
    }

    public static void SetAnim(CameraAnimation anim, LivingEntity org, boolean lockOrgPos, AnimationManager.AnimationAccessor<?> animationAccessor) {
        if (org instanceof Player) {
            if (!((Player)org).m_7578_()) {
                return;
            }
        } else {
            return;
        }
        patched = null;
        orginal = org;
        yawLock = org.m_5675_(0.0f);
        posLock = org.m_20182_();
        linking = false;
        isEnd = false;
        tick = 0;
        linkTick = 0;
        maxLinkTick = 8;
        currentAnim = anim;
        isLockPos = lockOrgPos;
        fovO = ((Integer)Minecraft.m_91087_().f_91066_.f_92068_.m_231551_()).intValue();
    }

    public static void UpdateCoord(LivingEntity org) {
        if (org instanceof Player) {
            if (!((Player)org).m_7578_()) {
                return;
            }
        } else {
            return;
        }
        posLock = orginal.m_20182_();
    }

    public static void SetAnim(CameraAnimation anim, LivingEntityPatch<?> patch, boolean lockOrgPos) {
        LivingEntity org = (LivingEntity)patch.getOriginal();
        if (org instanceof Player) {
            if (!((Player)org).m_7578_()) {
                return;
            }
        } else {
            return;
        }
        patched = patch;
        orginal = org;
        yawLock = org.m_5675_(0.0f);
        posLock = org.m_20182_();
        linking = false;
        isEnd = false;
        tick = 0;
        linkTick = 0;
        maxLinkTick = 8;
        currentAnim = anim;
        isLockPos = lockOrgPos;
        fovO = ((Integer)Minecraft.m_91087_().f_91066_.f_92068_.m_231551_()).intValue();
    }

    static {
        yawLock = 0.0f;
        posLock = new Vec3(0.0, 0.0, 0.0);
        tick = 0;
        linkTick = 0;
        maxLinkTick = 3;
        isEnd = true;
        linking = false;
        fovO = 0.0f;
        isLockPos = false;
    }
}

