/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.capability;

import com.hm.efn.EFN;
import com.hm.efn.capability.EFNCapabilities;
import com.hm.efn.capability.yamato.network.S2CYamatoDodgeCapPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="efn", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EFNCapabilityHandler {
    public static void syncCaps(ServerPlayer player) {
        player.getCapability(EFNCapabilities.YAMATO_DODGE_CAP).ifPresent(cap -> EFN.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CYamatoDodgeCapPacket(cap.serializeNBT())));
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(EFNCapabilities.YAMATO_DODGE_CAP).ifPresent(cap -> event.getEntity().getCapability(EFNCapabilities.YAMATO_DODGE_CAP).ifPresent(cap2 -> cap2.deserializeNBT(cap.serializeNBT())));
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EFNCapabilityHandler.syncCaps(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EFNCapabilityHandler.syncCaps(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EFNCapabilityHandler.syncCaps(player2);
        }
    }
}

