/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class NoTextureJsonModel {
    static float u0 = 0.0f;
    static float u1 = 1.0f;
    static float v0 = 0.0f;
    static float v1 = 1.0f;
    public List<vec3f> Positions = new ArrayList<vec3f>();
    public List<Triangle> Face = new ArrayList<Triangle>();

    public static NoTextureJsonModel loadFromJson(ResourceLocation location) {
        NoTextureJsonModel obj;
        try {
            Resource resource = (Resource)Minecraft.m_91087_().m_91098_().m_213713_(location).get();
            InputStreamReader isr = new InputStreamReader(resource.m_215507_(), StandardCharsets.UTF_8);
            Gson gson = new Gson();
            obj = (NoTextureJsonModel)gson.fromJson((Reader)isr, new TypeToken<NoTextureJsonModel>(){}.getType());
            for (int i = 0; i < obj.Face.size(); ++i) {
                obj.Face.get(i).UpdateNormal(obj.Positions);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return obj;
    }

    public void render(VertexConsumer buffer, Quaternionf rot, Vector3f pos, float scale, Color color, int light) {
        for (Triangle triangle : this.Face) {
            Vector3f vertex1 = this.Positions.get(triangle.x - 1).toBugJumpFormat();
            Vector3f vertex2 = this.Positions.get(triangle.y - 1).toBugJumpFormat();
            Vector3f vertex3 = this.Positions.get(triangle.z - 1).toBugJumpFormat();
            if (rot != null) {
                vertex1.rotate((Quaternionfc)rot);
                vertex2.rotate((Quaternionfc)rot);
                vertex3.rotate((Quaternionfc)rot);
            }
            vertex1.mul(scale);
            vertex2.mul(scale);
            vertex3.mul(scale);
            vertex1.add((Vector3fc)pos);
            vertex2.add((Vector3fc)pos);
            vertex3.add((Vector3fc)pos);
            buffer.m_5483_((double)vertex1.x(), (double)vertex1.y(), (double)vertex1.z()).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_7421_(u0, v1).m_85969_(light).m_5752_();
            buffer.m_5483_((double)vertex2.x(), (double)vertex2.y(), (double)vertex2.z()).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_7421_(u0, v0).m_85969_(light).m_5752_();
            buffer.m_5483_((double)vertex3.x(), (double)vertex3.y(), (double)vertex3.z()).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_7421_(u1, v0).m_85969_(light).m_5752_();
        }
    }

    public void renderNeg(VertexConsumer buffer, Quaternionf rot, Vector3f pos, float scale, Color color, int light) {
        for (Triangle triangle : this.Face) {
            Vector3f vertex1 = this.Positions.get(triangle.x - 1).toBugJumpFormat();
            Vector3f vertex2 = this.Positions.get(triangle.y - 1).toBugJumpFormat();
            Vector3f vertex3 = this.Positions.get(triangle.z - 1).toBugJumpFormat();
            if (rot != null) {
                vertex1.rotate((Quaternionfc)rot);
                vertex2.rotate((Quaternionfc)rot);
                vertex3.rotate((Quaternionfc)rot);
            }
            vertex1.mul(scale);
            vertex2.mul(scale);
            vertex3.mul(scale);
            vertex1.add((Vector3fc)pos);
            vertex2.add((Vector3fc)pos);
            vertex3.add((Vector3fc)pos);
            buffer.m_5483_((double)vertex3.x(), (double)vertex3.y(), (double)vertex3.z()).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_7421_(u0, v1).m_85969_(light).m_5752_();
            buffer.m_5483_((double)vertex2.x(), (double)vertex2.y(), (double)vertex2.z()).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_7421_(u0, v0).m_85969_(light).m_5752_();
            buffer.m_5483_((double)vertex1.x(), (double)vertex1.y(), (double)vertex1.z()).m_6122_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_7421_(u1, v0).m_85969_(light).m_5752_();
        }
    }

    public static class Triangle {
        public int x;
        public int y;
        public int z;
        public vec3f Normal;

        public void UpdateNormal(List<vec3f> pos) {
            Vector3f p1 = pos.get(this.x - 1).toBugJumpFormat();
            Vector3f p2 = pos.get(this.y - 1).toBugJumpFormat();
            Vector3f p3 = pos.get(this.z - 1).toBugJumpFormat();
            p1.sub((Vector3fc)p2);
            p1.normalize();
            p2.sub((Vector3fc)p3);
            p2.normalize();
            p1.cross((Vector3fc)p2);
            p1.normalize();
            this.Normal = new vec3f(p1.x(), p1.y(), p1.z());
        }
    }

    public static class vec3f {
        public float x;
        public float y;
        public float z;

        public vec3f(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vector3f toBugJumpFormat() {
            return new Vector3f(this.x, this.y, this.z);
        }
    }
}

