/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.input;

import com.hm.efn.gameasset.combos.Aetherialdusk;
import com.hm.efn.gameasset.combos.Bloodlust;
import com.hm.efn.gameasset.combos.Exsiliumgladius;
import com.hm.efn.gameasset.combos.Meenlance;
import com.hm.efn.gameasset.combos.Murasama;
import com.hm.efn.gameasset.combos.Pioneer;
import com.hm.efn.gameasset.combos.Ruinsgreatsword;
import com.hm.efn.gameasset.combos.Shortsword;
import com.hm.efn.gameasset.combos.Yamato;
import com.mojang.blaze3d.platform.InputConstants;
import com.p1nero.invincible.skill.ComboBasicAttack;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class EFNWeaponInputConflictHandler {
    private static boolean shouldBlockInnateSkill = false;
    private static boolean isGuiOpen = false;
    private static InputConstants.Key originalKey = null;
    private static boolean keyModified = false;
    private static final int CHECK_COOLDOWN_TICKS = 3;
    private static int checkCooldown = 0;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        boolean newGuiState;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (checkCooldown > 0) {
            --checkCooldown;
            return;
        }
        checkCooldown = 3;
        boolean bl = newGuiState = mc.f_91080_ != null;
        if (newGuiState != isGuiOpen && (isGuiOpen = newGuiState)) {
            EFNWeaponInputConflictHandler.restoreOriginalKeyIfNeeded();
        }
        if (!isGuiOpen && player != null) {
            PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
            if (playerPatch != null) {
                boolean newBlockState = EFNWeaponInputConflictHandler.checkWeaponConditions(playerPatch);
                if (newBlockState != shouldBlockInnateSkill) {
                    shouldBlockInnateSkill = newBlockState;
                    EFNWeaponInputConflictHandler.updateKeyState(shouldBlockInnateSkill);
                }
            } else if (shouldBlockInnateSkill) {
                shouldBlockInnateSkill = false;
                EFNWeaponInputConflictHandler.updateKeyState(false);
            }
        } else if (shouldBlockInnateSkill) {
            shouldBlockInnateSkill = false;
            EFNWeaponInputConflictHandler.updateKeyState(false);
        }
    }

    private static boolean checkWeaponConditions(PlayerPatch<?> playerPatch) {
        SkillContainer container = playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
        boolean hasContainer = container != null;
        boolean isComboBasicAttack = hasContainer && container.getSkill() instanceof ComboBasicAttack;
        boolean hasSpecialWeapon = EFNWeaponInputConflictHandler.hasRequiredWeapon(playerPatch);
        return hasContainer && isComboBasicAttack && hasSpecialWeapon;
    }

    private static void updateKeyState(boolean block) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        KeyMapping weaponSkill = EpicFightKeyMappings.WEAPON_INNATE_SKILL;
        mc.execute(() -> {
            if (block) {
                if (!keyModified && !weaponSkill.getKey().equals((Object)InputConstants.f_84822_)) {
                    originalKey = weaponSkill.getKey();
                    keyModified = true;
                }
                if (keyModified) {
                    weaponSkill.m_90848_(InputConstants.f_84822_);
                }
            } else {
                EFNWeaponInputConflictHandler.restoreOriginalKeyIfNeeded();
            }
            weaponSkill.m_7249_(false);
        });
    }

    private static void restoreOriginalKeyIfNeeded() {
        if (keyModified && originalKey != null) {
            KeyMapping weaponSkill = EpicFightKeyMappings.WEAPON_INNATE_SKILL;
            weaponSkill.m_90848_(originalKey);
            weaponSkill.m_7249_(false);
            keyModified = false;
            originalKey = null;
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        if (!shouldBlockInnateSkill || isGuiOpen) {
            return;
        }
        KeyMapping weaponSkill = EpicFightKeyMappings.WEAPON_INNATE_SKILL;
        if (weaponSkill.isActiveAndMatches(InputConstants.m_84827_((int)event.getKey(), (int)event.getScanCode()))) {
            weaponSkill.m_7249_(false);
            while (weaponSkill.m_90859_()) {
            }
        }
    }

    private static boolean hasRequiredWeapon(PlayerPatch<?> playerPatch) {
        return playerPatch.getSkill(Aetherialdusk.Aetherialdusk) != null || playerPatch.getSkill(Meenlance.Meenlance) != null || playerPatch.getSkill(Ruinsgreatsword.Ruinsgreatsword) != null || playerPatch.getSkill(Pioneer.pioneer) != null || playerPatch.getSkill(Bloodlust.Bloodlust) != null || playerPatch.getSkill(Shortsword.shortsword) != null || playerPatch.getSkill(Exsiliumgladius.exsiliumgladius) != null || playerPatch.getSkill(Yamato.yamato) != null || playerPatch.getSkill(Murasama.Murasama) != null;
    }
}

