/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.particle;

import com.hm.efn.client.render.EFNRenderType;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.particle.AnimationTrailParticle;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class BloomTrailParticle
extends AnimationTrailParticle {
    protected BloomTrailParticle(ClientLevel level, LivingEntityPatch<?> owner, Joint joint, AssetAccessor<? extends StaticAnimation> animation, TrailInfo trailInfo) {
        super(level, owner, joint, animation, trailInfo);
    }

    public boolean shouldCull() {
        return false;
    }

    public ParticleRenderType m_7556_() {
        return EFNRenderType.getBloomTrailRT(this.trailInfo.texturePath());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Provider(SpriteSet spriteSet) {
        }

        public Particle createParticle(@NotNull SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ItemStack stack;
            RenderItemBase renderItemBase;
            int eid = (int)Double.doubleToRawLongBits(x);
            int animid = (int)Double.doubleToRawLongBits(z);
            int jointId = (int)Double.doubleToRawLongBits(xSpeed);
            int idx = (int)Double.doubleToRawLongBits(ySpeed);
            Entity entity = level.m_6815_(eid);
            if (entity == null) {
                return null;
            }
            LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, LivingEntityPatch.class);
            if (entitypatch == null) {
                return null;
            }
            AnimationManager.AnimationAccessor animation = AnimationManager.byId((int)animid);
            if (animation == null) {
                return null;
            }
            Optional trailInfo = ((StaticAnimation)animation.get()).getProperty((AnimationProperty)ClientAnimationProperties.TRAIL_EFFECT);
            if (trailInfo.isEmpty()) {
                return null;
            }
            TrailInfo result = (TrailInfo)((List)trailInfo.get()).get(idx);
            if (result.hand() != null && (renderItemBase = ClientEngine.getInstance().renderEngine.getItemRenderer(stack = ((LivingEntity)entitypatch.getOriginal()).m_21120_(result.hand()))) != null && renderItemBase.trailInfo() != null) {
                result = renderItemBase.trailInfo().overwrite(result);
            }
            if (result.playable()) {
                return new BloomTrailParticle(level, entitypatch, entitypatch.getArmature().searchJointById(jointId), (AssetAccessor<? extends StaticAnimation>)animation, result);
            }
            return null;
        }
    }
}

