/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.particle;

import com.hm.efn.client.particle.rendertype.EFNHitParticle;
import com.hm.efn.client.pipeline.PostEffectPipelines;
import com.hm.efn.client.render.EFNRenderType;
import com.hm.efn.particle.EFNParticles;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import yesman.epicfight.config.ClientConfig;

@OnlyIn(value=Dist.CLIENT)
public class SlashParticle
extends EFNHitParticle {
    public SlashParticle(ClientLevel world, double x, double y, double z, SpriteSet animatedSprite) {
        super(world, x, y, z, animatedSprite);
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.f_107663_ = 2.0f;
        this.f_107225_ = 14;
        this.f_107208_.m_7106_((ParticleOptions)EFNParticles.COLOR_SLASH.get(), x, y, z, 0.0, 0.0, 0.0);
        this.f_107208_.m_7106_((ParticleOptions)EFNParticles.SLASH_RING.get(), x, y, z, 0.0, 0.0, 0.0);
    }

    private Vector4f applyVertexDistortion(Vec3 position, float time, float intensity, Matrix4f matrix) {
        float timeFactor = time * 1.5f;
        float x = (float)position.f_82479_;
        float y = (float)position.f_82480_;
        float z = (float)position.f_82481_;
        float offsetX = Mth.m_14031_((float)(timeFactor + x * 0.5f)) * intensity + Mth.m_14089_((float)(timeFactor * 0.8f + z * 0.3f)) * intensity * 0.6f;
        float offsetY = Mth.m_14031_((float)(timeFactor * 1.2f + x * 0.2f)) * intensity * 0.4f;
        float offsetZ = Mth.m_14089_((float)(timeFactor * 0.7f + z * 0.4f)) * intensity - Mth.m_14031_((float)(timeFactor * 0.9f)) * intensity * 0.3f;
        return new Vector4f(x + offsetX, y + offsetY, z + offsetZ, 1.0f).mul((Matrix4fc)matrix);
    }

    @Override
    public void m_5744_(@NotNull VertexConsumer vertexConsumer, @NotNull Camera camera, float partialTick) {
        if (!PostEffectPipelines.isActive()) {
            return;
        }
        EFNRenderType.getBloomRenderTypeByTexture(this.f_108321_.m_247685_()).callPipeline();
        Vec3 cameraPos = camera.m_90583_();
        float x = (float)(this.f_107212_ - cameraPos.m_7096_());
        float y = (float)(this.f_107213_ - cameraPos.m_7098_());
        float z = (float)(this.f_107214_ - cameraPos.m_7094_());
        Quaternionf rotation = camera.m_253121_();
        Vector3f[] vertices = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float size = this.f_107663_;
        float time = ((float)this.f_107224_ + partialTick) * 3.0f;
        float intensity = 0.18f;
        Matrix4f transformMatrix = new Matrix4f();
        transformMatrix.translation(x, y, z);
        transformMatrix.rotate((Quaternionfc)rotation);
        transformMatrix.scale(size);
        Vector4f[] distortedVertices = new Vector4f[4];
        for (int i = 0; i < 4; ++i) {
            Vec3 vertexPos = new Vec3((double)vertices[i].x(), (double)vertices[i].y(), (double)vertices[i].z());
            distortedVertices[i] = this.applyVertexDistortion(vertexPos, time, intensity, transformMatrix);
        }
        float u0 = this.f_108321_.m_118409_();
        float u1 = this.f_108321_.m_118410_();
        float v0 = this.f_108321_.m_118411_();
        float v1 = this.f_108321_.m_118412_();
        int light = this.m_6355_(partialTick);
        vertexConsumer.m_5483_((double)distortedVertices[0].x(), (double)distortedVertices[0].y(), (double)distortedVertices[0].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7421_(u1, v1).m_85969_(light).m_5752_();
        vertexConsumer.m_5483_((double)distortedVertices[1].x(), (double)distortedVertices[1].y(), (double)distortedVertices[1].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7421_(u1, v0).m_85969_(light).m_5752_();
        vertexConsumer.m_5483_((double)distortedVertices[2].x(), (double)distortedVertices[2].y(), (double)distortedVertices[2].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7421_(u0, v0).m_85969_(light).m_5752_();
        vertexConsumer.m_5483_((double)distortedVertices[3].x(), (double)distortedVertices[3].y(), (double)distortedVertices[3].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_7421_(u0, v1).m_85969_(light).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            if (!ClientConfig.bloodEffects) {
                return null;
            }
            SlashParticle particle = new SlashParticle(worldIn, x, y, z, this.spriteSet);
            return particle;
        }
    }
}

