/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.pipeline;

import com.hm.efn.client.pipeline.PostEffectPipelines;
import com.hm.efn.registries.PostPasses;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class PostMeshParticleRenderType
implements ParticleRenderType {
    static ResourceLocation tempTarget = new ResourceLocation("efn:depth_cull_temp2");
    protected final ResourceLocation renderTypeID;
    protected final ResourceLocation texture;
    public int priority = 0;

    public PostMeshParticleRenderType(ResourceLocation renderTypeID, ResourceLocation texture) {
        this.renderTypeID = renderTypeID;
        this.texture = texture;
    }

    public static RenderTarget createTempTarget(RenderTarget screenTarget) {
        TextureTarget rendertarget = new TextureTarget(screenTarget.f_83915_, screenTarget.f_83916_, true, Minecraft.f_91002_);
        rendertarget.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
        rendertarget.m_83954_(Minecraft.f_91002_);
        return rendertarget;
    }

    public static void Blit(RenderTarget source, RenderTarget output) {
        PostPasses.blit.process(source, output, effect -> {});
    }

    public void m_6505_(@NotNull BufferBuilder bufferBuilder, @NotNull TextureManager textureManager) {
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.setShader(this::getShader);
        if (this.texture != null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        }
        this.getPipeline().start();
        this.setupBufferBuilder(bufferBuilder);
    }

    protected ShaderInstance getShader() {
        return GameRenderer.f_172588_;
    }

    public void callPipeline() {
        this.getPipeline().call();
    }

    public boolean tryCallPipeline() {
        if (!PostEffectPipelines.isActive()) {
            this.callPipeline();
            return true;
        }
        return false;
    }

    public void m_6294_(Tesselator tesselator) {
        tesselator.m_85915_().m_277127_(VertexSorting.f_276633_);
        tesselator.m_85914_();
        this.getPipeline().suspend();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
    }

    public void setupBufferBuilder(BufferBuilder bufferBuilder) {
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85820_);
    }

    public abstract PostEffectPipelines.Pipeline getPipeline();

    public String toString() {
        return this.renderTypeID.toString();
    }
}

