/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.render.custom;

import com.hm.efn.client.pipeline.PostEffectPipelines;
import com.hm.efn.client.pipeline.PostParticleRenderType;
import com.hm.efn.client.targets.TargetManager;
import com.hm.efn.registries.PostPasses;
import com.hm.efn.util.OjangUtils;
import com.hm.efn.util.RenderUtils;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;

public class AirDisturbanceRenderType
extends PostParticleRenderType {
    static final PostEffectPipelines.Pipeline ppl = new Pipeline(OjangUtils.newRL("efn", "air_disturbance"), 150);
    private final float strength;
    private final float speed;
    private final float directionX;
    private final float directionY;
    private final float bladeLength;

    public AirDisturbanceRenderType(ResourceLocation name, float strength, float speed, float directionX, float directionY, float bladeLength) {
        super(name, RenderUtils.GetTexture("particle/air_trail"));
        this.strength = strength;
        this.speed = speed;
        this.directionX = directionX;
        this.directionY = directionY;
        this.bladeLength = bladeLength;
        this.priority = 1000;
    }

    @Override
    protected ShaderInstance getShader() {
        return GameRenderer.f_172586_;
    }

    @Override
    public void setupBufferBuilder(BufferBuilder bufferBuilder) {
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
    }

    @Override
    public PostEffectPipelines.Pipeline getPipeline() {
        return ppl;
    }

    public static class Pipeline
    extends PostEffectPipelines.Pipeline {
        private static final ResourceLocation tmpTarget = OjangUtils.newRL("efn", "air_disturbance_tmp");
        private float currentTime = 0.0f;
        private float progress = 0.0f;
        private boolean animationStarted = false;

        public Pipeline(ResourceLocation name, int priority) {
            super(name);
            this.priority = priority;
        }

        @Override
        public void start() {
            if (this.started) {
                if (PostEffectPipelines.isActive()) {
                    this.bufferTarget.m_83947_(false);
                }
            } else {
                if (this.bufferTarget == null) {
                    this.bufferTarget = TargetManager.getTarget(this.name);
                    this.bufferTarget.m_83954_(Minecraft.f_91002_);
                }
                RenderTarget main = PostEffectPipelines.getSource();
                if (PostEffectPipelines.isActive()) {
                    this.bufferTarget.m_83945_(main);
                    PostEffectPipelines.PostEffectQueue.add(this);
                    this.bufferTarget.m_83947_(false);
                    this.started = true;
                    if (!this.animationStarted) {
                        this.currentTime = 0.0f;
                        this.progress = 0.0f;
                        this.animationStarted = true;
                    }
                }
            }
        }

        @Override
        public void suspend() {
            if (PostEffectPipelines.isActive()) {
                this.bufferTarget.m_83970_();
                this.bufferTarget.m_83963_();
                RenderTarget rt = PostEffectPipelines.getSource();
                rt.m_83947_(false);
            } else {
                PostEffectPipelines.getSource().m_83947_(false);
            }
        }

        void handleDisturbanceEffect(RenderTarget src) {
            RenderTarget tmp = TargetManager.getTarget(tmpTarget);
            RenderTarget main = Minecraft.m_91087_().m_91385_();
            this.updateAnimation();
            float strength = 0.15f;
            float speed = 3.0f;
            float directionX = 1.0f;
            float directionY = 0.0f;
            float bladeLength = 0.5f;
            PostPasses.air_disturbance.process(main, src, tmp, strength * this.getCurrentStrength(), this.currentTime, this.progress, directionX, directionY, bladeLength);
            PostPasses.blit.process(tmp, main);
            TargetManager.ReleaseTarget(tmpTarget);
        }

        private void updateAnimation() {
            if (this.animationStarted) {
                this.currentTime += 0.05f;
                this.progress = this.calculateProgress();
                if (this.progress <= 0.0f) {
                    this.animationStarted = false;
                }
            }
        }

        private float calculateProgress() {
            float duration = 2.0f;
            float normalizedTime = this.currentTime / duration;
            if (normalizedTime < 0.3f) {
                return normalizedTime / 0.3f;
            }
            if (normalizedTime < 1.0f) {
                return 1.0f - (normalizedTime - 0.3f) / 0.7f;
            }
            return 0.0f;
        }

        private float getCurrentStrength() {
            float normalizedTime = this.currentTime / 2.0f;
            if (normalizedTime > 0.5f) {
                float fade = 1.0f - (normalizedTime - 0.5f) / 0.5f;
                return fade * fade;
            }
            return 1.0f;
        }

        @Override
        public void PostEffectHandler() {
            this.handleDisturbanceEffect(this.bufferTarget);
        }
    }
}

