/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.render.custom;

import com.hm.efn.client.pipeline.PostEffectPipelines;
import com.hm.efn.client.pipeline.PostMeshParticleRenderType;
import com.hm.efn.client.targets.TargetManager;
import com.hm.efn.registries.PostPasses;
import com.hm.efn.util.OjangUtils;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class MeshSpaceBrokenRenderType
extends PostMeshParticleRenderType {
    static final PostEffectPipelines.Pipeline ppl1 = new Pipeline(OjangUtils.newRL("efn", "space_broken_0"), 10);
    static final PostEffectPipelines.Pipeline ppl2 = new Pipeline(OjangUtils.newRL("efn", "space_broken_1"), 11);
    final int layer;
    final int vertex;
    private final VertexFormat.Mode renderMode;
    private final VertexFormat vertexFormat;

    public MeshSpaceBrokenRenderType(ResourceLocation name, ResourceLocation texture, int layer, int vertexCount) {
        super(name, texture);
        this.layer = layer;
        this.vertex = vertexCount;
        this.priority = 1000;
        this.renderMode = VertexFormat.Mode.TRIANGLES;
        this.vertexFormat = DefaultVertexFormat.f_85813_;
    }

    @Override
    public void setupBufferBuilder(BufferBuilder bufferBuilder) {
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85813_);
    }

    @Override
    public PostEffectPipelines.Pipeline getPipeline() {
        return this.layer == 0 ? ppl1 : ppl2;
    }

    public static class Pipeline
    extends PostEffectPipelines.Pipeline {
        private static final ResourceLocation tmpTarget = OjangUtils.newRL("efn", "space_broken_tmp2");

        public Pipeline(ResourceLocation name, int priority) {
            super(name);
            this.priority = priority;
        }

        @Override
        public void start() {
            if (this.started) {
                if (PostEffectPipelines.isActive()) {
                    this.bufferTarget.m_83947_(false);
                }
            } else {
                if (this.bufferTarget == null) {
                    this.bufferTarget = TargetManager.getTarget(this.name);
                    this.bufferTarget.m_83954_(Minecraft.f_91002_);
                }
                RenderTarget main = PostEffectPipelines.getSource();
                if (PostEffectPipelines.isActive()) {
                    this.bufferTarget.m_83945_(main);
                    PostEffectPipelines.PostEffectQueue.add(this);
                    this.bufferTarget.m_83947_(false);
                    this.started = true;
                }
            }
        }

        @Override
        public void suspend() {
            if (PostEffectPipelines.isActive()) {
                this.bufferTarget.m_83970_();
                this.bufferTarget.m_83963_();
                RenderTarget rt = PostEffectPipelines.getSource();
                rt.m_83947_(false);
            } else {
                PostEffectPipelines.getSource().m_83947_(false);
            }
        }

        void handlePasses(RenderTarget src) {
            RenderTarget tmp = TargetManager.getTarget(tmpTarget);
            RenderTarget main = Minecraft.m_91087_().m_91385_();
            PostPasses.space_broken.process(main, src, tmp);
            PostPasses.blit.process(tmp, main);
            TargetManager.ReleaseTarget(tmpTarget);
        }

        @Override
        public void PostEffectHandler() {
            this.handlePasses(this.bufferTarget);
        }
    }
}

