/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.screeneffect;

import com.hm.efn.client.pipeline.PostEffectPipelines;
import com.hm.efn.client.screeneffect.ScreenEffectBase;
import com.hm.efn.client.targets.TargetManager;
import com.hm.efn.registries.PostPasses;
import com.hm.efn.util.OjangUtils;
import com.mojang.blaze3d.pipeline.RenderTarget;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class ScreenDistortionEffect
extends ScreenEffectBase {
    static ResourceLocation screen_distortion = OjangUtils.newRL("efn", "screen_distortion");
    public final ScreenEffectBase.SE_Pipeline ppl = new Distortion_Pipeline(this);
    public float maxDistortion = 0.1f;
    public float frequency = 5.0f;
    public float distortionSpeed = 2.0f;

    public ScreenDistortionEffect(Vec3 pos) {
        this(pos, 60, 0.1f, 5.0f, 2.0f);
    }

    public ScreenDistortionEffect(Vec3 pos, int lifetime, float maxDistortion, float frequency, float distortionSpeed) {
        super(screen_distortion, pos);
        this.lifetime = lifetime;
        this.maxDistortion = maxDistortion;
        this.frequency = frequency;
        this.distortionSpeed = distortionSpeed;
    }

    @Override
    public PostEffectPipelines.Pipeline getPipeline() {
        return this.ppl;
    }

    public static class Distortion_Pipeline
    extends ScreenEffectBase.SE_Pipeline<ScreenDistortionEffect> {
        static ResourceLocation distortion_tmp = OjangUtils.newRL("efn", "distortion_tmp");

        public Distortion_Pipeline(ScreenDistortionEffect effect) {
            super(screen_distortion, effect);
            this.priority = 100;
        }

        @Override
        public void PostEffectHandler() {
            RenderTarget tmp = TargetManager.getTarget(distortion_tmp);
            PostPasses.blit.process(Minecraft.m_91087_().m_91385_(), tmp);
            float progress = this.getDistortionProgress();
            float currentDistortion = ((ScreenDistortionEffect)this.effect).maxDistortion * this.getDistortionIntensity(progress);
            float time = (float)((ScreenDistortionEffect)this.effect).age * 0.05f * ((ScreenDistortionEffect)this.effect).distortionSpeed;
            PostPasses.screen_distortion.process(tmp, Minecraft.m_91087_().m_91385_(), currentDistortion, ((ScreenDistortionEffect)this.effect).frequency, time, progress);
        }

        private float getDistortionProgress() {
            float normalizedAge = ((ScreenDistortionEffect)this.effect).getNormalizedAgeWithPartialTicks();
            float baseProgress = Mth.m_14031_((float)(normalizedAge * (float)Math.PI));
            if (normalizedAge > 0.8f) {
                float endFade = 1.0f - (normalizedAge - 0.7f) / 0.3f;
                endFade = endFade * endFade * (3.0f - 2.0f * endFade);
                baseProgress *= endFade;
            }
            return baseProgress;
        }

        private float getDistortionIntensity(float progress) {
            float normalizedAge = ((ScreenDistortionEffect)this.effect).getNormalizedAgeWithPartialTicks();
            float baseIntensity = 4.0f * progress * (1.0f - progress);
            if (normalizedAge > 0.75f) {
                float endFade = 1.0f - (normalizedAge - 0.6f) / 0.4f;
                endFade = Mth.m_14116_((float)endFade);
                baseIntensity *= endFade;
            }
            return baseIntensity;
        }
    }
}

