/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.screeneffect;

import com.hm.efn.client.pipeline.PostEffectPipelines;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class ScreenEffectBase {
    public final ResourceLocation ID;
    public int age = 0;
    public int lifetime = 20;
    public Vec3 pos;
    protected float partialAge = 0.0f;

    public ScreenEffectBase(ResourceLocation id, Vec3 pos) {
        this.ID = id;
        this.pos = pos;
    }

    public void tick() {
        if (++this.age > this.lifetime) {
            // empty if block
        }
    }

    public void updateWithPartialTicks(float partialTicks) {
        this.partialAge = (float)this.age + partialTicks;
    }

    public boolean shouldRemoved() {
        return this.age > this.lifetime;
    }

    public void setRemove() {
        this.age = this.lifetime + 1;
    }

    public float getAgeWithPartialTicks() {
        return this.partialAge;
    }

    public float getNormalizedAgeWithPartialTicks() {
        return this.partialAge / (float)this.lifetime;
    }

    public abstract PostEffectPipelines.Pipeline getPipeline();

    public boolean shouldPost(Camera camera, Frustum clippingHelper) {
        return clippingHelper != null && clippingHelper.m_113029_(this.getAABB()) && camera.m_90583_().m_82546_(this.pos).m_82553_() < 256.0;
    }

    public AABB getAABB() {
        return new AABB(this.pos.m_82492_(0.2, 0.2, 0.2), this.pos.m_82520_(0.2, 0.2, 0.2));
    }

    public int hashCode() {
        return this.ID.hashCode();
    }

    public static abstract class SE_Pipeline<E extends ScreenEffectBase>
    extends PostEffectPipelines.Pipeline {
        public final E effect;
        public float partialTicks = 0.0f;

        public SE_Pipeline(ResourceLocation name, E effect) {
            super(name);
            this.effect = effect;
        }

        protected float getPartialTicks() {
            return this.partialTicks;
        }

        public void setPartialTicks(float partialTicks) {
            this.partialTicks = partialTicks;
            ((ScreenEffectBase)this.effect).updateWithPartialTicks(partialTicks);
        }

        @Override
        public void HandlePostEffect() {
            this.PostEffectHandler();
        }

        @Override
        public abstract void PostEffectHandler();
    }
}

