/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.comboevents;

import com.hm.efn.registries.EFNDataKey;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class PressKeyCondition
implements Condition<ServerPlayerPatch> {
    private final TargetKey targetKey;

    public PressKeyCondition(TargetKey targetKey) {
        this.targetKey = targetKey;
    }

    public Condition<ServerPlayerPatch> read(CompoundTag tag) {
        try {
            return new PressKeyCondition(TargetKey.valueOf(tag.m_128461_("targetKey")));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("targetKey", this.targetKey.name());
        return tag;
    }

    public boolean predicate(ServerPlayerPatch playerPatch) {
        if (playerPatch == null || !(playerPatch.getOriginal() instanceof ServerPlayer)) {
            return false;
        }
        SkillContainer container = playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
        if (container == null) {
            return false;
        }
        SkillDataManager manager = container.getDataManager();
        if (manager == null) {
            return false;
        }
        Boolean isPressed = (Boolean)manager.getDataValue(this.targetKey.getKey());
        return Boolean.TRUE.equals(isPressed);
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return Collections.emptyList();
    }

    public static enum TargetKey {
        KEY1(EFNDataKey.KEY1_PRESS),
        KEY2(EFNDataKey.KEY2_PRESS),
        KEY3(EFNDataKey.KEY3_PRESS),
        KEY4(EFNDataKey.KEY4_PRESS),
        INNATE(EFNDataKey.INNATE_PRESS);

        private final Supplier<SkillDataKey<Boolean>> keySupplier;

        private TargetKey(Supplier<SkillDataKey<Boolean>> keySupplier) {
            this.keySupplier = keySupplier;
        }

        public SkillDataKey<Boolean> getKey() {
            return this.keySupplier.get();
        }
    }
}

