/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.entity;

import com.hm.efn.gameasset.EFNAnimations;
import com.merlin204.avalon.avalon.vfx.type.AnimationTextureAvalonVFXManager;
import com.merlin204.avalon.avalon.vfx.type.StaticAvalonVFXManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.utils.math.Vec3f;

public class EFNVFXManagers {
    public static final StaticAvalonVFXManager YMD1 = new StaticAvalonVFXManager("efn:entity/effect/ymd1", "efn:entity/effect/ymd1", "efn:textures/entity/ymd1.png", "efn:textures/entity/ymd1.png", EFNAnimations.YMD_EFFECT1);
    public static final StaticAvalonVFXManager YMD2 = new StaticAvalonVFXManager("efn:entity/effect/ymd1", "efn:entity/effect/ymd1", "efn:textures/entity/ymd2.png", "efn:textures/entity/ymd2.png", EFNAnimations.YMD_EFFECT1);
    public static final StaticAvalonVFXManager YMD3 = new StaticAvalonVFXManager("efn:entity/effect/ymd2", "efn:entity/effect/ymd2", "efn:textures/entity/ymd3.png", "efn:textures/entity/ymd3.png", EFNAnimations.YMD_EFFECT2);
    public static final AnimationTextureAvalonVFXManager BLOOD_SLASH = new AnimationTextureAvalonVFXManager("efn:entity/effect/blood_slash", "efn:entity/effect/blood_slash", "efn:textures/entity/blood_slash", "efn:textures/entity/blood_slash", 1, 5, 1.0f, EFNAnimations.BLOOD_SLASH);
    public static final StaticAvalonVFXManager TRAIL = new StaticAvalonVFXManager("efn:entity/effect/trail", "efn:entity/effect/trail", "efn:textures/entity/trail.png", "efn:textures/entity/trail.png", EFNAnimations.TRAIL);

    public static AnimationEvent.InTimeEvent summonVFX(StaticAvalonVFXManager vfxManager, int startFrame, double forwardDist, double heightOffset, double sideOffset, float scale, Vec3f rotOffset) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity rawEntity = entityPatch.getOriginal();
            if (!(rawEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)rawEntity;
            Level patt2563$temp = owner.m_9236_();
            if (!(patt2563$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt2563$temp;
            Vec3 spawnPos = EFNVFXManagers.calculateEffectPosition(owner, forwardDist, heightOffset, sideOffset);
            vfxManager.spawnVFXEntity(owner, spawnPos, rotOffset, scale);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InTimeEvent summonConditionalVFX(StaticAvalonVFXManager vfxManager, int startFrame, double forwardDist, double heightOffset, double sideOffset, float scale, Vec3f rotOffset, MobEffect potionEffect) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity rawEntity = entityPatch.getOriginal();
            if (!(rawEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)rawEntity;
            Level patt3464$temp = owner.m_9236_();
            if (!(patt3464$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt3464$temp;
            if (!owner.m_21023_(potionEffect)) {
                return;
            }
            Vec3 spawnPos = EFNVFXManagers.calculateEffectPosition(owner, forwardDist, heightOffset, sideOffset);
            vfxManager.spawnVFXEntity(owner, spawnPos, rotOffset, scale);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InTimeEvent summonConditionalVFX(AnimationTextureAvalonVFXManager vfxManager, int startFrame, double forwardDist, double heightOffset, double sideOffset, float scale, Vec3f rotOffset, MobEffect potionEffect) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity rawEntity = entityPatch.getOriginal();
            if (!(rawEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)rawEntity;
            Level patt4468$temp = owner.m_9236_();
            if (!(patt4468$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt4468$temp;
            if (!owner.m_21023_(potionEffect)) {
                return;
            }
            Vec3 spawnPos = EFNVFXManagers.calculateEffectPosition(owner, forwardDist, heightOffset, sideOffset);
            vfxManager.spawnVFXEntity(owner, spawnPos, rotOffset, scale);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InTimeEvent summonVFXAtPosition(StaticAvalonVFXManager vfxManager, int startFrame, double worldX, double worldY, double worldZ, float scale, Vec3f rotOffset) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity rawEntity = entityPatch.getOriginal();
            if (!(rawEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)rawEntity;
            Level patt5409$temp = owner.m_9236_();
            if (!(patt5409$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt5409$temp;
            Vec3 spawnPos = new Vec3(worldX, worldY, worldZ);
            vfxManager.spawnVFXEntity(owner, spawnPos, rotOffset, scale);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InTimeEvent summonVFXAtTarget(StaticAvalonVFXManager vfxManager, int startFrame, float scale, Vec3f rotOffset, double heightAdjust) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity rawEntity = entityPatch.getOriginal();
            if (!(rawEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)rawEntity;
            Level patt6166$temp = owner.m_9236_();
            if (!(patt6166$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt6166$temp;
            LivingEntity target = entityPatch.getTarget();
            if (target == null) {
                return;
            }
            Vec3 spawnPos = target.m_20182_().m_82520_(0.0, heightAdjust, 0.0);
            vfxManager.spawnVFXEntity(owner, spawnPos, rotOffset, scale);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InTimeEvent summonVFXSmart(StaticAvalonVFXManager vfxManager, int startFrame, float scale, Vec3f rotOffset, double targetHeightAdjust) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity rawEntity = entityPatch.getOriginal();
            if (!(rawEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)rawEntity;
            Level patt7032$temp = owner.m_9236_();
            if (!(patt7032$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt7032$temp;
            LivingEntity target = entityPatch.getTarget();
            Vec3 spawnPos = target != null && EFNVFXManagers.isTargetInRange(owner, (Entity)target, 5.5) ? target.m_20182_().m_82520_(0.0, targetHeightAdjust, 0.0) : EFNVFXManagers.calculateEffectPosition(owner, 4.0, -1.3f, 0.0);
            vfxManager.spawnVFXEntity(owner, spawnPos, rotOffset, scale);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InTimeEvent summonVFXSmartAdvanced(StaticAvalonVFXManager vfxManager, int startFrame, float scale, Vec3f rotOffset, double targetHeightAdjust, double maxTargetRange, double defaultForwardDist, double defaultHeightOffset, double defaultSideOffset) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity rawEntity = entityPatch.getOriginal();
            if (!(rawEntity instanceof LivingEntity)) {
                return;
            }
            LivingEntity owner = (LivingEntity)rawEntity;
            Level patt8240$temp = owner.m_9236_();
            if (!(patt8240$temp instanceof ServerLevel)) {
                return;
            }
            ServerLevel level = (ServerLevel)patt8240$temp;
            LivingEntity target = entityPatch.getTarget();
            Vec3 spawnPos = target != null && EFNVFXManagers.isTargetInRange(owner, (Entity)target, maxTargetRange) ? target.m_20182_().m_82520_(0.0, targetHeightAdjust, 0.0) : EFNVFXManagers.calculateEffectPosition(owner, defaultForwardDist, defaultHeightOffset, defaultSideOffset);
            vfxManager.spawnVFXEntity(owner, spawnPos, rotOffset, scale);
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    private static boolean isTargetInRange(LivingEntity owner, Entity target, double range) {
        double distanceSq = owner.m_20280_(target);
        return distanceSq <= range * range;
    }

    private static Vec3 calculateEffectPosition(LivingEntity owner, double forward, double height, double side) {
        Vec3 horizontalLook = new Vec3(Math.sin((double)(-owner.m_146908_()) * (Math.PI / 180)), 0.0, Math.cos((double)owner.m_146908_() * (Math.PI / 180))).m_82541_();
        Vec3 right = new Vec3(-horizontalLook.f_82481_, 0.0, horizontalLook.f_82479_).m_82541_();
        return owner.m_146892_().m_82549_(horizontalLook.m_82490_(forward)).m_82549_(right.m_82490_(side)).m_82520_(0.0, height, 0.0);
    }
}

