/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.entity.effect.SinSummonedSwordEntity;

import com.hm.efn.client.sound.EFNSounds;
import com.hm.efn.entity.doppelganger.DoppelgangerEntity;
import com.hm.efn.entity.effect.SinSummonedSwordEntity.SinSummonedSwordEntity;
import com.merlin204.avalon.entity.vfx.VFXEntity;
import com.merlin204.avalon.epicfight.AvalonFctions;
import com.merlin204.avalon.util.AvalonAnimationUtils;
import com.p1nero.invincible.capability.InvinciblePlayer;
import com.p1nero.invincible.capability.InvinciblePlayerCapabilityProvider;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;

public class SinSummonedSwordPatch<T extends SinSummonedSwordEntity>
extends MobPatch<T> {
    private int tickCount = 0;
    @Nullable
    private LivingEntityPatch<?> ownerPatch;

    public static boolean isHostileMob(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (entity instanceof DoppelgangerEntity) {
            return false;
        }
        return entity instanceof Enemy || entity instanceof Monster || entity.m_6095_() == EntityType.f_20526_ || entity.m_6095_() == EntityType.f_20468_ || entity.m_6095_() == EntityType.f_20509_ || entity.m_6095_() == EntityType.f_20453_;
    }

    public boolean applyStun(StunType stunType, float stunTime) {
        return false;
    }

    public AssetAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return null;
    }

    public Faction getFaction() {
        return AvalonFctions.EMPTY;
    }

    public void onConstructed(T entityIn) {
        Animator animator;
        this.original = entityIn;
        this.armature = this.getArmature();
        this.animator = animator = EpicFightSharedConstants.getAnimator((LivingEntityPatch)this);
        this.initAnimator(animator);
        animator.postInit();
    }

    public void updateMotion(boolean b) {
        if (b) {
            this.currentLivingMotion = LivingMotions.IDLE;
        }
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        ++this.tickCount;
        if (this.tickCount >= 40) {
            ((SinSummonedSwordEntity)this.getOriginal()).m_146870_();
        }
        boolean playAnimation = ((SinSummonedSwordEntity)this.getOriginal()).getPlayAnimation();
        if (!(this.isLogicalClient() && ((SinSummonedSwordEntity)this.original).getDefaultAnimation() == null && !playAnimation || playAnimation)) {
            ((SinSummonedSwordEntity)this.original).setPlayAnimation(true);
            if (this.isLogicalClient()) {
                this.getClientAnimator().playAnimation(((SinSummonedSwordEntity)this.original).getDefaultAnimation(), 0.0f);
            } else {
                this.playAnimationSynchronized((AssetAccessor)((SinSummonedSwordEntity)this.original).getDefaultAnimation(), 0.0f);
            }
            ((SinSummonedSwordEntity)this.original).setShouldRender(true);
        }
    }

    @Nullable
    public LivingEntityPatch<?> getOwnerPatch() {
        if (this.ownerPatch != null) {
            return this.ownerPatch;
        }
        if (((SinSummonedSwordEntity)this.getOriginal()).getOwner() != null) {
            this.ownerPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)((SinSummonedSwordEntity)this.getOriginal()).getOwner(), LivingEntityPatch.class);
            return this.ownerPatch;
        }
        return null;
    }

    public OpenMatrix4f getModelMatrix(float partialTicks) {
        return super.getModelMatrix(partialTicks).scale(((SinSummonedSwordEntity)this.original).m_6134_(), ((SinSummonedSwordEntity)this.original).m_6134_(), ((SinSummonedSwordEntity)this.original).m_6134_());
    }

    public OpenMatrix4f getMatrix(float partialTicks) {
        return super.getMatrix(partialTicks).scale(((SinSummonedSwordEntity)this.original).m_6134_(), ((SinSummonedSwordEntity)this.original).m_6134_(), ((SinSummonedSwordEntity)this.original).m_6134_());
    }

    public Armature getArmature() {
        return ((SinSummonedSwordEntity)this.original).getArmature();
    }

    public LivingEntity target() {
        if (this.getOwnerPatch().getTarget() != null) {
            return this.getOwnerPatch().getTarget();
        }
        if (this.getTarget() != null) {
            return this.getTarget();
        }
        Level level = ((SinSummonedSwordEntity)this.getOriginal()).m_9236_();
        double range = 16.0;
        List nearbyEntities = level.m_6249_(this.getOwnerPatch().getOriginal(), ((LivingEntity)this.getOwnerPatch().getOriginal()).m_20191_().m_82400_(range), entity -> SinSummonedSwordPatch.isHostileMob(entity) && entity != this.getOwnerPatch().getOriginal() && !(entity instanceof DoppelgangerEntity));
        Entity nearestTarget = null;
        double minDistance = Double.MAX_VALUE;
        Entity owner = this.getOwnerPatch().getOriginal();
        for (Entity entity2 : nearbyEntities) {
            double distance = owner.m_20280_(entity2);
            if (level.m_45547_(new ClipContext(owner.m_20299_(1.0f), entity2.m_20299_(1.0f), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, owner)).m_6662_() != HitResult.Type.MISS || !(distance < minDistance)) continue;
            minDistance = distance;
            nearestTarget = entity2;
        }
        if (nearestTarget instanceof LivingEntity) {
            return (LivingEntity)nearestTarget;
        }
        return null;
    }

    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTick) {
        AvalonAnimationUtils.joinRotationInPose((Pose)pose, (LivingEntityPatch)this, (String)"Root", (float)(-((SinSummonedSwordEntity)this.original).getSyncXrot()), (float)0.0f, (float)0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        if (this.getOwnerPatch() != null && this.shouldUseOwnerAttack()) {
            SinSummonedSwordEntity sinSummonedSwordEntity;
            ServerPlayerPatch ownerPatch = (ServerPlayerPatch)this.getOwnerPatch();
            if (((SinSummonedSwordEntity)this.original).getOwner() != null && target == ((SinSummonedSwordEntity)this.original).getOwner()) {
                return AttackResult.missed((float)0.0f);
            }
            if (target instanceof SinSummonedSwordEntity && (sinSummonedSwordEntity = (SinSummonedSwordEntity)target).getOwner() != null && sinSummonedSwordEntity.getOwner() == ((SinSummonedSwordEntity)this.original).getOwner()) {
                return AttackResult.missed((float)0.0f);
            }
            boolean originalNotCharge = false;
            Optional invinciblePlayerOpt = ((ServerPlayer)ownerPatch.getOriginal()).getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).resolve();
            if (invinciblePlayerOpt.isPresent()) {
                InvinciblePlayer invinciblePlayer = (InvinciblePlayer)invinciblePlayerOpt.get();
                originalNotCharge = invinciblePlayer.isNotCharge();
                invinciblePlayer.setNotCharge(true);
            }
            try {
                AttackResult attackResult = this.getOwnerPatch().attack(damageSource, target, hand);
                return attackResult;
            }
            finally {
                if (invinciblePlayerOpt.isPresent()) {
                    ((InvinciblePlayer)invinciblePlayerOpt.get()).setNotCharge(originalNotCharge);
                }
            }
        }
        return super.attack(damageSource, target, hand);
    }

    public boolean shouldUseOwnerAttack() {
        return true;
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        return (SoundEvent)EFNSounds.NOSOUND.get();
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        return (SoundEvent)EFNSounds.NOSOUND.get();
    }

    protected void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, ((SinSummonedSwordEntity)this.original).getIdleAnimation());
    }

    @Nullable
    public EpicFightDamageSource getEpicFightDamageSource() {
        if (this.getOwnerPatch() != null) {
            return this.getOwnerPatch().getEpicFightDamageSource();
        }
        return super.getEpicFightDamageSource();
    }

    public EpicFightDamageSource getDamageSource(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, InteractionHand hand) {
        if (this.getOwnerPatch() != null) {
            return this.getOwnerPatch().getDamageSource(animation, hand);
        }
        return super.getDamageSource(animation, hand);
    }

    public boolean isTargetInvulnerable(Entity entity) {
        if (entity.equals((Object)((SinSummonedSwordEntity)this.getOriginal()).getOwner())) {
            return true;
        }
        if (entity instanceof VFXEntity) {
            VFXEntity artifactSpiritEntity = (VFXEntity)entity;
            if (this.getOwnerPatch() != null) {
                return ((LivingEntity)this.getOwnerPatch().getOriginal()).equals((Object)artifactSpiritEntity.getOwner());
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean flashTargetIndicator(LocalPlayerPatch playerPatch) {
        return false;
    }
}

