/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.entity.effect;

import com.hm.efn.entity.EFNEntity;
import com.hm.efn.gameasset.EFNAnimations;
import com.hm.efn.gameasset.EFNWeaponCategories;
import com.hm.efn.registries.EFNMobEffectRegistry;
import com.hm.efn.util.CullableUtil;
import com.merlin204.avalon.entity.vfx.VFXEntity;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class SummonedSwordEntity_In
extends VFXEntity {
    private LivingEntity owner;
    private LivingEntity target;
    private Vec3 offset;
    private boolean effectsApplied = false;

    public SummonedSwordEntity_In(LivingEntity owner, LivingEntity target, float scale, Vec3 offset) {
        super((EntityType)EFNEntity.SUMMONED_SWORD_IN.get(), owner, scale);
        this.owner = owner;
        this.target = target;
        this.f_19811_ = true;
        this.m_20331_(true);
        this.offset = offset;
        this.f_19794_ = true;
        this.m_20242_(true);
    }

    public SummonedSwordEntity_In(EntityType<? extends VFXEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
        this.f_19811_ = true;
        this.m_20331_(true);
        this.m_20242_(true);
    }

    public static boolean isHoldingYamato(Player player) {
        if (player == null) {
            return false;
        }
        return Stream.of(player.m_21205_(), player.m_21206_()).map(EpicFightCapabilities::getItemStackCapability).filter(Objects::nonNull).anyMatch(cap -> cap.getWeaponCategory() == EFNWeaponCategories.EFN_YAMATO);
    }

    public static void summonAtTargetWaist(ServerPlayerPatch ownerPatch, LivingEntity target, Vec3 offset, float scale) {
        if (target == null || !target.m_6084_()) {
            return;
        }
        LivingEntity owner = (LivingEntity)ownerPatch.getOriginal();
        ServerLevel level = (ServerLevel)owner.m_9236_();
        Vec3 waistPos = target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.7, 0.0);
        Vec3 spawnPos = waistPos.m_82549_(offset);
        SummonedSwordEntity_In sword = new SummonedSwordEntity_In(owner, target, scale, offset);
        sword.m_146884_(spawnPos);
        sword.m_146922_(target.m_146908_());
        sword.m_146926_(0.0f);
        level.m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
        level.m_7967_((Entity)sword);
    }

    public void m_8119_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8119_();
        CullableUtil.setAlwaysVisible((Entity)this);
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!this.effectsApplied && this.owner != null && this.owner.m_6084_()) {
            this.applyEffects();
            this.effectsApplied = true;
        }
        if ((livingEntity = this.owner) instanceof Player && !SummonedSwordEntity_In.isHoldingYamato(player = (Player)livingEntity)) {
            this.m_146870_();
            return;
        }
        if (this.owner == null || !this.owner.m_6084_()) {
            this.m_146870_();
            this.removeEffects();
            return;
        }
        this.moveToOwnerTarget();
    }

    private void applyEffects() {
        if (this.owner != null && !this.owner.m_9236_().m_5776_()) {
            MobEffectInstance yamato = new MobEffectInstance((MobEffect)EFNMobEffectRegistry.YAMATO.get(), 300, 1, false, false, false);
            this.owner.m_7292_(yamato);
        }
    }

    private void removeEffects() {
        if (this.owner != null && !this.owner.m_9236_().m_5776_() && this.effectsApplied) {
            this.owner.m_21195_((MobEffect)EFNMobEffectRegistry.YAMATO.get());
            this.effectsApplied = false;
        }
    }

    protected void moveToOwnerTarget() {
        if (this.getOwnerPatch() == null) {
            this.m_146870_();
            return;
        }
        LivingEntity target = this.getOwnerPatch().getTarget();
        if (target == null || !target.m_6084_()) {
            this.m_146870_();
            return;
        }
        this.m_146922_(target.f_20883_);
        this.m_5618_(target.f_20883_);
        this.m_5616_(target.f_20883_);
        this.m_146884_(target.m_20182_().m_82520_(0.0, (double)target.m_20206_() * 0.6, 0.0));
    }

    @NotNull
    public AABB m_6921_() {
        return this.m_20191_().m_82400_(100.0);
    }

    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getIdleAnimation() {
        return EFNAnimations.SUMMONED_SWORD_CIRCLE;
    }

    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getDefaultAnimation() {
        return EFNAnimations.SUMMONED_SWORD_IN;
    }

    @Nullable
    public Armature getArmature() {
        return Armatures.ArmatureAccessor.create((String)"efn", (String)"entity/effect/summoned_sword_circle", Armature::new).get();
    }

    @Nullable
    public AssetAccessor<? extends SkinnedMesh> getMesh() {
        return Meshes.MeshAccessor.create((String)"efn", (String)"entity/effect/summoned_sword_circle", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    }

    @Nullable
    public ResourceLocation getTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"efn", (String)"textures/entity/summoned_sword.png");
    }

    @Nullable
    public ResourceLocation getLitTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"efn", (String)"textures/entity/summoned_sword.png");
    }
}

