/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.entity.effect;

import com.hm.efn.entity.doppelganger.DoppelgangerEntity;
import com.hm.efn.entity.effect.SummonedSwordEntity;
import com.merlin204.avalon.entity.vfx.VFXEntityPatch;
import com.merlin204.avalon.epicfight.AvalonFctions;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.damagesource.StunType;

public class SummonedSwordPatch
extends VFXEntityPatch<SummonedSwordEntity> {
    private int tickCount = 0;

    private static boolean isHostileMob(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (entity instanceof DoppelgangerEntity) {
            return false;
        }
        return entity instanceof Enemy || entity instanceof Monster || entity.m_6095_() == EntityType.f_20526_ || entity.m_6095_() == EntityType.f_20468_ || entity.m_6095_() == EntityType.f_20509_ || entity.m_6095_() == EntityType.f_20453_;
    }

    public boolean applyStun(StunType stunType, float stunTime) {
        return false;
    }

    public Faction getFaction() {
        return AvalonFctions.EMPTY;
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        ++this.tickCount;
        if (this.tickCount >= 1 && this.tickCount <= 4) {
            float sacle = 0.3f;
            if (this.target() != null) {
                this.setAttakTargetSync(this.target());
                Vec3 targetpos = new Vec3(this.target().m_20185_(), this.target().m_20188_() - 0.2, this.target().m_20189_());
                Vec3 vector = targetpos.m_82546_(((SummonedSwordEntity)this.getOriginal()).f_19825_).m_82490_((double)sacle);
                ((SummonedSwordEntity)this.getOriginal()).m_20256_(((SummonedSwordEntity)this.getOriginal()).m_20184_().m_82549_(vector));
                return;
            }
            Vec3 lookAngle = ((SummonedSwordEntity)this.getOriginal()).m_20154_();
            Vec3 acceleration = lookAngle.m_82490_((double)(sacle * 8.25f));
            ((SummonedSwordEntity)this.getOriginal()).m_20256_(((SummonedSwordEntity)this.getOriginal()).m_20184_().m_82549_(acceleration));
        }
    }

    public LivingEntity target() {
        if (this.getOwnerPatch().getTarget() != null) {
            return this.getOwnerPatch().getTarget();
        }
        if (this.getTarget() != null) {
            return this.getTarget();
        }
        Level level = ((SummonedSwordEntity)this.getOriginal()).m_9236_();
        double range = 16.0;
        List nearbyEntities = level.m_6249_(this.getOwnerPatch().getOriginal(), ((LivingEntity)this.getOwnerPatch().getOriginal()).m_20191_().m_82400_(range), entity -> SummonedSwordPatch.isHostileMob(entity) && entity != this.getOwnerPatch().getOriginal() && !(entity instanceof DoppelgangerEntity));
        Entity nearestTarget = null;
        double minDistance = Double.MAX_VALUE;
        Entity owner = this.getOwnerPatch().getOriginal();
        for (Entity entity2 : nearbyEntities) {
            double distance = owner.m_20280_(entity2);
            if (level.m_45547_(new ClipContext(owner.m_20299_(1.0f), entity2.m_20299_(1.0f), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, owner)).m_6662_() != HitResult.Type.MISS || !(distance < minDistance)) continue;
            minDistance = distance;
            nearestTarget = entity2;
        }
        if (nearestTarget instanceof LivingEntity) {
            return (LivingEntity)nearestTarget;
        }
        return null;
    }
}

