/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.entity.skill;

import com.hm.efn.entity.EFNEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SoulHuntOrb
extends Entity {
    private Player dest;
    private Vec3 randVec;
    private Vec3 spiralOffset;
    private double spiralAngle;
    private double spiralRadius;
    private double spiralSpeed;
    private Vec3[] followerOffsets;
    private double[] followerAngles;
    private int[] followerDelays;
    private boolean soundPlayed = false;

    public SoulHuntOrb(EntityType<?> type, Level level) {
        super(type, level);
        this.initFollowerParticles();
    }

    public SoulHuntOrb(Player dest, double x, double y, double z) {
        this((EntityType)EFNEntity.SOUL_HUNT_ORB.get(), dest.m_9236_());
        this.m_6034_(x, y, z);
        this.dest = dest;
        Vec3 toPlayer = this.dest.m_20182_().m_82520_(0.0, (double)this.dest.m_20206_() * 0.5, 0.0).m_82546_(this.m_20182_());
        Vec3 perpendicular = toPlayer.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        if (perpendicular.m_82556_() < 0.1) {
            perpendicular = toPlayer.m_82537_(new Vec3(1.0, 0.0, 0.0)).m_82541_();
        }
        double randomAngle = this.f_19796_.m_188500_() * Math.PI * 2.0;
        double randomDistance = this.f_19796_.m_188500_() * 2.0 + 1.0;
        this.randVec = perpendicular.m_82490_(Math.cos(randomAngle) * randomDistance).m_82549_(new Vec3(0.0, Math.sin(randomAngle) * randomDistance, 0.0)).m_82541_();
        this.spiralOffset = Vec3.f_82478_;
        this.spiralAngle = this.f_19796_.m_188500_() * Math.PI * 2.0;
        this.spiralRadius = this.f_19796_.m_188500_() * 0.8 + 0.3;
        this.spiralSpeed = (this.f_19796_.m_188500_() * 0.3 + 0.2) * (double)(this.f_19796_.m_188499_() ? 1 : -1);
        this.initFollowerParticles();
    }

    private void initFollowerParticles() {
        this.followerOffsets = new Vec3[2];
        this.followerAngles = new double[2];
        this.followerDelays = new int[2];
        for (int i = 0; i < 2; ++i) {
            this.followerOffsets[i] = new Vec3((this.f_19796_.m_188500_() - 0.5) * 2.0, (this.f_19796_.m_188500_() - 0.5) * 2.0, (this.f_19796_.m_188500_() - 0.5) * 2.0);
            this.followerAngles[i] = this.f_19796_.m_188500_() * Math.PI * 2.0;
            this.followerDelays[i] = this.f_19796_.m_188503_(10) + 5;
        }
    }

    public void m_8119_() {
        this.f_19794_ = true;
        if (!this.m_9236_().m_5776_()) {
            if (this.dest == null || !this.dest.m_6084_()) {
                this.m_146870_();
                return;
            }
            Vec3 destCenter = this.dest.m_20182_().m_82520_(0.0, (double)this.dest.m_20206_() * 0.5, 0.0);
            double progress = Math.min(1.0, (double)this.f_19797_ / 30.0);
            double easeProgress = 1.0 - Math.pow(1.0 - progress, 2.0);
            Vec3 toPlayer = destCenter.m_82546_(this.m_20182_());
            double distanceToPlayer = toPlayer.m_82553_();
            if (distanceToPlayer < 0.75) {
                if (!this.soundPlayed) {
                    this.m_9236_().m_6263_(null, this.dest.m_20185_(), this.dest.m_20186_(), this.dest.m_20189_(), SoundEvents.f_215766_, SoundSource.AMBIENT, 1.6f, 1.0f);
                    this.soundPlayed = true;
                }
                this.m_146870_();
                return;
            }
            if (this.f_19797_ > 60) {
                this.m_146870_();
                return;
            }
            Vec3 directMove = toPlayer.m_82541_().m_82490_(easeProgress * 0.35);
            this.spiralAngle += this.spiralSpeed;
            double spiralX = Math.cos(this.spiralAngle) * this.spiralRadius * (1.0 - easeProgress);
            double spiralZ = Math.sin(this.spiralAngle) * this.spiralRadius * (1.0 - easeProgress);
            this.spiralOffset = new Vec3(spiralX, Math.sin(this.spiralAngle * 0.7) * this.spiralRadius * 0.5 * (1.0 - easeProgress), spiralZ);
            double randomStrength = (1.0 - easeProgress) * 0.15;
            Vec3 randomOffset = new Vec3((this.f_19796_.m_188500_() - 0.5) * randomStrength, (this.f_19796_.m_188500_() - 0.5) * randomStrength, (this.f_19796_.m_188500_() - 0.5) * randomStrength);
            Vec3 finalMove = directMove.m_82549_(this.spiralOffset).m_82549_(randomOffset);
            this.m_6478_(MoverType.SELF, finalMove);
        } else {
            this.renderParticles();
        }
    }

    private void renderParticles() {
        Vec3 currentPos = this.m_20182_();
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235898_, currentPos.f_82479_, currentPos.f_82480_, currentPos.f_82481_, (this.f_19796_.m_188500_() - 0.5) * 0.02, (this.f_19796_.m_188500_() - 0.5) * 0.02, (this.f_19796_.m_188500_() - 0.5) * 0.02);
        for (int i = 0; i < 2; ++i) {
            if (this.f_19797_ <= this.followerDelays[i]) continue;
            int n = i;
            this.followerAngles[n] = this.followerAngles[n] + (this.f_19796_.m_188500_() * 0.3 + 0.1);
            double orbitRadius = 0.5 + this.f_19796_.m_188500_() * 0.3;
            Vec3 followerPos = currentPos.m_82520_(Math.cos(this.followerAngles[i]) * orbitRadius, Math.sin(this.followerAngles[i] * 1.5) * orbitRadius * 0.7, Math.sin(this.followerAngles[i]) * orbitRadius);
            followerPos = followerPos.m_82520_((this.f_19796_.m_188500_() - 0.5) * 0.2, (this.f_19796_.m_188500_() - 0.5) * 0.2, (this.f_19796_.m_188500_() - 0.5) * 0.2);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, followerPos.f_82479_, followerPos.f_82480_, followerPos.f_82481_, (this.f_19796_.m_188500_() - 0.5) * 0.05, (this.f_19796_.m_188500_() - 0.5) * 0.05, (this.f_19796_.m_188500_() - 0.5) * 0.05);
            if (this.f_19796_.m_188503_(8) != 0) continue;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, followerPos.f_82479_, followerPos.f_82480_, followerPos.f_82481_, (this.f_19796_.m_188500_() - 0.5) * 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.1);
        }
        if (this.f_19797_ % 4 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, currentPos.f_82479_, currentPos.f_82480_, currentPos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public void m_7378_(@NotNull CompoundTag tag) {
    }

    public void m_7380_(@NotNull CompoundTag tag) {
    }

    protected void m_8097_() {
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

