/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.gameasset.animations;

import com.hm.efn.animations.EFNGuardAnimation;
import com.hm.efn.gameasset.EFNAnimations;
import com.hm.efn.util.EffectEntityInvoker;
import com.hm.efn.util.ParticleEffectInvoker;
import com.merlin204.avalon.epicfight.animations.AvalonAttackAnimation;
import com.merlin204.avalon.util.AvalonAnimationUtils;
import com.merlin204.avalon.util.AvalonEventUtils;
import java.util.List;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.collider.OBBCollider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.TimePairList;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.ExtraDamageInstance;
import yesman.epicfight.world.damagesource.StunType;

@Mod.EventBusSubscriber(modid="efn", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EFNSkillAnimations {
    public static final Collider STOMP_COLL = new OBBCollider(10.0, 4.5, 10.0, 0.0, 3.2, 0.0);
    public static final Collider EXECUTION_COLL = new OBBCollider(1.6, 2.0, 2.5, 0.0, 0.0, -1.0);
    public static final AnimationEvent.Event VEX_HUNT = (entitypatch, self, params) -> {
        if (entitypatch == null || entitypatch.getOriginal() == null) {
            return;
        }
        if (!entitypatch.isLogicalClient()) {
            Entity original = entitypatch.getOriginal();
            if (!(original instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)original;
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            Level level = player.m_9236_();
            AABB searchArea = new AABB(player.m_20185_() - 10.0, player.m_20186_() - 10.0, player.m_20189_() - 10.0, player.m_20185_() + 10.0, player.m_20186_() + 10.0, player.m_20189_() + 10.0);
            List vexes = level.m_45976_(Vex.class, searchArea);
            for (Vex vex : vexes) {
                if (!vex.m_6084_()) continue;
                float maxHealth = vex.m_21233_();
                float damage = maxHealth * 0.5f;
                DamageSource damageSource = level.m_269111_().m_269075_(player);
                vex.m_6469_(damageSource, damage);
                MobEffectInstance slowness = new MobEffectInstance(MobEffects.f_19597_, 1000, 255, false, false, false);
                vex.m_7292_(slowness);
                vex.m_20242_(false);
                vex.m_21557_(true);
                Vec3 lookVec = player.m_20154_();
                Vec3 frontPos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_() * 0.2, 0.0).m_82549_(lookVec.m_82490_(1.0));
                vex.m_6034_(frontPos.f_82479_, frontPos.f_82480_, frontPos.f_82481_);
                vex.m_20334_(0.0, -2.0, 0.0);
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123815_, vex.m_20185_(), vex.m_20186_(), vex.m_20189_(), 10, 0.5, 0.5, 0.5, 0.1);
            }
        }
    };
    public static AnimationManager.AnimationAccessor<AvalonAttackAnimation> STOMP;
    public static AnimationManager.AnimationAccessor<AvalonAttackAnimation> EXECUTION;
    public static AnimationManager.AnimationAccessor<EFNGuardAnimation> EFN_GUARD_ACTIVE_HIT1;
    public static AnimationManager.AnimationAccessor<EFNGuardAnimation> EFN_GUARD_ACTIVE_HIT2;
    public static AnimationManager.AnimationAccessor<EFNGuardAnimation> EFN_GUARD_ACTIVE_HIT3;

    public static void build(AnimationManager.AnimationBuilder builder) {
        EFN_GUARD_ACTIVE_HIT1 = builder.nextAccessor("biped/nf_skill/biped_flashblock1", accessor -> (EFNGuardAnimation)new EFNGuardAnimation(0.07f, 0.35f, (AnimationManager.AnimationAccessor<? extends EFNGuardAnimation>)accessor, (AssetAccessor<? extends Armature>)Armatures.BIPED).addEvents(new AnimationEvent[]{AvalonEventUtils.simpleCameraShake((int)2, (int)6, (float)4.0f, (float)2.0f, (float)4.0f)}));
        EFN_GUARD_ACTIVE_HIT2 = builder.nextAccessor("biped/nf_skill/biped_flashblock2", accessor -> (EFNGuardAnimation)new EFNGuardAnimation(0.07f, 0.35f, (AnimationManager.AnimationAccessor<? extends EFNGuardAnimation>)accessor, (AssetAccessor<? extends Armature>)Armatures.BIPED).addEvents(new AnimationEvent[]{AvalonEventUtils.simpleCameraShake((int)2, (int)6, (float)4.0f, (float)2.0f, (float)4.0f)}));
        EFN_GUARD_ACTIVE_HIT3 = builder.nextAccessor("biped/nf_skill/biped_flashblock3", accessor -> (EFNGuardAnimation)new EFNGuardAnimation(0.1f, 1.1f, (AnimationManager.AnimationAccessor<? extends EFNGuardAnimation>)accessor, (AssetAccessor<? extends Armature>)Armatures.BIPED).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL, true).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.NO_GRAVITY_TIME, (Object)TimePairList.create((float[])new float[]{0.1f, 0.2f})).addEvents(new AnimationEvent[]{AvalonEventUtils.simpleCameraShake((int)3, (int)11, (float)6.0f, (float)3.0f, (float)6.0f)}));
        EXECUTION = builder.nextAccessor("biped/nf_skill/biped_execute", accessor -> (AvalonAttackAnimation)new AvalonAttackAnimation(0.1f, accessor, (AssetAccessor)Armatures.BIPED, 1.0f, 1.0f, new AvalonAttackAnimation.AvalonPhase[]{AvalonAnimationUtils.createSimplePhase((int)76, (int)85, (int)96, (InteractionHand)InteractionHand.MAIN_HAND, (float)1.5f, (float)1.5f, (Joint)((HumanoidArmature)Armatures.BIPED.get()).rootJoint, (Collider)EXECUTION_COLL)}).addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, (Object)((SoundEvent)EpicFightSounds.WHOOSH_BIG.get())).addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, (Object)((SoundEvent)EpicFightSounds.BLADE_RUSH_FINISHER.get())).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)EpicFightParticles.BLADE_RUSH_SKILL).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER, (Object)ValueModifier.setter((float)10.0f)).addProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION_MODIFIER, (Object)ValueModifier.setter((float)100.0f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.LONG).addProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE, Set.of(ExtraDamageInstance.SWEEPING_EDGE_ENCHANTMENT.create(new float[0]), ExtraDamageInstance.EVISCERATE_LOST_HEALTH.create(new float[]{0.25f}))).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.REACH, (Object)Float.valueOf(0.5f)).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (dynamicAnimation, livingEntityPatch, v, v1, v2) -> 1.0f).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.AFFECT_SPEED, (Object)false).newTimePair(0.0f, 1.5f).addStateRemoveOld(EntityState.ATTACK_RESULT, damageSource -> AttackResult.ResultType.BLOCKED).addEvents(new AnimationEvent[]{ParticleEffectInvoker.createSoulRingEffect(5, 30), EFNSkillAnimations.particleTrail(16, 40, InteractionHand.OFF_HAND, new Vec3(0.0, 0.0, 0.5), new Vec3(0.0, 0.0, 0.5), 1.0f, 2, (ParticleOptions)ParticleTypes.f_123745_, 0.1f), EFNSkillAnimations.particleTrail(16, 40, InteractionHand.OFF_HAND, new Vec3(0.0, 0.0, 0.6), new Vec3(0.0, 0.0, 0.6), 1.0f, 3, (ParticleOptions)ParticleTypes.f_123762_, 0.25f), AnimationEvent.InTimeEvent.create((float)0.05f, (entitypatch, self, params) -> entitypatch.playSound(SoundEvents.f_12554_, 1.3f, 0.0f, 0.0f), (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)0.1f, (entitypatch, self, params) -> ((LivingEntity)entitypatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 13, 10, false, false, false)), (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)0.5f, (entitypatch, self, params) -> entitypatch.playSound(SoundEvents.f_215768_, 1.3f, 0.0f, 0.0f), (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)1.2f, (entitypatch, self, params) -> ((LivingEntity)entitypatch.getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_216964_, 30, 5, false, false, false)), (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)1.2666f, (entitypatch, self, params) -> entitypatch.playSound(SoundEvents.f_215771_, 1.6f, 0.0f, 0.0f), (AnimationEvent.Side)AnimationEvent.Side.SERVER), EffectEntityInvoker.summonSecluded_Skill(70, -1.0, -4.6f, -0.15f, 2.0f, 0.0f), EFNSkillAnimations.createVerticalSonicBoom(74, ((HumanoidArmature)Armatures.BIPED.get()).handL), AvalonEventUtils.simpleCameraShake((int)74, (int)20, (float)8.0f, (float)4.0f, (float)8.0f), ParticleEffectInvoker.simpleGroundSplit(78, 1.0, 0.0, 0.0, 0.0, 3.5f, true)}));
        STOMP = builder.nextAccessor("biped/nf_skill/biped_stomp", accessor -> (AvalonAttackAnimation)new AvalonAttackAnimation(0.1f, accessor, (AssetAccessor)Armatures.BIPED, 1.0f, 1.0f, new AvalonAttackAnimation.AvalonPhase[]{AvalonAnimationUtils.createSimplePhase((int)32, (int)45, (int)60, (InteractionHand)InteractionHand.MAIN_HAND, (float)1.0f, (float)1.0f, (Joint)((HumanoidArmature)Armatures.BIPED.get()).rootJoint, (Collider)STOMP_COLL)}).addProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER, (Object)ValueModifier.setter((float)10.0f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)10.0f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)1.5f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.LONG).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (dynamicAnimation, livingEntityPatch, v, v1, v2) -> 1.0f).addEvents(new AnimationEvent[]{AvalonEventUtils.simpleCameraShake((int)45, (int)15, (float)5.0f, (float)3.0f, (float)5.0f), ParticleEffectInvoker.simpleGroundSplit(45, 1.0, 0.0, 0.0, 0.0, 8.0f, true), ParticleEffectInvoker.createSmokeRingEffect(10, 45), AnimationEvent.InTimeEvent.create((float)0.7f, (AnimationEvent.Event)VEX_HUNT, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)0.75f, (entitypatch, self, params) -> {
            if (!((LivingEntity)entitypatch.getOriginal()).m_9236_().m_5776_()) {
                LivingEntity attacker = (LivingEntity)entitypatch.getOriginal();
                ServerLevel level = (ServerLevel)attacker.m_9236_();
                double centerX = attacker.m_20185_();
                double centerY = attacker.m_20186_();
                double centerZ = attacker.m_20189_();
                double baseRadius = 10.0;
                double maxRadius = 25.0;
                int waveCount = 3;
                int particlesPerWave = 80;
                double speed = 0.4;
                for (int wave = 0; wave < waveCount; ++wave) {
                    double radius = baseRadius + (maxRadius - baseRadius) * (double)wave / (double)(waveCount - 1);
                    for (int i = 0; i < particlesPerWave; ++i) {
                        double angle = Math.PI * 2 * (double)i / (double)particlesPerWave;
                        double randomOffset = 0.3 * (level.f_46441_.m_188500_() - 0.5);
                        double xOffset = radius * Math.cos(angle) + randomOffset;
                        double zOffset = radius * Math.sin(angle) + randomOffset;
                        double motionX = xOffset * speed / radius;
                        double motionZ = zOffset * speed / radius;
                        double yOffset = 0.5 * Math.sin(angle * 2.0 + (double)wave * 0.5);
                        level.m_8767_((ParticleOptions)ParticleTypes.f_123783_, centerX + xOffset, centerY + 0.1 + yOffset, centerZ + zOffset, 1, motionX, 0.05, motionZ, 0.8);
                    }
                }
                level.m_8767_((ParticleOptions)ParticleTypes.f_123746_, centerX, centerY + 0.5, centerZ, 50, 1.5, 0.5, 1.5, 0.7);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123747_, centerX, centerY + 1.0, centerZ, 1, 0.0, 0.0, 0.0, 1.0);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)0.01f, (entitypatch, self, params) -> entitypatch.playSound(SoundEvents.f_12554_, 1.0f, 1.0f, 1.0f), (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)0.75f, (entitypatch, self, params) -> entitypatch.playSound(SoundEvents.f_11913_, 1.35f, 1.0f, 1.0f), (AnimationEvent.Side)AnimationEvent.Side.SERVER), AnimationEvent.InTimeEvent.create((float)0.75f, (entitypatch, self, params) -> entitypatch.playSound(SoundEvents.f_12557_, 1.35f, 1.0f, 1.0f), (AnimationEvent.Side)AnimationEvent.Side.SERVER)}).newTimePair(0.0f, 2.1474836E9f).addStateRemoveOld(EntityState.ATTACK_RESULT, EFNAnimations.INVINCIBLE_SOURCE_VALIDATOR));
    }

    public static AnimationEvent.InPeriodEvent particleTrail(int startFrame, int endFrame, InteractionHand hand, Vec3 startOffset, Vec3 endOffset, float timeInterpolation, int particleCount, ParticleOptions particleOptions, float random) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        Joint joint = null;
        switch (hand) {
            case MAIN_HAND: {
                joint = ((HumanoidArmature)Armatures.BIPED.get()).handR;
                break;
            }
            case OFF_HAND: {
                joint = ((HumanoidArmature)Armatures.BIPED.get()).handL;
            }
        }
        Joint finalJoint = joint;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            AnimationPlayer player = entityPatch.getAnimator().getPlayerFor(null);
            float prevElapsedTime = player.getPrevElapsedTime();
            float elapsedTime = player.getElapsedTime();
            float step = (elapsedTime - prevElapsedTime) / timeInterpolation;
            Vec3 trailStartOffset = startOffset;
            Vec3 trailEndOffset = endOffset;
            Vec3f trailDirection = new Vec3f((float)(trailEndOffset.f_82479_ - trailStartOffset.f_82479_), (float)(trailEndOffset.f_82480_ - trailStartOffset.f_82480_), (float)(trailEndOffset.f_82481_ - trailStartOffset.f_82481_));
            for (float f = prevElapsedTime; f <= elapsedTime; f += step) {
                for (int i = 0; i <= particleCount; ++i) {
                    float ratio = (float)i / (float)particleCount;
                    Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
                    double randX = (Math.random() - 0.5) * (double)random;
                    double randY = (Math.random() - 0.5) * (double)random;
                    double randZ = (Math.random() - 0.5) * (double)random;
                    Vec3 worldPos = AvalonAnimationUtils.getJointWorldRawPos((LivingEntityPatch)entityPatch, (Joint)finalJoint, (float)(f + step), (Vec3f)pointOffset);
                    if (!((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) continue;
                    ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_(particleOptions, worldPos.f_82479_ + randX, worldPos.f_82480_ + randY, worldPos.f_82481_ + randZ, 0.0, 0.0, 0.0);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InTimeEvent createVerticalSonicBoom(int startFrame, Joint startJoint) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            if (!((LivingEntity)entityPatch.getOriginal()).m_9236_().m_5776_()) {
                ServerLevel level = (ServerLevel)((LivingEntity)entityPatch.getOriginal()).m_9236_();
                LivingEntity caster = (LivingEntity)entityPatch.getOriginal();
                Vec3 startPos = AvalonAnimationUtils.getJointWorldPos((LivingEntityPatch)entityPatch, (Joint)startJoint);
                Vec3 horizontalLook = caster.m_20154_();
                horizontalLook = new Vec3(horizontalLook.f_82479_, 0.0, horizontalLook.f_82481_).m_82541_();
                Vec3 forwardOffset = horizontalLook.m_82490_(0.65);
                Vec3 finalStartPos = startPos.m_82549_(forwardOffset).m_82520_(0.0, 0.0, 0.0);
                EFNSkillAnimations.generateSonicExplosion(level, entityPatch, finalStartPos);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    private static void generateSonicExplosion(ServerLevel level, LivingEntityPatch<?> entityPatch, Vec3 center) {
        EFNSkillAnimations.generateSonicCore(level, center);
        EFNSkillAnimations.generateSculkSoulBurst(level, entityPatch, center);
        EFNSkillAnimations.generateFireAndFlash(level, entityPatch, center);
        EFNSkillAnimations.generateSmokeEffect(level, entityPatch, center);
    }

    private static void generateSonicCore(ServerLevel level, Vec3 center) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_235902_, center.f_82479_, center.f_82480_, center.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123747_, center.f_82479_, center.f_82480_, center.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, center.f_82479_, center.f_82480_, center.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private static void generateSculkSoulBurst(ServerLevel level, LivingEntityPatch<?> entityPatch, Vec3 center) {
        OpenMatrix4f rotation;
        Vec3f direction;
        double z;
        double y;
        double x;
        double phi;
        double theta;
        int i;
        int n = 120;
        double r = 0.8;
        double t = 0.01;
        for (i = 0; i < n; ++i) {
            theta = Math.PI * 2 * Math.random();
            phi = (Math.random() - 0.5) * Math.PI * t / r;
            x = r * Math.cos(phi) * Math.cos(theta);
            y = r * Math.cos(phi) * Math.sin(theta);
            z = r * Math.sin(phi);
            direction = new Vec3f((float)x, (float)y, (float)z);
            rotation = new OpenMatrix4f().rotate((float)(-Math.toRadians(entityPatch.getYRot())), new Vec3f(0.0f, 1.0f, 0.0f));
            OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
            level.m_8767_((ParticleOptions)ParticleTypes.f_235898_, center.f_82479_ + (double)(direction.x * 3.0f), center.f_82480_ + (double)(direction.y * 3.0f), center.f_82481_ + (double)(direction.z * 3.0f), 1, (double)(direction.x * 2.0f), (double)(direction.y * 2.0f), (double)(direction.z * 2.0f), 0.15);
        }
        n = 80;
        r = 1.2;
        for (i = 0; i < n; ++i) {
            theta = Math.PI * 2 * Math.random();
            phi = (Math.random() - 0.5) * Math.PI * t / r;
            x = r * Math.cos(phi) * Math.cos(theta);
            y = r * Math.cos(phi) * Math.sin(theta);
            z = r * Math.sin(phi);
            direction = new Vec3f((float)x, (float)y, (float)z);
            rotation = new OpenMatrix4f().rotate((float)(-Math.toRadians(entityPatch.getYRot() + 45.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
            OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
            level.m_8767_((ParticleOptions)ParticleTypes.f_235898_, center.f_82479_ + (double)(direction.x * 4.0f), center.f_82480_ + (double)(direction.y * 4.0f), center.f_82481_ + (double)(direction.z * 4.0f), 1, (double)(direction.x * 1.5f), (double)(direction.y * 1.5f), (double)(direction.z * 1.5f), 0.2);
        }
    }

    private static void generateFireAndFlash(ServerLevel level, LivingEntityPatch<?> entityPatch, Vec3 center) {
        OpenMatrix4f rotation;
        Vec3f direction;
        float randomVelocity;
        double z;
        double y;
        double x;
        double phi;
        double theta;
        int i;
        int n = 80;
        double r = 0.6;
        for (i = 0; i < n; ++i) {
            theta = Math.PI * 2 * Math.random();
            phi = Math.acos(Math.random());
            x = r * Math.sin(phi) * Math.cos(theta);
            y = r * Math.sin(phi) * Math.sin(theta);
            z = r * Math.cos(phi);
            randomVelocity = (float)Math.random();
            direction = new Vec3f((float)x * randomVelocity * 1.5f, (float)y * randomVelocity * 1.5f, (float)z * randomVelocity * 3.0f);
            rotation = new OpenMatrix4f().rotate((float)(-Math.toRadians(entityPatch.getYRot())), new Vec3f(0.0f, 1.0f, 0.0f));
            OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, center.f_82479_, center.f_82480_, center.f_82481_, 1, (double)direction.x, (double)direction.y, (double)direction.z, 0.08);
        }
        n = 50;
        for (i = 0; i < n; ++i) {
            theta = Math.PI * 2 * Math.random();
            phi = Math.acos(Math.random());
            x = r * Math.sin(phi) * Math.cos(theta);
            y = r * Math.sin(phi) * Math.sin(theta);
            z = r * Math.cos(phi);
            randomVelocity = (float)Math.random();
            direction = new Vec3f((float)x * randomVelocity * 1.2f, (float)y * randomVelocity * 1.2f, (float)z * randomVelocity * 2.0f);
            rotation = new OpenMatrix4f().rotate((float)(-Math.toRadians(entityPatch.getYRot())), new Vec3f(0.0f, 1.0f, 0.0f));
            OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
        }
    }

    private static void generateSmokeEffect(ServerLevel level, LivingEntityPatch<?> entityPatch, Vec3 center) {
        double z;
        double y;
        double x;
        double phi;
        double theta;
        int i;
        int n = 60;
        double r = 0.8;
        for (i = 0; i < n; ++i) {
            theta = Math.PI * 2 * Math.random();
            phi = Math.acos(Math.random());
            x = r * Math.sin(phi) * Math.cos(theta);
            y = r * Math.sin(phi) * Math.sin(theta);
            z = r * Math.cos(phi);
            float randomVelocity = (float)Math.random();
            Vec3f direction = new Vec3f((float)x * randomVelocity * 1.2f, (float)y * randomVelocity * 1.2f, (float)z * randomVelocity * 2.0f);
            OpenMatrix4f rotation = new OpenMatrix4f().rotate((float)(-Math.toRadians(entityPatch.getYRot())), new Vec3f(0.0f, 1.0f, 0.0f));
            OpenMatrix4f.transform3v((OpenMatrix4f)rotation, (Vec3f)direction, (Vec3f)direction);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, center.f_82479_, center.f_82480_, center.f_82481_, 1, (double)direction.x, (double)direction.y, (double)direction.z, 0.15);
        }
        n = 30;
        for (i = 0; i < n; ++i) {
            theta = Math.PI * 2 * Math.random();
            phi = Math.acos(Math.random());
            x = r * Math.sin(phi) * Math.cos(theta);
            y = r * Math.sin(phi) * Math.sin(theta);
            z = r * Math.cos(phi);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123746_, center.f_82479_ + x, center.f_82480_ + y, center.f_82481_ + z, 1, x * 0.4, y * 0.4, z * 0.4, 0.08);
        }
    }
}

