/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.item.custom;

import com.hm.efn.client.model.Modelruinfighter;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public abstract class RuinfighterItem
extends ArmorItem {
    private static final ArmorMaterial RUINFIGHTER_MATERIAL = new ArmorMaterial(){

        public int m_266425_(ArmorItem.Type type) {
            return -1;
        }

        public int m_7366_(ArmorItem.Type type) {
            return (new int[]{5, 9, 11, 5})[type.m_266308_().m_20749_()];
        }

        public int m_6646_() {
            return 50;
        }

        @NotNull
        public SoundEvent m_7344_() {
            return SoundEvents.f_11679_;
        }

        @NotNull
        public Ingredient m_6230_() {
            return Ingredient.m_151265_();
        }

        @NotNull
        public String m_6082_() {
            return "ruinfighter";
        }

        public float m_6651_() {
            return 4.5f;
        }

        public float m_6649_() {
            return 0.2f;
        }
    };

    public RuinfighterItem(ArmorItem.Type type, Item.Properties properties) {
        super(RUINFIGHTER_MATERIAL, type, properties.m_41497_(Rarity.EPIC).m_41486_());
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public static class Boots
    extends RuinfighterItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("left_leg", new Modelruinfighter<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelruinfighter.LAYER_LOCATION)).Boots_L, "right_leg", new Modelruinfighter<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelruinfighter.LAYER_LOCATION)).Boots_R, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "efn:textures/armor/ruinfighter.png";
        }

        public boolean m_8120_(@NotNull ItemStack stack) {
            return true;
        }

        public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
            return enchantment.f_44672_ == EnchantmentCategory.ARMOR_FEET || enchantment.f_44672_ == EnchantmentCategory.ARMOR || enchantment.f_44672_ == EnchantmentCategory.VANISHABLE || enchantment.f_44672_ == EnchantmentCategory.WEARABLE || enchantment.f_44672_ == EnchantmentCategory.BREAKABLE;
        }
    }

    public static class Leggings
    extends RuinfighterItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "efn:textures/armor/ruinfighter_mesh.png";
        }

        public boolean m_8120_(@NotNull ItemStack stack) {
            return true;
        }

        public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
            return enchantment.f_44672_ == EnchantmentCategory.ARMOR_LEGS || enchantment.f_44672_ == EnchantmentCategory.ARMOR || enchantment.f_44672_ == EnchantmentCategory.VANISHABLE || enchantment.f_44672_ == EnchantmentCategory.WEARABLE || enchantment.f_44672_ == EnchantmentCategory.BREAKABLE;
        }
    }

    public static class Chestplate
    extends RuinfighterItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "efn:textures/armor/ruinfighter_mesh.png";
        }

        public boolean m_8120_(@NotNull ItemStack stack) {
            return true;
        }

        public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
            return enchantment.f_44672_ == EnchantmentCategory.ARMOR_CHEST || enchantment.f_44672_ == EnchantmentCategory.ARMOR || enchantment.f_44672_ == EnchantmentCategory.VANISHABLE || enchantment.f_44672_ == EnchantmentCategory.WEARABLE || enchantment.f_44672_ == EnchantmentCategory.BREAKABLE;
        }
    }

    public static class Helmet
    extends RuinfighterItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("head", new Modelruinfighter<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelruinfighter.LAYER_LOCATION)).Helmet, "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "efn:textures/armor/ruinfighter.png";
        }

        public boolean m_8120_(@NotNull ItemStack stack) {
            return true;
        }

        public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
            return enchantment.f_44672_ == EnchantmentCategory.ARMOR_HEAD || enchantment.f_44672_ == EnchantmentCategory.ARMOR || enchantment.f_44672_ == EnchantmentCategory.VANISHABLE || enchantment.f_44672_ == EnchantmentCategory.WEARABLE || enchantment.f_44672_ == EnchantmentCategory.BREAKABLE;
        }
    }
}

