/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.item.custom;

import com.hm.efn.EFNConfig;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.world.item.WeaponItem;

@Mod.EventBusSubscriber(modid="efn", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class YamatoItem
extends WeaponItem {
    private static final String KILL_COUNT_KEY = "KillCount";
    private static final String TOTAL_DAMAGE_KEY = "TotalDamage";
    private static final String REWARD_GIVEN_KEY = "RewardGiven";

    public YamatoItem(Tier tier, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, properties);
    }

    public static int getKillCount(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128451_(KILL_COUNT_KEY);
    }

    public static float getTotalDamage(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128457_(TOTAL_DAMAGE_KEY);
    }

    private static boolean isRewardGiven(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128471_(REWARD_GIVEN_KEY);
    }

    private static void setRewardGiven(ItemStack stack, boolean given) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(REWARD_GIVEN_KEY, given);
    }

    private static void incrementKillCount(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int currentCount = tag.m_128451_(KILL_COUNT_KEY);
        tag.m_128405_(KILL_COUNT_KEY, currentCount + 1);
    }

    private static void addTotalDamage(ItemStack stack, float damage) {
        CompoundTag tag = stack.m_41784_();
        float currentDamage = tag.m_128457_(TOTAL_DAMAGE_KEY);
        tag.m_128350_(TOTAL_DAMAGE_KEY, currentDamage + damage);
    }

    private static void checkAndGiveReward(ItemStack yamatoStack, Player player) {
        if (!((Boolean)EFNConfig.YAMATO_REWARD_ENABLED.get()).booleanValue()) {
            return;
        }
        int rewardThreshold = (Integer)EFNConfig.YAMATO_REWARD_KILL_THRESHOLD.get();
        if (rewardThreshold <= 0) {
            return;
        }
        int killCount = YamatoItem.getKillCount(yamatoStack);
        boolean rewardGiven = YamatoItem.isRewardGiven(yamatoStack);
        if (killCount >= rewardThreshold && !rewardGiven) {
            YamatoItem.setSkillReward(player);
            YamatoItem.setRewardGiven(yamatoStack, true);
        }
    }

    private static void setSkillReward(Player player) {
        player.m_213846_((Component)Component.m_237113_((String)"MY POWER SHALL BE ABSOLUTE").m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.BOLD));
        player.m_5496_(SoundEvents.f_11894_, 1.0f, 1.0f);
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Player player;
        ItemStack mainHand;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && (mainHand = (player = (Player)entity).m_21205_()).m_41720_() instanceof YamatoItem) {
            YamatoItem.addTotalDamage(mainHand, event.getAmount());
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Player player;
        ItemStack mainHand;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && (mainHand = (player = (Player)entity).m_21205_()).m_41720_() instanceof YamatoItem) {
            int oldKillCount = YamatoItem.getKillCount(mainHand);
            YamatoItem.incrementKillCount(mainHand);
            int newKillCount = YamatoItem.getKillCount(mainHand);
            YamatoItem.checkAndGiveReward(mainHand, player);
        }
    }

    @SubscribeEvent
    public static void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && YamatoItem.isHoldingYamato(player = (Player)livingEntity)) {
            player.m_20256_(player.m_20184_().m_82520_(0.0, 0.1, 0.0));
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && YamatoItem.isHoldingYamato(player = (Player)livingEntity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && YamatoItem.isHoldingYamato(player = (Player)entity) && entity.m_21023_(MobEffects.f_19620_)) {
            entity.m_21195_(MobEffects.f_19620_);
        }
    }

    private static boolean isHoldingYamato(Player player) {
        return player.m_21205_().m_41720_() instanceof YamatoItem || player.m_21206_().m_41720_() instanceof YamatoItem;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.WEAPON;
    }

    public int m_6473_() {
        return 50;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        int killCount = YamatoItem.getKillCount(stack);
        float totalDamage = YamatoItem.getTotalDamage(stack);
        boolean rewardGiven = YamatoItem.isRewardGiven(stack);
        tooltip.add((Component)Component.m_237115_((String)"item.efn.yamato.description1").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.AQUA).m_130940_(ChatFormatting.UNDERLINE));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.efn.yamato.kill_count", (Object[])new Object[]{killCount}).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.DARK_RED));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.efn.yamato.total_damage", (Object[])new Object[]{String.format("%.1f", Float.valueOf(totalDamage))}).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.DARK_RED));
        this.addSkillProgressTooltip(stack, tooltip, rewardGiven, killCount);
        if (InvincibleKeyMappings.KEY1.getKey().m_84873_() != 0) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.efn.keybind_warning"));
        }
    }

    private void addSkillProgressTooltip(ItemStack stack, List<Component> tooltip, boolean rewardGiven, int killCount) {
        if (!((Boolean)EFNConfig.YAMATO_REWARD_ENABLED.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.efn.yamato.skill_reward_disabled").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
            return;
        }
        int rewardThreshold = (Integer)EFNConfig.YAMATO_REWARD_KILL_THRESHOLD.get();
        if (rewardThreshold <= 0) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.efn.yamato.skill_reward_unavailable").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        } else {
            String progressBar = this.createProgressBar(killCount, rewardThreshold);
            int remainingKills = Math.max(0, rewardThreshold - killCount);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.efn.yamato.skill_progress_title", (Object[])new Object[]{remainingKills}).m_130940_(ChatFormatting.WHITE).m_130940_(ChatFormatting.BOLD));
            tooltip.add((Component)Component.m_237113_((String)progressBar).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        }
    }

    private String createProgressBar(int current, int max) {
        int barLength = 20;
        int filledLength = (int)((double)current / (double)max * (double)barLength);
        filledLength = Math.min(filledLength, barLength);
        return ChatFormatting.BLUE + "\u2588".repeat(Math.max(0, filledLength)) + ChatFormatting.GRAY + "\u2588".repeat(Math.max(0, barLength - filledLength));
    }
}

