/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.mixinloader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraftforge.fml.loading.FMLLoader;

public class CompatInfos {
    public static final HashMap<MixinClassName, CompatMixinInfo> CompatMixins = Maps.newHashMap();
    static final List<AbstractCompatMod> CompatMods = Lists.newArrayList();
    public static AbstractCompatMod IRIS_SHADER;
    public static AbstractCompatMod CATACLYSM_MOD;
    public static AbstractCompatMod LIONFISHAPI;
    public static AbstractCompatMod CITADEL;
    public static AbstractCompatMod GECKOLIB;
    public static AbstractCompatMod WOM;

    static void register() {
        WOM = new CompatMod("wom", m -> new CompatMixinInfo((AbstractCompatMod)m, "BasicMultipleAttackAnimationMixin"));
        LIONFISHAPI = new CompatMod("lionfishapi", m -> new CompatMixinInfo((AbstractCompatMod)m, "AnimationHandlerMixin"));
        CITADEL = new CompatMod("citadel", m -> new CompatMixinInfo((AbstractCompatMod)m, "AnimationHandlerMixin"));
        GECKOLIB = new CompatMod("geckolib", m -> new CompatMixinInfo((AbstractCompatMod)m, "AnimationProcessorMixin"));
        CATACLYSM_MOD = new CompatMod("cataclysm", m -> new CompatMixinInfo((AbstractCompatMod)m, "MixinLLibraryBossMonster"), m -> new CompatMixinInfo((AbstractCompatMod)m, "MixinIABossMonster"));
        IRIS_SHADER = new CompatMod("oculus", m -> new CompatMixinInfo((AbstractCompatMod)m, "MixinParticleEngineB"), m -> new CompatMixinInfo((AbstractCompatMod)m, "MixinParticleEngineA"){

            @Override
            public boolean shouldApplyMixin() {
                return !this.mod.isLoaded();
            }
        });
    }

    public static void initCompatInfo() {
        CompatInfos.register();
        CompatMods.forEach(AbstractCompatMod::check);
    }

    static String getClassName(String classPath) {
        String[] s = classPath.split("\\.");
        return s[s.length - 1];
    }

    public static boolean shouldMixin(String targetClassName, String mixinClassName_) {
        String mixinClassName = CompatInfos.getClassName(mixinClassName_);
        if (CompatMixins.containsKey(MixinClassName.of(mixinClassName))) {
            boolean should = CompatMixins.get(MixinClassName.of(mixinClassName)).shouldApplyMixin();
            if (should) {
                System.out.println("[EFN Mixin Loader]Apply Compat Mixin: " + mixinClassName_ + ".class -> " + targetClassName + ".class");
            } else {
                System.out.println("[EFN Mixin Loader]Skip Mixin: " + mixinClassName_ + ".class -> " + targetClassName + ".class");
            }
            return should;
        }
        System.out.println("[EFN Mixin Loader]Apply Default Mixin: " + mixinClassName_ + ".class -> " + targetClassName + ".class");
        return true;
    }

    public static class CompatMod
    extends AbstractCompatMod {
        final String modid;

        public CompatMod(String modid, String ... mixinClasses) {
            this.modid = modid;
            for (int i = 0; i < mixinClasses.length; ++i) {
                new CompatMixinInfo(this, mixinClasses[i]);
            }
        }

        @SafeVarargs
        public CompatMod(String modid, Function<AbstractCompatMod, CompatMixinInfo> ... mixinClasses) {
            this.modid = modid;
            for (Function<AbstractCompatMod, CompatMixinInfo> mixinClass : mixinClasses) {
                mixinClass.apply(this);
            }
        }

        @Override
        public void check() {
            this.loaded = FMLLoader.getLoadingModList().getModFileById(this.modid) != null;
        }

        @Override
        public boolean isLoaded() {
            return this.loaded;
        }
    }

    public static abstract class AbstractCompatMod {
        protected boolean loaded;

        public AbstractCompatMod() {
            CompatMods.add(this);
        }

        public abstract void check();

        public boolean isLoaded() {
            return this.loaded;
        }
    }

    public record MixinClassName(String className) {
        public static MixinClassName of(String n) {
            return new MixinClassName(n);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MixinClassName)) {
                return false;
            }
            MixinClassName that = (MixinClassName)o;
            return this.className.equals(that.className);
        }

        @Override
        public int hashCode() {
            return this.className.hashCode();
        }
    }

    public static class CompatMixinInfo {
        protected final AbstractCompatMod mod;

        public CompatMixinInfo(AbstractCompatMod mod, String mixinClass) {
            this.mod = mod;
            CompatMixins.put(MixinClassName.of(mixinClass), this);
        }

        public boolean shouldApplyMixin() {
            return this.mod.isLoaded();
        }
    }
}

