/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.mobeffects;

import com.hm.efn.gameasset.combos.Beastclaw;
import com.hm.efn.registries.EFNMobEffectRegistry;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

@Mod.EventBusSubscriber(modid="efn")
public class ClawEnhance {
    private static final UUID ARMOR_NEGATION_UUID = UUID.fromString("b0a7436e-5734-11eb-ae93-0242ac130014");
    private static final UUID IMPACT_UUID = UUID.fromString("b0a745b2-5734-11eb-ae93-0242ac130014");
    private static final UUID STUN_ARMOR_UUID = UUID.fromString("b0a746ac-5734-11eb-ae93-0242ac130014");
    private static final UUID STAMINA_REGEN_UUID = UUID.fromString("1c224694-19f3-11ec-9621-0242ac130104");
    private static final UUID DAMAGE_UUID = UUID.fromString("1c2249f0-19f3-11ec-9621-0242ac130104");
    private static final UUID SPEED_UUID = UUID.fromString("1c2249f0-19f3-22ec-9621-0242ac130104");
    private static final UUID JUMP_UUID = UUID.fromString("1c2249f0-19f3-33ec-9621-0242ac130104");
    private static final UUID ATKSPEED_UUID = UUID.fromString("1c2249f0-19f3-44ec-9621-0242ac130104");
    private static final UUID DAMAGE_VULNERABILITY_UUID = UUID.fromString("1c2249f1-19f3-11ec-9621-0242ac130105");
    private static final double MULTIPLIER = 1.3;
    private static final double MULTIPLIER_MINUS_ONE = 0.30000000000000004;
    private static final double DAMAGE_VULNERABILITY = 0.25;

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() instanceof ClawEffect) {
            LivingEntity entity = event.getEntity();
            if (!ClawEffect.hasClawSkill(entity)) {
                entity.m_21195_(event.getEffectInstance().m_19544_());
                return;
            }
            ((ClawEffect)event.getEffectInstance().m_19544_()).applyModifiers(entity);
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        if (event.getEffect() instanceof ClawEffect) {
            ((ClawEffect)event.getEffect()).removeModifiers(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        if (event.getEffectInstance() != null && event.getEffectInstance().m_19544_() instanceof ClawEffect) {
            ((ClawEffect)event.getEffectInstance().m_19544_()).removeModifiers(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof Player && event.getSlot() == EquipmentSlot.MAINHAND && event.getEntity().m_21023_((MobEffect)EFNMobEffectRegistry.CLAW.get())) {
            event.getEntity().m_21195_((MobEffect)EFNMobEffectRegistry.CLAW.get());
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)EFNMobEffectRegistry.CLAW.get())) {
            event.setAmount((float)((double)event.getAmount() * 1.25));
        }
    }

    public static class ClawEffect
    extends MobEffect {
        public ClawEffect() {
            super(MobEffectCategory.NEUTRAL, 9127187);
        }

        public static boolean hasClawSkill(LivingEntity entity) {
            if (!(entity instanceof Player)) {
                return false;
            }
            PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, PlayerPatch.class);
            return playerPatch != null && playerPatch.getSkill(Beastclaw.beastclaw) != null;
        }

        public void m_6742_(LivingEntity entity, int amplifier) {
            if (!entity.m_9236_().m_5776_()) {
                if (!ClawEffect.hasClawSkill(entity)) {
                    entity.m_21195_((MobEffect)this);
                    return;
                }
                this.applyModifiers(entity);
            }
        }

        public boolean m_6584_(int duration, int amplifier) {
            return true;
        }

        private void applyModifiers(LivingEntity entity) {
            this.safeAddModifier(entity, (Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), ARMOR_NEGATION_UUID, "Claw Armor Negation");
            this.safeAddModifier(entity, (Attribute)EpicFightAttributes.IMPACT.get(), IMPACT_UUID, "Claw Impact");
            this.safeAddModifier(entity, (Attribute)EpicFightAttributes.STUN_ARMOR.get(), STUN_ARMOR_UUID, "Claw Stun Armor");
            this.safeAddModifier(entity, (Attribute)EpicFightAttributes.STAMINA_REGEN.get(), STAMINA_REGEN_UUID, "Claw Stamina Regen");
            this.safeAddModifier(entity, Attributes.f_22281_, DAMAGE_UUID, "Claw Damage");
            this.safeAddModifier(entity, Attributes.f_22279_, SPEED_UUID, "Claw Speed");
            this.safeAddModifier(entity, Attributes.f_22283_, ATKSPEED_UUID, "Claw AtkSpeed");
            this.safeAddModifier(entity, Attributes.f_22288_, JUMP_UUID, "Claw Jump");
            this.safeAddModifier(entity, Attributes.f_22284_, DAMAGE_VULNERABILITY_UUID, "Claw Vulnerability", -0.25);
        }

        private void removeModifiers(LivingEntity entity) {
            this.safeRemoveModifier(entity, (Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), ARMOR_NEGATION_UUID);
            this.safeRemoveModifier(entity, (Attribute)EpicFightAttributes.IMPACT.get(), IMPACT_UUID);
            this.safeRemoveModifier(entity, (Attribute)EpicFightAttributes.STUN_ARMOR.get(), STUN_ARMOR_UUID);
            this.safeRemoveModifier(entity, (Attribute)EpicFightAttributes.STAMINA_REGEN.get(), STAMINA_REGEN_UUID);
            this.safeRemoveModifier(entity, Attributes.f_22281_, DAMAGE_UUID);
            this.safeRemoveModifier(entity, Attributes.f_22279_, SPEED_UUID);
            this.safeRemoveModifier(entity, Attributes.f_22283_, ATKSPEED_UUID);
            this.safeRemoveModifier(entity, Attributes.f_22288_, JUMP_UUID);
            this.safeRemoveModifier(entity, Attributes.f_22284_, DAMAGE_VULNERABILITY_UUID);
        }

        private void safeAddModifier(LivingEntity entity, Attribute attribute, UUID uuid, String name) {
            this.safeAddModifier(entity, attribute, uuid, name, 0.30000000000000004);
        }

        private void safeAddModifier(LivingEntity entity, Attribute attribute, UUID uuid, String name, double amount) {
            if (entity.m_21051_(attribute) != null) {
                AttributeModifier modifier = new AttributeModifier(uuid, name, amount, AttributeModifier.Operation.MULTIPLY_TOTAL);
                if (!Objects.requireNonNull(entity.m_21051_(attribute)).m_22109_(modifier)) {
                    Objects.requireNonNull(entity.m_21051_(attribute)).m_22118_(modifier);
                }
            }
        }

        private void safeRemoveModifier(LivingEntity entity, Attribute attribute, UUID uuid) {
            if (entity.m_21051_(attribute) != null) {
                Objects.requireNonNull(entity.m_21051_(attribute)).m_22120_(uuid);
            }
        }
    }
}

