/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.mobeffects;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

@Mod.EventBusSubscriber(modid="efn")
public class StaminaEnhance {
    private static final UUID STAMINA_REGEN_UUID = UUID.fromString("1c224694-19f3-11ec-9621-0242ac140105");
    private static final double STAMINA_REGEN_BONUS = 1.5;

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() instanceof StaminaEffect) {
            LivingEntity entity = event.getEntity();
            ((StaminaEffect)event.getEffectInstance().m_19544_()).applyModifiers(entity);
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        if (event.getEffect() instanceof StaminaEffect) {
            ((StaminaEffect)event.getEffect()).removeModifiers(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        if (event.getEffectInstance() != null && event.getEffectInstance().m_19544_() instanceof StaminaEffect) {
            ((StaminaEffect)event.getEffectInstance().m_19544_()).removeModifiers(event.getEntity());
        }
    }

    public static class StaminaEffect
    extends MobEffect {
        public StaminaEffect() {
            super(MobEffectCategory.BENEFICIAL, 65280);
        }

        public void m_6742_(LivingEntity entity, int amplifier) {
        }

        public boolean m_6584_(int duration, int amplifier) {
            return false;
        }

        private void applyModifiers(LivingEntity entity) {
            this.safeAddModifier(entity, (Attribute)EpicFightAttributes.STAMINA_REGEN.get(), STAMINA_REGEN_UUID, "Stamina Enhance Regen", 1.5);
        }

        private void removeModifiers(LivingEntity entity) {
            this.safeRemoveModifier(entity, (Attribute)EpicFightAttributes.STAMINA_REGEN.get(), STAMINA_REGEN_UUID);
        }

        private void safeAddModifier(LivingEntity entity, Attribute attribute, UUID uuid, String name, double amount) {
            if (entity.m_21051_(attribute) != null) {
                AttributeModifier modifier = new AttributeModifier(uuid, name, amount, AttributeModifier.Operation.ADDITION);
                if (!Objects.requireNonNull(entity.m_21051_(attribute)).m_22109_(modifier)) {
                    Objects.requireNonNull(entity.m_21051_(attribute)).m_22118_(modifier);
                }
            }
        }

        private void safeRemoveModifier(LivingEntity entity, Attribute attribute, UUID uuid) {
            if (entity.m_21051_(attribute) != null) {
                Objects.requireNonNull(entity.m_21051_(attribute)).m_22120_(uuid);
            }
        }
    }
}

