/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.mobeffects;

import com.hm.efn.registries.EFNMobEffectRegistry;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

@Mod.EventBusSubscriber(modid="efn")
public class Yamato {
    private static final UUID DAMAGE_UUID = UUID.fromString("1c2249f0-19f3-11ec-0721-0242ac130003");
    private static final double MULTIPLIER = 1.35;
    private static final double MULTIPLIER_MINUS_ONE = 0.3500000000000001;

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() instanceof YamatoEffect) {
            if (YamatoEffect.hasYamatoSkill(event.getEntity())) {
                event.getEntity().m_21195_((MobEffect)EFNMobEffectRegistry.YAMATO.get());
                return;
            }
            ((YamatoEffect)event.getEffectInstance().m_19544_()).applyModifiers(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        if (event.getEffect() instanceof YamatoEffect) {
            ((YamatoEffect)event.getEffect()).removeModifiers(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        if (Objects.requireNonNull(event.getEffectInstance()).m_19544_() instanceof YamatoEffect) {
            ((YamatoEffect)event.getEffectInstance().m_19544_()).removeModifiers(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof Player && event.getSlot() == EquipmentSlot.MAINHAND && event.getEntity().m_21023_((MobEffect)EFNMobEffectRegistry.YAMATO.get())) {
            event.getEntity().m_21195_((MobEffect)EFNMobEffectRegistry.YAMATO.get());
        }
    }

    public static class YamatoEffect
    extends MobEffect {
        public YamatoEffect() {
            super(MobEffectCategory.NEUTRAL, 0xFFFFFF);
        }

        public static boolean hasYamatoSkill(LivingEntity entity) {
            if (!(entity instanceof Player)) {
                return true;
            }
            PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, PlayerPatch.class);
            return playerPatch == null || playerPatch.getSkill(com.hm.efn.gameasset.combos.Yamato.yamato) == null;
        }

        public void m_6742_(LivingEntity entity, int amplifier) {
            if (!entity.m_9236_().m_5776_()) {
                this.applyModifiers(entity);
            }
        }

        public boolean m_6584_(int duration, int amplifier) {
            return true;
        }

        private void applyModifiers(LivingEntity entity) {
            if (YamatoEffect.hasYamatoSkill(entity)) {
                return;
            }
            this.safeAddModifier(entity, Attributes.f_22281_, DAMAGE_UUID, "Yamato Damage");
        }

        private void removeModifiers(LivingEntity entity) {
            this.safeRemoveModifier(entity, Attributes.f_22281_, DAMAGE_UUID);
        }

        private void safeAddModifier(LivingEntity entity, Attribute attribute, UUID uuid, String name) {
            if (entity.m_21051_(attribute) != null) {
                AttributeModifier modifier = new AttributeModifier(uuid, name, 0.3500000000000001, AttributeModifier.Operation.MULTIPLY_TOTAL);
                if (!Objects.requireNonNull(entity.m_21051_(attribute)).m_22109_(modifier)) {
                    Objects.requireNonNull(entity.m_21051_(attribute)).m_22118_(modifier);
                }
            }
        }

        private void safeRemoveModifier(LivingEntity entity, Attribute attribute, UUID uuid) {
            if (entity.m_21051_(attribute) != null) {
                Objects.requireNonNull(entity.m_21051_(attribute)).m_22120_(uuid);
            }
        }
    }
}

