/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.dodge;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class EFNDodgeSkill
extends DodgeSkill {
    private static final UUID STAMINA_MODIFIER_UUID = UUID.fromString("a1b2c3d4-e5f6-11ed-a05b-0242ac120115");
    private static final float STAMINA_BONUS = 6.0f;
    private static final String STAMINA_MODIFIER_NAME = "EFN Dodge Skill Stamina Bonus";

    public EFNDodgeSkill(DodgeSkill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        PlayerPatch executer = container.getExecutor();
        Player player = (Player)executer.getOriginal();
        if (executer instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)executer;
            AttributeModifier modifier = new AttributeModifier(STAMINA_MODIFIER_UUID, STAMINA_MODIFIER_NAME, 6.0, AttributeModifier.Operation.ADDITION);
            Objects.requireNonNull(((ServerPlayer)serverPlayerPatch.getOriginal()).m_21051_((Attribute)EpicFightAttributes.MAX_STAMINA.get())).m_22118_(modifier);
        }
    }

    public void onRemoved(SkillContainer container) {
        PlayerPatch executer = container.getExecutor();
        if (executer instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)executer;
            Objects.requireNonNull(((ServerPlayer)serverPlayerPatch.getOriginal()).m_21051_((Attribute)EpicFightAttributes.MAX_STAMINA.get())).m_22120_(STAMINA_MODIFIER_UUID);
        }
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnServer(container, args);
        container.getExecutor().playSound((SoundEvent)EpicFightSounds.ROLL.get(), 1.0f, 1.0f);
    }
}

