/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.dodge;

import com.hm.efn.gameasset.EFNWeaponCategories;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.client.CPSkillRequest;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class YamatoDodge
extends DodgeSkill {
    private static final UUID JUMP_EVENT_UUID = UUID.fromString("a1b2c3d4-e5f6-11ed-a50b-0242ac120123");

    public YamatoDodge(DodgeSkill.Builder builder) {
        super(builder);
    }

    public static boolean isHoldingYamato(Player player) {
        if (player == null) {
            return false;
        }
        return Stream.of(player.m_21205_(), player.m_21206_()).map(EpicFightCapabilities::getItemStackCapability).filter(Objects::nonNull).anyMatch(cap -> cap.getWeaponCategory() == EFNWeaponCategories.EFN_YAMATO);
    }

    public void onInitiate(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        container.getDataManager().registerData((SkillDataKey)SkillDataKeys.JUMP_COUNT.get());
        container.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_COUNT.get(), (Object)0);
        listener.addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, JUMP_EVENT_UUID, event -> {
            if (((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20202_() != null || !((LocalPlayerPatch)event.getPlayerPatch()).isEpicFightMode() || ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_150110_().f_35935_ || ((LocalPlayerPatch)event.getPlayerPatch()).isHoldingAny() || ((LocalPlayerPatch)event.getPlayerPatch()).getEntityState().inaction()) {
                return;
            }
            boolean jumpPressed = Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
            boolean isOnGround = ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20096_();
            if (isOnGround && jumpPressed) {
                container.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_COUNT.get(), (Object)1);
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.FALL_EVENT, JUMP_EVENT_UUID, event -> container.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_COUNT.get(), (Object)0));
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, JUMP_EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.FALL_EVENT, JUMP_EVENT_UUID);
    }

    public boolean canExecute(SkillContainer container) {
        return YamatoDodge.isHoldingYamato((Player)container.getExecutor().getOriginal());
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(SkillContainer skillContainer, FriendlyByteBuf args) {
        float finalDegree;
        int directionIndex;
        LocalPlayerPatch executor = skillContainer.getClientExecutor();
        Input input = ((LocalPlayer)executor.getOriginal()).f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)executor.getOriginal()))), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        int forward = input.f_108568_ ? 1 : 0;
        int backward = input.f_108569_ ? -1 : 0;
        int left = input.f_108570_ ? 1 : 0;
        int right = input.f_108571_ ? -1 : 0;
        int vertic = forward + backward;
        int horizon = left + right;
        float yRot = Minecraft.m_91087_().f_91063_.m_109153_().m_90590_();
        float degree = (float)(-(90 * horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon)) + yRot;
        boolean isInAir = !((LocalPlayer)executor.getOriginal()).m_20096_();
        int jumpCounter = (Integer)skillContainer.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.JUMP_COUNT.get());
        boolean canDoubleJump = isInAir && jumpCounter > 0;
        CPSkillRequest packet = new CPSkillRequest(skillContainer.getSlot());
        if (isInAir && vertic < 0) {
            directionIndex = 5;
            finalDegree = yRot;
        } else if (isInAir && vertic == 0 && horizon == 0 && canDoubleJump) {
            directionIndex = 4;
            finalDegree = yRot;
            skillContainer.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_COUNT.get(), (Object)0);
        } else if (!isInAir && vertic == 0 && horizon == 0) {
            directionIndex = 4;
            finalDegree = yRot;
        } else {
            directionIndex = vertic == 0 ? (horizon == 0 ? 0 : (horizon >= 0 ? 2 : 3)) : (vertic >= 0 ? 0 : 1);
            finalDegree = vertic == 0 && horizon != 0 ? yRot : degree;
        }
        packet.getBuffer().writeInt(directionIndex);
        packet.getBuffer().writeFloat(finalDegree);
        packet.getBuffer().writeBoolean(isInAir);
        packet.getBuffer().writeInt(jumpCounter);
        return packet;
    }

    public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
        boolean canDoubleJump;
        skillContainer.getExecutor().playSound(SoundEvents.f_11852_, 1.0f, 1.0f);
        ServerPlayerPatch executor = skillContainer.getServerExecutor();
        int animationIndex = args.readInt();
        float degree = args.readFloat();
        boolean clientIsInAir = args.readBoolean();
        int clientJumpCounter = args.readInt();
        boolean serverIsInAir = !((ServerPlayer)executor.getOriginal()).m_20096_();
        skillContainer.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_COUNT.get(), (Object)clientJumpCounter);
        boolean bl = canDoubleJump = serverIsInAir && clientJumpCounter > 0;
        if (serverIsInAir && animationIndex == 1) {
            animationIndex = 5;
        }
        if (serverIsInAir && animationIndex == 4) {
            if (!canDoubleJump) {
                animationIndex = 0;
            } else {
                skillContainer.getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_COUNT.get(), (Object)0);
                ((ServerPlayer)executor.getOriginal()).m_20334_(((ServerPlayer)executor.getOriginal()).m_20184_().f_82479_, 0.5, ((ServerPlayer)executor.getOriginal()).m_20184_().f_82481_);
            }
        }
        if (animationIndex < 0 || animationIndex >= this.animations.length) {
            animationIndex = serverIsInAir ? 5 : 4;
        }
        executor.playAnimationSynchronized((AssetAccessor)this.animations[animationIndex], 0.0f);
        executor.setModelYRot(degree, true);
    }
}

