/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.passive;

import com.hm.efn.EFN;
import com.hm.efn.gameasset.EFNSkills;
import com.hm.efn.registries.EFNDataKey;
import com.hm.efn.registries.EFNMobEffectRegistry;
import com.merlin204.avalon.entity.vfx.VFXEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ParryMasterPassive
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("a1b2c3d4-5678-90ef-1234-56789abcdef0");
    private static final UUID DAMAGE_EVENT_UUID = UUID.fromString("b1b2c3d4-5678-90ef-1234-56789abcdef0");
    private static final List<DelayedAnimationTask> ANIMATION_QUEUE = new ArrayList<DelayedAnimationTask>();
    private float chargeBonus = 0.05f;
    private float basePunctureChance = 0.1f;
    private float punctureChanceIncrement = 0.02f;
    private float maxPunctureChance = 0.4f;
    private float punctureResetThreshold = 0.2f;

    public ParryMasterPassive(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    public static Builder createParryMasterPassiveBuilder() {
        return (Builder)new Builder().setCategory((SkillCategory)SkillCategories.PASSIVE).setResource(Skill.Resource.COOLDOWN);
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.chargeBonus = parameters.m_128441_("charge_bonus") ? parameters.m_128457_("charge_bonus") : this.chargeBonus;
        this.basePunctureChance = parameters.m_128441_("base_puncture_chance") ? parameters.m_128457_("base_puncture_chance") : this.basePunctureChance;
        this.punctureChanceIncrement = parameters.m_128441_("puncture_chance_increment") ? parameters.m_128457_("puncture_chance_increment") : this.punctureChanceIncrement;
        this.maxPunctureChance = parameters.m_128441_("max_puncture_chance") ? parameters.m_128457_("max_puncture_chance") : this.maxPunctureChance;
        this.punctureResetThreshold = parameters.m_128441_("puncture_reset_threshold") ? parameters.m_128457_("puncture_reset_threshold") : this.punctureResetThreshold;
    }

    public void onInitiate(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        SkillDataManager data = container.getDataManager();
        data.registerData(EFNDataKey.CURRENT_PUNCTURE_CHANCE.get());
        data.registerData(EFNDataKey.CHARGE_BONUS.get());
        data.registerData(EFNDataKey.BASE_PUNCTURE_CHANCE.get());
        data.registerData(EFNDataKey.PUNCTURE_INCREMENT.get());
        data.registerData(EFNDataKey.MAX_PUNCTURE_CHANCE.get());
        data.registerData(EFNDataKey.PUNCTURE_RESET_THRESHOLD.get());
        data.setData(EFNDataKey.CHARGE_BONUS.get(), (Object)Float.valueOf(this.chargeBonus));
        data.setData(EFNDataKey.BASE_PUNCTURE_CHANCE.get(), (Object)Float.valueOf(this.basePunctureChance));
        data.setData(EFNDataKey.PUNCTURE_INCREMENT.get(), (Object)Float.valueOf(this.punctureChanceIncrement));
        data.setData(EFNDataKey.MAX_PUNCTURE_CHANCE.get(), (Object)Float.valueOf(this.maxPunctureChance));
        data.setData(EFNDataKey.PUNCTURE_RESET_THRESHOLD.get(), (Object)Float.valueOf(this.punctureResetThreshold));
        data.setData(EFNDataKey.CURRENT_PUNCTURE_CHANCE.get(), (Object)Float.valueOf(this.basePunctureChance));
        if (!container.getExecutor().isLogicalClient()) {
            ServerPlayer player = (ServerPlayer)container.getExecutor().getOriginal();
            Objects.requireNonNull(player.m_20194_()).execute(() -> {
                if (player.f_8906_ != null) {
                    data.setDataSync(EFNDataKey.CHARGE_BONUS.get(), (Object)Float.valueOf(this.chargeBonus), player);
                    data.setDataSync(EFNDataKey.BASE_PUNCTURE_CHANCE.get(), (Object)Float.valueOf(this.basePunctureChance), player);
                    data.setDataSync(EFNDataKey.PUNCTURE_INCREMENT.get(), (Object)Float.valueOf(this.punctureChanceIncrement), player);
                    data.setDataSync(EFNDataKey.MAX_PUNCTURE_CHANCE.get(), (Object)Float.valueOf(this.maxPunctureChance), player);
                    data.setDataSync(EFNDataKey.PUNCTURE_RESET_THRESHOLD.get(), (Object)Float.valueOf(this.punctureResetThreshold), player);
                    data.setDataSync(EFNDataKey.CURRENT_PUNCTURE_CHANCE.get(), (Object)Float.valueOf(this.basePunctureChance), player);
                }
            });
        }
        listener.addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            if (event.isParried() && !container.getExecutor().isLogicalClient()) {
                ServerPlayer player = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                SkillContainer weaponSkillContainer = ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
                if (weaponSkillContainer != null && weaponSkillContainer.getSkill() != null) {
                    float currentCharge = weaponSkillContainer.getResource();
                    float maxCharge = weaponSkillContainer.getMaxResource();
                    float chargeBonus = ((Float)data.getDataValue(EFNDataKey.CHARGE_BONUS.get())).floatValue();
                    float newCharge = Math.min(maxCharge, currentCharge + maxCharge * chargeBonus);
                    weaponSkillContainer.getSkill().setConsumptionSynchronize(weaponSkillContainer, newCharge);
                }
                float currentChance = ((Float)data.getDataValue(EFNDataKey.CURRENT_PUNCTURE_CHANCE.get())).floatValue();
                float increment = ((Float)data.getDataValue(EFNDataKey.PUNCTURE_INCREMENT.get())).floatValue();
                float maxChance = ((Float)data.getDataValue(EFNDataKey.MAX_PUNCTURE_CHANCE.get())).floatValue();
                float newChance = Math.min(maxChance, currentChance + increment);
                data.setDataSync(EFNDataKey.CURRENT_PUNCTURE_CHANCE.get(), (Object)Float.valueOf(newChance), player);
            }
        }, -1);
        listener.addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, DAMAGE_EVENT_UUID, event -> {
            if (!container.getExecutor().isLogicalClient() && container.getStack() > 0 && event.getDamageSource() instanceof EpicFightDamageSource) {
                if (event.getTarget() instanceof VFXEntity) {
                    return;
                }
                ServerPlayer player = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                float currentChance = ((Float)data.getDataValue(EFNDataKey.CURRENT_PUNCTURE_CHANCE.get())).floatValue();
                float randomValue = player.m_217043_().m_188501_();
                boolean success = randomValue < currentChance;
                EFN.LOGGER.debug("[ParryMaster] Puncture chance check - Current: {}({}%), Roll: {}({}%), Result: {}", (Object)Float.valueOf(currentChance), (Object)((int)(currentChance * 100.0f)), (Object)Float.valueOf(randomValue), (Object)((int)(randomValue * 100.0f)), (Object)(success ? "SUCCESS" : "FAILED"));
                if (success) {
                    EpicFightDamageSource damageSource = event.getDamageSource();
                    damageSource.addRuntimeTag(EpicFightDamageTypeTags.GUARD_PUNCTURE);
                    damageSource.addRuntimeTag(EpicFightDamageTypeTags.BYPASS_DODGE);
                    damageSource.attachDamageModifier(ValueModifier.multiplier((float)2.0f));
                    damageSource.setBaseArmorNegation(100.0f);
                    damageSource.setStunType(StunType.LONG);
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.INVINCIBILITY_EFFECT.get(), 30, 0, false, false, false));
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 0.0f, 0.0f);
                    ANIMATION_QUEUE.add(new DelayedAnimationTask((ServerPlayerPatch)event.getPlayerPatch(), 6));
                    this.setStackSynchronize(container, container.getStack() - 1);
                    float resetThreshold = ((Float)data.getDataValue(EFNDataKey.PUNCTURE_RESET_THRESHOLD.get())).floatValue();
                    if (currentChance >= resetThreshold) {
                        float baseChance = ((Float)data.getDataValue(EFNDataKey.BASE_PUNCTURE_CHANCE.get())).floatValue();
                        data.setDataSync(EFNDataKey.CURRENT_PUNCTURE_CHANCE.get(), (Object)Float.valueOf(baseChance), player);
                    }
                }
            }
        }, -1);
    }

    public void onRemoved(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, -1);
        listener.removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, DAMAGE_EVENT_UUID, -1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        float currentChance = ((Float)container.getDataManager().getDataValue(EFNDataKey.CURRENT_PUNCTURE_CHANCE.get())).floatValue();
        String displayText = String.format("%d%%", (int)(currentChance * 100.0f));
        guiGraphics.drawString(gui.getFont(), displayText, x + 12.0f - (float)gui.getFont().m_92895_(displayText) / 2.0f, y + 14.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%.1f", Float.valueOf(this.basePunctureChance)));
        return list;
    }

    public Skill getPriorSkill() {
        return EpicFightSkills.PARRYING;
    }

    public static class Builder
    extends SkillBuilder<ParryMasterPassive> {
    }

    private static class DelayedAnimationTask {
        final ServerPlayerPatch playerPatch;
        final int executeTick;

        DelayedAnimationTask(ServerPlayerPatch playerPatch, int delayTicks) {
            this.playerPatch = playerPatch;
            this.executeTick = (int)(((ServerPlayer)playerPatch.getOriginal()).m_9236_().m_46467_() + (long)delayTicks);
        }
    }

    @Mod.EventBusSubscriber(modid="efn")
    public static class AnimationHandler {
        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END && !ANIMATION_QUEUE.isEmpty()) {
                long currentTick = event.getServer().m_129783_().m_46467_();
                Iterator<DelayedAnimationTask> iterator = ANIMATION_QUEUE.iterator();
                while (iterator.hasNext()) {
                    ItemStack offHandItem;
                    Player player;
                    ItemStack mainHandItem;
                    boolean isValidWeapon;
                    DelayedAnimationTask task = iterator.next();
                    if (currentTick < (long)task.executeTick) continue;
                    if (task.playerPatch.getSkill(EFNSkills.PARRY_MASTER) != null && (isValidWeapon = Stream.of(mainHandItem = (player = (Player)task.playerPatch.getOriginal()).m_21205_(), offHandItem = player.m_21206_()).map(EpicFightCapabilities::getItemStackCapability).filter(Objects::nonNull).anyMatch(cap -> cap.getWeaponCategory() == CapabilityItem.WeaponCategories.TACHI || cap.getWeaponCategory() == CapabilityItem.WeaponCategories.UCHIGATANA))) {
                        task.playerPatch.playAnimationSynchronized((AssetAccessor)Animations.RUSHING_TEMPO3, 0.15f);
                        ((ServerPlayer)task.playerPatch.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EFNMobEffectRegistry.INVINCIBILITY_EFFECT.get(), 20, 0, false, false, false));
                    }
                    iterator.remove();
                }
            }
        }
    }
}

