/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.weapon_innate;

import com.google.common.collect.Lists;
import com.hm.efn.gameasset.animations.EFNGreatSwordAnimations;
import com.hm.efn.registries.EFNDataKey;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.glfw.GLFW;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.modules.HoldableSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.MovementInputEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class RuinsGreatSwordInnate
extends ComboBasicAttack {
    public static final int MAX_CHARGING_TICKS = 46;
    public static final int MIN_CHARGE_THRESHOLD = 20;
    private static final AnimationManager.AnimationAccessor<? extends StaticAnimation> CHARGING_ANIM = EFNGreatSwordAnimations.NG_GREATSWORD_CHARGING;
    private static final AnimationManager.AnimationAccessor<? extends StaticAnimation> FULL_CHARGE_ANIM = EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MAX_FIRST;
    private static final AnimationManager.AnimationAccessor<? extends StaticAnimation> LOW_CHARGE_ANIM = EFNGreatSwordAnimations.NG_GREATSWORD_CHARG1MIN;
    private static final int STAMINA_CONSUME_INTERVAL = 4;
    private static final float STAMINA_CONSUME_AMOUNT = 0.7f;
    private static final float MIN_STAMINA_THRESHOLD = 1.0f;
    private static final int COOLDOWN_TICKS = 20;
    private static final UUID MOVEMENT_LOCK_UUID = UUID.fromString("d34db31f-5a1d-4b3a-9f1c-1919810c2d1a");
    private static final UUID ANIMATION_EVENT_UUID = UUID.fromString("d34db32f-5a1d-4b3a-9f2c-1919810c2d1a");
    private static final UUID STAMINA_CHECK_UUID = UUID.fromString("d34db33f-5a1d-4b3a-9f3c-1919810c2d1a");
    private boolean hasAutoTriggered = false;

    public RuinsGreatSwordInnate(ComboBasicAttack.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        SkillDataManager data = container.getDataManager();
        data.registerData(EFNDataKey.isPressing());
        data.registerData(EFNDataKey.isCharging());
        data.registerData(EFNDataKey.chargeTicks());
        data.registerData(EFNDataKey.chargeMessage());
        data.registerData(EFNDataKey.KEY1_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY2_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY3_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY4_LONG_PRESS.get());
        data.registerData(EFNDataKey.INNATE_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY1_PRESS.get());
        data.registerData(EFNDataKey.KEY2_PRESS.get());
        data.registerData(EFNDataKey.KEY3_PRESS.get());
        data.registerData(EFNDataKey.KEY4_PRESS.get());
        data.registerData(EFNDataKey.INNATE_PRESS.get());
        data.registerData(EFNDataKey.KEY1_PRESS_TIMER.get());
        data.registerData(EFNDataKey.KEY2_PRESS_TIMER.get());
        data.registerData(EFNDataKey.KEY3_PRESS_TIMER.get());
        data.registerData(EFNDataKey.KEY4_PRESS_TIMER.get());
        data.registerData(EFNDataKey.INNATE_PRESS_TIMER.get());
        data.registerData(EFNDataKey.COMBO_COUNTER.get());
        data.registerData(EFNDataKey.ANGEL_KEY.get());
        data.registerData(EFNDataKey.DEMON_KEY.get());
        data.registerData(EFNDataKey.JUMP_KEY.get());
        data.registerData(EFNDataKey.SNEAK_KEY.get());
        data.registerData(EFNDataKey.UP_KEY.get());
        data.registerData(EFNDataKey.DOWN_KEY.get());
        data.registerData(EFNDataKey.COOLDOWN.get());
        this.hasAutoTriggered = false;
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, MOVEMENT_LOCK_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(EFNDataKey.isCharging())).booleanValue()) {
                MovementInputEvent inputEvent = event;
                Input input = inputEvent.getMovementInput();
                input.f_108567_ = 0.0f;
                input.f_108566_ = 0.0f;
                input.f_108572_ = false;
                input.f_108573_ = false;
                if (((LocalPlayerPatch)event.getPlayerPatch()).isLogicalClient()) {
                    LocalPlayer player = (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
                    player.m_6858_(false);
                }
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ANIMATION_END_EVENT, ANIMATION_EVENT_UUID, event -> {
            StaticAnimation animation = event.getAnimation();
            PlayerPatch executor = container.getExecutor();
            SkillDataManager dataManager = container.getDataManager();
            if (animation == FULL_CHARGE_ANIM.get() || animation == LOW_CHARGE_ANIM.get()) {
                this.resetChargeState(dataManager, executor.getOriginal());
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, STAMINA_CHECK_UUID, event -> {
            ServerPlayerPatch serverPatch;
            float currentStamina;
            PlayerPatch patt6622$temp;
            if (((Boolean)container.getDataManager().getDataValue(EFNDataKey.isCharging())).booleanValue() && (patt6622$temp = container.getExecutor()) instanceof ServerPlayerPatch && (currentStamina = (serverPatch = (ServerPlayerPatch)patt6622$temp).getStamina()) < 1.0f) {
                this.forceReleaseDueToLowStamina(container, serverPatch);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        this.hasAutoTriggered = false;
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, MOVEMENT_LOCK_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ANIMATION_END_EVENT, ANIMATION_EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, STAMINA_CHECK_UUID);
        super.onRemoved(container);
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (container.getExecutor().getEntityState().inaction()) {
            return;
        }
        this.handleCooldown(container);
        if (container.getExecutor().isLogicalClient()) {
            this.handleClientInput(container);
        } else {
            this.validateServerState(container);
        }
    }

    private void handleCooldown(SkillContainer container) {
        SkillDataManager data = container.getDataManager();
        Integer cooldown = (Integer)data.getDataValue(EFNDataKey.COOLDOWN.get());
        if (cooldown != null && cooldown > 0) {
            data.setData(EFNDataKey.COOLDOWN.get(), (Object)(cooldown - 1));
        }
    }

    private void handleClientInput(SkillContainer container) {
        boolean isHoldingGreatsword;
        LocalPlayer player = (LocalPlayer)container.getExecutor().getOriginal();
        SkillDataManager data = container.getDataManager();
        if (player.m_9236_().f_46443_ && Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        boolean bl = isHoldingGreatsword = EpicFightCapabilities.getItemStackCapability((ItemStack)heldItem) != null && EpicFightCapabilities.getItemStackCapability((ItemStack)heldItem).getWeaponCategory() == CapabilityItem.WeaponCategories.GREATSWORD;
        if (!isHoldingGreatsword && ((Boolean)data.getDataValue(EFNDataKey.isCharging())).booleanValue()) {
            this.resetChargeState(data, player);
            return;
        }
        if (isHoldingGreatsword) {
            boolean isKeyDown = false;
            boolean wasPressing = (Boolean)data.getDataValue(EFNDataKey.isPressing());
            if (player.m_9236_().f_46443_) {
                long windowHandle = Minecraft.m_91087_().m_91268_().m_85439_();
                boolean isRightMouseDown = GLFW.glfwGetMouseButton((long)windowHandle, (int)1) == 1;
                boolean isLeftMouseDown = GLFW.glfwGetMouseButton((long)windowHandle, (int)0) == 1;
                boolean bl2 = isKeyDown = isRightMouseDown && isLeftMouseDown;
            }
            if (isKeyDown != wasPressing) {
                if (player.m_9236_().f_46443_) {
                    data.setDataSync(EFNDataKey.isPressing(), (Object)isKeyDown, player);
                }
                if (isKeyDown) {
                    this.startCharging(container, player, data);
                } else {
                    int chargeTime = (Integer)data.getDataValue(EFNDataKey.chargeTicks());
                    if (!this.hasAutoTriggered) {
                        this.releaseAttack(container, chargeTime, player, false);
                    }
                }
            }
        }
    }

    private void startCharging(SkillContainer container, LocalPlayer player, SkillDataManager data) {
        PlayerPatch executor = container.getExecutor();
        Integer cooldown = (Integer)data.getDataValue(EFNDataKey.COOLDOWN.get());
        if (cooldown != null && cooldown > 0) {
            return;
        }
        if (this.isPlayingChargeAnimation(executor)) {
            return;
        }
        if (!executor.getEntityState().inaction() && !((Boolean)data.getDataValue(EFNDataKey.isCharging())).booleanValue()) {
            Skill skill;
            data.setDataSync(EFNDataKey.isCharging(), (Object)true, player);
            data.setDataSync(EFNDataKey.chargeTicks(), (Object)0, player);
            this.hasAutoTriggered = false;
            SkillContainer skillContainer = container.getExecutor().getSkill((SkillSlot)SkillSlots.GUARD);
            if (skillContainer != null && (skill = skillContainer.getSkill()) instanceof HoldableSkill) {
                HoldableSkill holdableSkill = (HoldableSkill)skill;
                if (skillContainer.isActivated()) {
                    skillContainer.deactivate();
                }
            }
            executor.playAnimationSynchronized(CHARGING_ANIM, 0.0f);
        }
    }

    private void releaseAttack(SkillContainer container, int chargeTime, Object player, boolean isAutoTrigger) {
        PlayerPatch executor = container.getExecutor();
        SkillDataManager data = container.getDataManager();
        if (this.isPlayingChargeAnimation(executor)) {
            return;
        }
        this.resetChargeState(data, player);
        this.playAttackAnimation(container, chargeTime, isAutoTrigger);
    }

    private void playAttackAnimation(SkillContainer container, int chargeTime, boolean isAutoTrigger) {
        AnimationManager.AnimationAccessor anim;
        PlayerPatch executor = container.getExecutor();
        SkillDataManager data = container.getDataManager();
        if (executor.getEntityState().inaction()) {
            return;
        }
        boolean isFullCharge = false;
        if (chargeTime >= 46) {
            anim = ((StaticAnimation)FULL_CHARGE_ANIM.get()).getAccessor();
            isFullCharge = true;
        } else if (chargeTime >= 20) {
            anim = ((StaticAnimation)FULL_CHARGE_ANIM.get()).getAccessor();
            executor.playSound((SoundEvent)SoundEvents.f_12377_.m_203334_(), 100.0f, 0.0f, 0.0f);
            isFullCharge = true;
        } else {
            anim = ((StaticAnimation)LOW_CHARGE_ANIM.get()).getAccessor();
            executor.playSound((SoundEvent)SoundEvents.f_12377_.m_203334_(), 100.0f, 0.0f, 0.0f);
        }
        this.resetChargeState(data, executor.getOriginal());
        executor.playAnimationSynchronized((AssetAccessor)anim, -0.05f);
        if (!executor.isLogicalClient() && isFullCharge) {
            ServerPlayer serverPlayer = (ServerPlayer)executor.getOriginal();
            Vec3 pos = serverPlayer.m_20182_();
            serverPlayer.m_284548_().m_8767_((ParticleOptions)ParticleTypes.f_123809_, pos.f_82479_, pos.f_82480_ + 1.0, pos.f_82481_, 15, 0.5, 0.2, 0.5, 0.5);
        }
    }

    private void resetChargeState(SkillDataManager data, Object player) {
        if (player instanceof ServerPlayer) {
            data.setDataSync(EFNDataKey.isCharging(), (Object)false, (ServerPlayer)player);
            data.setDataSync(EFNDataKey.chargeTicks(), (Object)0, (ServerPlayer)player);
            data.setDataSync(EFNDataKey.isPressing(), (Object)false, (ServerPlayer)player);
        } else if (player instanceof LocalPlayer) {
            data.setDataSync(EFNDataKey.isCharging(), (Object)false, (LocalPlayer)player);
            data.setDataSync(EFNDataKey.chargeTicks(), (Object)0, (LocalPlayer)player);
            data.setDataSync(EFNDataKey.isPressing(), (Object)false, (LocalPlayer)player);
        } else {
            data.setData(EFNDataKey.isCharging(), (Object)false);
            data.setData(EFNDataKey.chargeTicks(), (Object)0);
            data.setData(EFNDataKey.isPressing(), (Object)false);
        }
        this.hasAutoTriggered = true;
    }

    private void validateServerState(SkillContainer container) {
        ServerPlayerPatch serverPatch = (ServerPlayerPatch)container.getExecutor();
        SkillDataManager data = container.getDataManager();
        Integer cooldown = (Integer)data.getDataValue(EFNDataKey.COOLDOWN.get());
        if (cooldown != null && cooldown > 0) {
            return;
        }
        if (((Boolean)data.getDataValue(EFNDataKey.isCharging())).booleanValue()) {
            container.getExecutor().resetActionTick();
            int currentTime = (Integer)data.getDataValue(EFNDataKey.chargeTicks());
            int newTime = Math.min(currentTime + 1, 46);
            data.setDataSync(EFNDataKey.chargeTicks(), (Object)newTime, (ServerPlayer)serverPatch.getOriginal());
            float currentStamina = serverPatch.getStamina();
            if (newTime % 4 == 0) {
                if (currentStamina >= 0.7f) {
                    serverPatch.setStamina(currentStamina - 0.7f);
                } else {
                    this.forceReleaseDueToLowStamina(container, serverPatch);
                    return;
                }
            }
            if (currentStamina < 1.0f) {
                this.forceReleaseDueToLowStamina(container, serverPatch);
                return;
            }
            if (newTime % 20 == 0 && newTime > 0) {
                int seconds = newTime / 20;
                data.setDataSync(EFNDataKey.chargeMessage(), (Object)seconds, (ServerPlayer)serverPatch.getOriginal());
            }
        }
    }

    private void forceReleaseDueToLowStamina(SkillContainer container, ServerPlayerPatch serverPatch) {
        SkillDataManager data = container.getDataManager();
        Integer cooldown = (Integer)data.getDataValue(EFNDataKey.COOLDOWN.get());
        if (cooldown != null && cooldown > 0) {
            return;
        }
        int chargeTime = (Integer)data.getDataValue(EFNDataKey.chargeTicks());
        data.setDataSync(EFNDataKey.isCharging(), (Object)false, (ServerPlayer)serverPatch.getOriginal());
        data.setDataSync(EFNDataKey.chargeTicks(), (Object)0, (ServerPlayer)serverPatch.getOriginal());
        data.setDataSync(EFNDataKey.isPressing(), (Object)false, (ServerPlayer)serverPatch.getOriginal());
        data.setDataSync(EFNDataKey.COOLDOWN.get(), (Object)20, (ServerPlayer)serverPatch.getOriginal());
        this.hasAutoTriggered = true;
        if (chargeTime > 0) {
            serverPatch.playAnimationSynchronized((AssetAccessor)((StaticAnimation)LOW_CHARGE_ANIM.get()).getAccessor(), 0.1f);
        }
        serverPatch.playSound(SoundEvents.f_12008_, 1.0f, 0.0f, 0.0f);
    }

    private boolean isPlayingChargeAnimation(PlayerPatch<?> playerPatch) {
        AnimationPlayer chargingAnim = playerPatch.getAnimator().getPlayerFor(CHARGING_ANIM);
        AnimationPlayer fullChargeAnim = playerPatch.getAnimator().getPlayerFor(FULL_CHARGE_ANIM);
        AnimationPlayer lowChargeAnim = playerPatch.getAnimator().getPlayerFor(LOW_CHARGE_ANIM);
        return chargingAnim != null && chargingAnim.getAnimation() == CHARGING_ANIM.get() || fullChargeAnim != null && fullChargeAnim.getAnimation() == FULL_CHARGE_ANIM.get() || lowChargeAnim != null && lowChargeAnim.getAnimation() == LOW_CHARGE_ANIM.get();
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        ArrayList list = Lists.newArrayList();
        list.add(Component.m_237115_((String)"skill.efn.ruinsgreatsword.tooltip").m_130940_(ChatFormatting.AQUA));
        list.add(Component.m_237115_((String)"skill.efn.ruinsgreatsword.tooltip1").m_130940_(ChatFormatting.AQUA).m_7220_(InvincibleKeyMappings.KEY3.m_90863_()));
        list.add(Component.m_237115_((String)"skill.efn.ruinsgreatsword.tooltip2"));
        list.add(Component.m_237115_((String)"skill.efn.ruinsgreatsword.tooltip3").m_130940_(ChatFormatting.AQUA));
        list.add(Component.m_237115_((String)"skill.efn.ruinsgreatsword.tooltip4"));
        return list;
    }
}

